(function() {
	tinymce.PluginManager.requireLangPack('smilies');

	tinymce.create('tinymce.plugins.CommunityServerSmiliesPlugin', {
		init : function(ed, url) {
			ed.addCommand('mceSmilies', function() {
				ed.windowManager.open({
					file : url + '/smilies.htm',
					width : 160 + ed.getLang('smilies.delta_width', 0),
					height : 160 + ed.getLang('smilies.delta_height', 0),
					inline : 1
				}, {
					plugin_url : url,
					smilies : (tinyMCE_CommunityServerOptions && tinyMCE_CommunityServerOptions.Smilies) ? tinyMCE_CommunityServerOptions.Smilies : new Array()
				});
			});

			ed.addButton('smilies', {
				title : 'smilies.desc',
				cmd : 'mceSmilies',
				image : url + '/img/smiley.gif'
			});
		},

		createControl : function(n, cm) {
			return null;
		},

		getInfo : function() {
			return {
				longname : 'Smilies',
				author : 'Telligent Systems',
				authorurl : 'http://telligentsystems.com/',
				infourl : 'http://telligentsystems.com/',
				version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
			};
		}
	});

	tinymce.PluginManager.add('smilies', tinymce.plugins.CommunityServerSmiliesPlugin);
})();