<%@ WebHandler Language="C#" Class="HttpTest" %>

using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Web;
using CommunityServer.WebServices.Serialization.Common;
using CommunityServer.WebServices.Services.Common;
using CommunityServer.WebServices.Services.Common.Rest;
using System.Net;
using System.Xml;
using System.Xml.Serialization;
using CommunityServer.Components;


public class HttpTest : CommunityServer.WebServices.Services.Common.CSRequestHandler
{

    [RestMethod]
    public virtual ResourceResponse Test(RequestInfo ri)
    {
        ResourceResponse resp = new ResourceResponse();

        switch (ri.RequestType)
        {

            case RequestType.Get:

                resp.Body = "GET";
                break;

            case RequestType.Post:

                resp.Body = "POST";
                break;

            case RequestType.Head:

                resp.Body = null;
                break;

            case RequestType.Delete:

                resp.Body = "DELETE";
                break;

            case RequestType.Put:

                resp.Body = "PUT";
                break;

            default:

                resp.StatusCode = HttpStatusCode.MethodNotAllowed;
                Error badRequestType = new Error();
                badRequestType.Type = HttpStatusCode.MethodNotAllowed;
                badRequestType.Message = "The request type " + ri.RequestType.ToString() + " is not supported";
                resp.Body = badRequestType;

                break;
        }



        return resp;
    }

    [RestMethod]
    public virtual ResourceResponse Loopback(RequestInfo ri)
    {
        ResourceResponse resp = new ResourceResponse();
        switch (ri.RequestType)
        {

            case RequestType.Get:
            case RequestType.Head:
            case RequestType.Delete:

                //string headerXml = HttpHeaderXml(ri.Context.Request);
                resp.Body = GetHttpHeader(ri.Context.Request);
                break;

            case RequestType.Post:
            case RequestType.Put:
                StreamReader reader;
                StringBuilder sbSource;
                reader = new StreamReader(ri.Context.Request.InputStream);

                // Read it into a StringBuilder   
                sbSource = new StringBuilder(reader.ReadToEnd());

                // Console application output   
                string postedXml = sbSource.ToString();

                resp.Body = postedXml;

                break;

            default:

                resp.StatusCode = HttpStatusCode.MethodNotAllowed;
                Error badRequestType = new Error();
                badRequestType.Type = HttpStatusCode.MethodNotAllowed;
                badRequestType.Message = "The request type " + ri.RequestType.ToString() + " is not supported";
                resp.Body = badRequestType;

                break;
        }
        
        return resp;
    }

    [RestMethod("Authenticated", RequestType.Get, true)]
    public virtual ResourceResponse Authenticated(RequestInfo ri)
    {
        ResourceResponse resp = new ResourceResponse();
        resp.Body = string.Format("<h1>Welcome {0}</h1>", CSContext.Current.User.Username);
        return resp;
    }
    protected override string WriteHelp(HttpContext context)
    {
        return "<h1>Welcome to the Rest Test API</h1>";
    }

    public static string HttpHeaderXml(HttpRequest request)
    {
        StringWriter sr = new StringWriter();
        XmlTextWriter writer = new XmlTextWriter(sr);

        XmlSerializer ser;

        HttpHeader headers = GetHttpHeader(request);

        ser = new XmlSerializer(headers.GetType());
        ser.Serialize(writer, headers);

        writer.Close();

        return sr.ToString();
    }

    public static HttpHeader GetHttpHeader(HttpRequest request)
    {
        HttpHeader header = new HttpHeader();
        header.Accept = string.Join(",", request.AcceptTypes);
        header.Method = request.HttpMethod;
        header.Type = request.ContentType;
        header.Length = request.ContentLength;

        List<HttpHeaderItem> items = new List<HttpHeaderItem>();

        foreach (string key in request.Headers.AllKeys)
        {
            //if (!s.equals("HTTP-Version")      && !s.equals("Status-Code") &&
            //        !s.equals("Reason-Phrase") && !s.equals("Method") &&
            //        !s.equals("Request-URI")   && !o.isNull(s)) {
            HttpHeaderItem i = new HttpHeaderItem();
            i.Key = key;
            i.Value = request.Headers[key];
            items.Add(i);
        }

        header.Headers = items.ToArray();

        List<HttpHeaderItem> serverItems = new List<HttpHeaderItem>();

        foreach (string key in request.ServerVariables.AllKeys)
        {
            //if (!s.equals("HTTP-Version")      && !s.equals("Status-Code") &&
            //        !s.equals("Reason-Phrase") && !s.equals("Method") &&
            //        !s.equals("Request-URI")   && !o.isNull(s)) {
            HttpHeaderItem i = new HttpHeaderItem();
            i.Key = key;
            i.Value = request.ServerVariables[key];
            serverItems.Add(i);
        }

        header.ServerVariables = serverItems.ToArray();

        return header;
    }

}

[Serializable]
[XmlRoot("header")]
[XmlType("header")]
public class HttpHeader
{
    [XmlElement("version")]
    public string Version;

    [XmlElement("accept")]
    public string Accept;

    [XmlElement("method")]
    public string Method;

    [XmlElement("type")]
    public string Type;

    [XmlElement("length")]
    public long Length;

    [XmlArray("headers")]
    [XmlArrayItem("header")]
    public HttpHeaderItem[] Headers;

    [XmlArray("servervariables")]
    [XmlArrayItem("var")]
    public HttpHeaderItem[] ServerVariables;

}

[Serializable]
public class HttpHeaderItem
{
    [XmlAttribute("key")]
    public string Key;

    [XmlAttribute("value")]
    public string Value;

}
