<%@ Control Language="C#" AutoEventWireup="true" %>

<script runat="server" language="C#">

    IPager scrollingPager = null;
    
    public string GetScrollingItemIndex(int itemIndex)
    {
        if (scrollingPager == null)
            scrollingPager = CSControlUtility.Instance().FindControl(this, "MediaSelector") as IPager;

        if (scrollingPager != null)
            return ((scrollingPager.PageSize * scrollingPager.PageIndex) + itemIndex).ToString();
        else
            return itemIndex.ToString();
    }

</script>

<script type="text/javascript">
// <!--

var slideshow_currentIndex = -1;
var slideshow_currentItem = null;
var slideshow_playHandle = null;
var slideshow_timeout = 9999;
var slideshow_playing = false;

function slideshow_showItem(element)
{
    slideshow_showItemByIndex(parseInt(element.id.split('-')[1], 10));
}

function slideshow_showItemByIndex(index)
{
    if (slideshow_currentIndex != index && slideshow_currentIndex >= 0)
        slideshow_currentItem.style.backgroundColor = '';
    
    slideshow_currentIndex = index;
    slideshow_highlightCurrentItem();
    eval('<%= CSControlUtility.Instance().FindControl(this, "MediaPager").ClientID %>').GoToPage(index + 1);
    
    var scrollIndex = index - Math.floor((document.getElementById('slideShowItems').offsetWidth / 180) - .5);
    if (scrollIndex < 0)
        scrollIndex = 0;
    
    eval('<%= CSControlUtility.Instance().FindControl(this, "MediaSelector").ClientID%>').MoveTo(scrollIndex);
}

function slideshow_highlightCurrentItem()
{
    var element = document.getElementById('slideShowItem-' + slideshow_currentIndex);
    if (element)
    {
        slideshow_currentItem = element;
        slideshow_currentItem.style.backgroundColor = '#ccc'; 
    }
    else
        window.setTimeout(slideshow_highlightCurrentItem, 249);
}

function slideshow_moveNext()
{
    if (slideshow_currentIndex + 1 < eval('<%= CSControlUtility.Instance().FindControl(this, "MediaSelector").ClientID%>').GetItemCount())
        slideshow_showItemByIndex(slideshow_currentIndex + 1);
    else if (eval('<%= CSControlUtility.Instance().FindControl(this, "MediaSelector").ClientID%>').GetItemCount() > 0)
        slideshow_showItemByIndex(0);
    
    window.clearTimeout(slideshow_playHandle);
    if (slideshow_playing)
        slideshow_playHandle = window.setTimeout(slideshow_moveNext, slideshow_timeout);
}

function slideshow_initialize()
{
    var item = document.getElementById('slideShowItem-0');
    if (item == null || !eval('window.<%= CSControlUtility.Instance().FindControl(this, "MediaPager").ClientID %>') || !eval('window.<%= CSControlUtility.Instance().FindControl(this, "MediaSelector").ClientID%>'))
        window.setTimeout(slideshow_initialize, 499);
    else
    {
        slideshow_showItemByIndex(0);
        slideshow_play();
    }
}

function slideshow_mouseover(element)
{
    element.style.backgroundColor = '#eee';
}

function slideshow_mouseout(element)
{
    if (element != slideshow_currentItem)
        element.style.backgroundColor = '';
    else
        element.style.backgroundColor = '#ccc';                
}

function slideshow_togglePlay()
{
    if (slideshow_playing)
        slideshow_stop();
    else
        slideshow_play();                  
}

function slideshow_stop()
{
    slideshow_playing = false;
    window.clearTimeout(slideshow_playHandle);
    document.getElementById('slideshowPlayButton').innerHTML = 'Slideshow Paused';
}

function slideshow_play()
{
    if (!slideshow_playing)
    {
        slideshow_playing = true;
        slideshow_playHandle = window.setTimeout(slideshow_moveNext, slideshow_timeout);
        document.getElementById('slideshowPlayButton').innerHTML = 'Slideshow Playing';
    }
}

// -->
</script>

<div onmouseover="slideshow_stop();" onmouseout="slideshow_play();" style="background-color: #eee; padding: 8px; border: solid 1px #ddd;">
    <CSControl:CallbackPager runat="server" ID="MediaPager" ShowPagerItems="false" ShowTotalSummary="false">
        <PagedContent>
            <CSMedia:MediaGalleryPostList runat="server">
                <QueryOverrides SortBy="PostDate" SortOrder="Descending" PageSize="1" PagerID="MediaPager" />
                <ItemTemplate>
                    <div style="text-align: center;">
                        <CSMedia:MediagalleryPostData runat="server" LinkTo="View" Property="Subject" Tag="Div" Style="font-weight: bold; font-size: 110%; padding: 8px 0;" />
                        <div style="width: 400px; min-height: 300px; background-color: #000; color: #fff;  margin: 0 auto; padding: 2px;">
                            <table cellpadding="0" cellspacing="0" border="0" style="width: 400px; height: 300px;"><tr valign="middle"><td align="center">
                                <CSMedia:MediaGalleryPostViewer ID="FileViewer" runat="server" ViewType="View" Width="400" Height="300" />
                                <CSControl:PlaceHolder runat="server">
                                    <DisplayConditions><CSControl:ControlVisibilityCondition runat="server" ControlId="FileViewer" ControlVisiblilityEquals="false" /></DisplayConditions>
                                    <ContentTemplate>This file cannot be viewed.</ContentTemplate>
                                </CSControl:PlaceHolder>
                            </td></tr></table>
                        </div>
                    </div>
                </ItemTemplate>
            </CSMedia:MediaGalleryPostList>
        </PagedContent>
    </CSControl:CallbackPager>
    <div style="text-align: center; background-color: #eee; padding: 8px 0; color: #999;">
        <div id="slideshowPlayButton">&nbsp;</div>
    </div>
    <div>
        <div style="float: left; margin-top: 24px;">
            <CSControl:ScrollingPagerData ScrollingPagerID="MediaSelector" LinkTo="PreviousPage" runat="server">
                <ContentTemplate><CSControl:Image runat="server" ImageUrl="~/utility/usercontrols/previous.gif" BorderWidth="0" /></ContentTemplate>
            </CSControl:ScrollingPagerData>
        </div>
        <div style="float: right; margin-top: 24px;">
            <CSControl:ScrollingPagerData ScrollingPagerID="MediaSelector" LinkTo="NextPage" runat="server">
                <ContentTemplate><CSControl:Image runat="server" ImageUrl="~/utility/usercontrols/next.gif" BorderWidth="0" /></ContentTemplate>
            </CSControl:ScrollingPagerData>
        </div>
        <CSControl:ScrollingPager runat="server" ID="MediaSelector" ItemWidth="90" ItemHeight="58" ContainerId="slideShowItems" Tag="Div" style="border: solid 1px #ddd; padding: 4px; margin: 0 20px; background-color: #fff;">
            <PagedContent>
                <CSMedia:MediaGalleryPostList runat="server">
                    <QueryOverrides SortBy="PostDate" SortOrder="Descending" PageSize="10" PagerID="MediaSelector" />
                    <ItemTemplate>
                        <CSControl:ScrollingPagerItem runat="server" ScrollingPagerID="MediaSelector">
                            <div id="slideShowItem-<%# GetScrollingItemIndex(Container.ItemIndex) %>" style="width: 64px; height: 48px; margin: 0 8px; padding: 4px; border: solid 1px #eee; overflow: hidden; text-align: center; cursor: pointer;" onmouseover="slideshow_mouseover(this);" onmouseout="slideshow_mouseout(this);" onclick="slideshow_showItem(this);">
                                <div style="width: 64px; height: 32px; overflow: hidden; margin: 0 auto; text-align: center;">
                                    <CSMedia:MediaGalleryPostViewer runat="server" ViewType="Preview" Width="64" Height="32" />
                                </div>
                                <CSMedia:MediagalleryPostData runat="server" Property="Subject" TruncateAt="10" Tag="Div" style="white-space: nowrap; font-size: 85%;" />
                            </div>
                        </CSControl:ScrollingPagerItem>
                    </ItemTemplate>
                </CSMedia:MediaGalleryPostList>
            </PagedContent>
            <PagerLoadingTemplate>
                <CSControl:Image runat="server" ImageUrl="~/utility/spinner.gif" /> <CSControl:ResourceControl runat="server" ResourceName="Loading" />...
            </PagerLoadingTemplate>
        </CSControl:ScrollingPager>
        <div style="clear: both;"></div>
    </div>
</div>

 <script type="text/javascript">
// <!--

slideshow_initialize();

// -->
</script>