﻿<%@ Page Language="C#" CodeBehind="default.aspx.cs" Inherits="CommunityServer.Web.Installer" %>
<%@ Import Namespace="CommunityServer.Web"%>
<script runat="server">

protected override void OnInit(EventArgs e)
{
	/*********************************************************************************
	To enable the web based installer change the line beneath this section to ‘true’.
	After installation is complete, it is highly recommended that you delete the
	Installer directory to disable unauthorized access.
	*********************************************************************************/
	InstallerEnabled = false;
}

</script>
<html>
<head>
<title>Community Server Web Installer</title>
<link rel="stylesheet" href="style/installer.css" type="text/css" />
<script type="text/javascript">
function setEnabled(id, enabled) {
	var element = document.getElementById(id);
	if (element) element.disabled = !enabled;
}
</script>
</head>
<body>
<form id="InstallForm" runat="server">
<table height="100%" width="100%" align="center"><tr><td align="center" valign="middle">
	<table height="525" cellSpacing="0" cellPadding="0" width="650" border="0" style="background-color: #ffffff; border: solid 1px #999999;">
		<tbody>
			<tr>
				<td valign="top" height="98" background="images/headerbg.gif" style="background-repeat:repeat-x"><img src="images/topHeader.gif" width="496" height="98"></td>
			</tr>
			<tr>
				<td valign="top">

<div style="padding-right: 10px; padding-left: 10px; padding-bottom: 10px; padding-top: 30px">
<asp:panel id="Welcome" runat="server" Visible="false">
    <div class="mainTitle">Welcome to the Community Server 2008.5 SP1 remote installation wizard.</div>
	<div><br/><strong>Requirements:</strong></div>
    <div style="padding-left: 10px; padding-top: 10px">
		<ul>
			<li style="margin-bottom: 8px;"><div class="bold">Microsoft .NET Framework</div>
				<div>Version 2.0 of the .NET framework must be installed</div>
				<div><a href="http://www.asp.net/Default.aspx?tabindex=0&tabid=1" target="_blank">Get help installing the .NET framework</a></div>
			</li>
			<li style="margin-bottom: 8px;"><div class="bold">Internet Information Server</div>
				<div>IIS or compatible web server software must be installed</div>
				<div><a href="http://www.google.com/search?q=install+iis" target="_blank">Get help installing IIS</a></div>
			</li>
			<li><div class="bold">Microsoft SQL Server</div></li>
		</ul>
	</div>
</asp:panel>
<asp:panel id="License" runat="server" Visible="false">
	<table cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td><span class="mainTitle">Community Server License</span></td>
			<td nowrap="nowrap" align="right"><img src="images/printerIcon.gif"> <a href="eula.txt" target="new">Printable Version</a></td>
		</td>
		<tr>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td valign="top" align="right" colspan="2"><iframe frameborder="1" scrolling="yes" src="eula.html" height="250" width="600"></iframe></td>
		</tr>
	</table>
	</div> <br>
	<div align="right" style="padding-right: 20px;">
		<asp:Checkbox id="chkIAgree" runat=server Text=" I Agree" Checked="false" onclick="setEnabled('Next', this.checked);" />
	</div>
</asp:panel>
<asp:panel id="ConnectToDb" runat="server" Visible="false">
    <div class="mainTitle">Community Server Database Login</div>
	<div>Select the database login that Community Server will use to connect to the database.</div>
	<div style="color:red;"><asp:Literal EnableViewState=False id="lblErrMsgConnect" Runat=server /></div>
	<div style="padding-left: 20px; padding-top: 20px">IP address or Server Name:
		<asp:textbox CssClass="dataentry" id="db_server" runat="server" value="(local)"></asp:textbox><br/>
		<asp:RadioButtonList id="db_Connect" runat="server" SelectedIndexChanged="ConnectToDb_CheckChanged">
			<asp:ListItem Value="Windows Authentication" Selected="True">Windows Authentication</asp:ListItem>
			<asp:ListItem Value="SQL Server Authentication">SQL Server Authentication</asp:ListItem>
		</asp:RadioButtonList>
		<div style="padding-left: 20px; padding-top: 20px">
			<table>
				<tr>
					<td align="left">Username:</TD>
					<td align="left">
						<asp:textbox cssclass="dataentry" id="db_login" runat="server"></asp:textbox>
					</td>
				</tr>
				<tr>
					<td align="left">Password:</TD>
					<td align="left">
						<asp:textbox CssClass="dataentry" id="db_password" runat="server" TextMode="Password"></asp:textbox>
					</td>
				</tr>
			</table>
		</div>
	</div>
</asp:panel>
<asp:panel id="SelectDb" runat="server" Visible="false">
    <span class="mainTitle">Select Database Instance</span><br><br>
    <div>Choose the database where you would like to to install Community Server.</div>
    <div style="padding-left: 20px; padding-top: 20px">
		<div style="padding-left: 20px; padding-top: 10px;color: red"><asp:Literal EnableViewState=False id="lblErrMsg" Runat=server /></div>
		<div style="padding-left: 20px; padding-top: 10px">Available databases:
			<asp:DropDownList id="db_name_list" runat="server"></asp:DropDownList>
		</div>
	</div>
</asp:panel>
<asp:panel id="ScriptOptions" runat="server" Visible="false">
	<span class="mainTitle">Choose Installation Options</span><br><br>
	<div>Select the installation options below to control how your database is created.</div>
	<div style="padding-left: 20px; width: 100%; padding-top: 20px">
		<asp:CheckBox id="chkScriptMemberRoles" runat="server" Text="Script ASP.NET MemberRoles" Checked="True" CssClass="bold"></asp:CheckBox>
		<div style="padding-left: 20px; padding-bottom: 10px">
			This option will create the ASP.NET MemberRoles information and remove the objects if they are already present. If you're installing into a shared database with other MemberRole compatible applications please uncheck this option.
		</div>
		<asp:CheckBox id="chkCreateSample" runat="server" Text="Create Sample Data" Checked="False" CssClass="bold"></asp:CheckBox>
		<div style="padding-left: 20px; padding-bottom: 10px">
			Select this option if you would like to create sample data in your newly-created comunity.
		</div>
	</div>
</asp:panel>
<asp:panel id="CreateCommunity" runat="server" Visible="false">
	<span class="mainTitle">Create new Community</span><br><br>
	<div>Enter the following information to create a new Community Server instance in the database. </div>
	<div style="padding-left: 15px; padding-top: 15px">
			<table cellpadding="2" cellspacing="0" border="0">
				<tr>
					<td colspan="3" align="left" style="padding-top: 20px; padding-bottom: 10px;">
						Enter the username, password, and email address you would like to use for the administrator account of your new Community Server site.
					</td>
				</tr>
				<tr>
					<td align="left" valign="top">Username:</TD>
					<td align="left" colspan="2">
						<asp:textbox CssClass="dataentry" id="cs_username_login" runat="server">admin</asp:textbox>
						<asp:requiredfieldvalidator id="req_cs_username_login" runat="server" controltovalidate="cs_username_login" enabled="true" display="Dynamic"><br>* Username is required!</asp:requiredfieldvalidator>
					</td>
				</tr>
				<tr>
					<td align="left" valign="top">Password:</TD>
					<td align="left">
						<asp:textbox CssClass="dataentry" id="cs_password_login" runat="server" TextMode="Password"></asp:textbox>
						<asp:requiredfieldvalidator id="req_cs_password_login" runat="server" controltovalidate="cs_password_login" enabled="true" display="Dynamic"><br>* Password does not meet requirements!</asp:requiredfieldvalidator>
					</td>
					<td rowspan="2" valign="top">The password must be at least 5 characters.</td>
				</tr>
				<tr>
					<td align="left" valign="top">Confirm Password:</td>
					<td align="left">
						<asp:textbox CssClass="dataentry" id="cs_password_login_confirm" runat="server" TextMode="Password"></asp:textbox>
						<asp:comparevalidator EnableClientScript="True" Enabled="True" id="ComparePassword" runat="server" ControlToValidate="cs_password_login_confirm" ControlToCompare="cs_password_login" Cssclass="color:red" display="Dynamic"><br>* Passwords do not match!</asp:comparevalidator>
					</td>
				</tr>
				<tr>
					<td align="left" valign="top">Admin Email Address:</TD>
					<td align="left" colspan="2">
						<asp:textbox cssclass="dataentry" id="cs_admin_email" runat="server"></asp:textbox>
						<asp:requiredfieldvalidator id="req_cs_admin_email" runat="server" controltovalidate="cs_admin_email" enabled="true" display="Dynamic"><br>* Admin Email is required!</asp:requiredfieldvalidator>
					</td>
				</tr>
			</TABLE>
		</P>
	</DIV>
</asp:panel>
<asp:panel id="Install" runat="server" Visible="false">
	<span class="mainTitle">Installing Database</span>
</asp:panel>
<asp:panel id="Done" runat="server" Visible="false">
	<span class="mainTitle">Complete!</span><br><br>
	<div>
		<asp:Panel id="ConfigNeedUpdating" Runat="server" Visible="true">
Please update your connectionStrings.config with the following information:<br />
<textarea style="width:100%" rows="6" onfocus="javascript:this.select();">
&lt;connectionStrings&gt;
  &lt;add name="SiteSqlServer" connectionString="<%= GetDatabaseConnectionString() %>" /&gt;
&lt;/connectionStrings&gt;
</textarea>
			<p>Once you've updated your connectionStrings.config click <a href='<%= @"http://" + GetSiteUrl() %>'/>here</a> to navigate to your new site.</p>
		</asp:Panel>
		<asp:Panel id="ConfigDoneUpdating" runat="server" Visible="false">
			Your connectionStrings.config file was successfully updated with the new connection string.
			<p>Click <a href='<%= @"http://" + GetSiteUrl() %>'/>here</a> to navigate to your new site.</p>
		</asp:Panel>
		<div style="color:red">
		    <b><u>IMPORTANT</u></b>: 
		    <br />
		    Please grant the filestorage folder modify access in order for the centralized file storage system to work correctly.
		    <br />
		    You should now have a working Community Server installation. It is <u>strongly recommended</u> that you delete the Installer directory to prevent unauthorized access to your server.
		</div>
	</div>
</asp:panel>
<asp:Panel id="SchemaExists" runat=server Visible=false >
	<span class="mainTitle">Schema Already Exists</span><br><br>
	<div>
		The Installer does not support installing Community Server into a database with an existing Community Server schema. Please run the appropriate upgrade script to upgrade your database.
	</div>
</asp:Panel>
<asp:Panel id="Errors" runat=server Visible=false >
	<span class="mainTitle">Errors Occurred</span><br><br>
	<div>
		Errors occured during the execution of this wizard.
	</div>
	<asp:Repeater id="lstMessages" Runat="server">
		<HeaderTemplate>
			<table class="err" width="580px" border=0 cellpadding=0 cellspacing=0 >
				<tr>
					<th class="err" width="100px">Module</th>
					<th class="err" >Message</th>
				</tr>
		</HeaderTemplate>
		<ItemTemplate>
				<tr valign="top">
					<td class="err"><%# ((InstallerMessage)Container.DataItem).Module %></td>
					<td class="err"><%# ((InstallerMessage)Container.DataItem).Message %></td>
				</tr>
		</ItemTemplate>
		<FooterTemplate>
			</table>
		</FooterTemplate>
	</asp:Repeater>
</asp:Panel>
</div>
				</td>
			</tr>
			<tr>
				<td align="right" bgcolor="#95B6C3" height="45">
					<div style="padding-right: 30px;">
						<asp:button id="Previous" UseSubmitBehavior="false" CausesValidation="false" onclick="PreviousPanel" runat="server" text="< Previous" cssClass="buttons"></asp:button>&nbsp;
						<asp:button id="Next" onclick="NextPanel" runat="server" CausesValidation="true" text="Next >" cssClass="buttons"></asp:button>
					</div>
				</td>
			</tr>
		</tbody>
	</table>
</td></tr></table>
</form>
</body>
</html>