<%@ Page language="c#" Codebehind="WikiComments.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.ManageWikis.WikiComments" MasterPageFile="~/ControlPanel/Masters/Wikis.master" %>
<%@ Import Namespace="CommunityServer.Components" %>
<%@Import Namespace="CommunityServer.Wikis.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol id="SectionDescription" runat="server" resourcename="CP_Wiki_Comments_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation runat="server" SelectedNavItem="WikiComments" />
	<div class="CommonDescription">
		<cp:resourcecontrol id="Section_Sub_Description" runat="server" resourcename="CP_Wiki_Comments_SubTitle" />
	</div>
	
    <script type = "text/javascript">
    function redirectUrl() {
        var filterPage = document.getElementById("pageId");
        var url = window.location.pathname + '?pid=' + filterPage.value;
        window.location = url;
    }

    function checkAll(cb, parent)
    {
	    var p =$(parent);
	    var pa = p.getElementsByTagName('INPUT');
	    for(var i=0; i<pa.length; i++)
	    {
		    var e = pa[i];
		    if(e.getAttribute('type') == 'checkbox' && e.name != cb.name)
		    {
		        e.checked = cb.checked;
		    }
	    }
    }

    function bulkEdit(action)
    {
        var result = 'action=' + action + '&cids=';
        var cb = $('master');
	    var pa = $('CommentListing').getElementsByTagName('INPUT');
	    var b = true;
	    for(var i=0; i<pa.length; i++)
	    {
		    var e = pa[i];
		    if(e.getAttribute('type') == 'checkbox' && e.name != cb.name && e.checked)
		    {
		        var delimit = ',';
		        if(b)
		        {
	        	    delimit = '';
	        	    b = false;    
		        }
                result += e.name.replace('cb-',delimit);
		    }
	    }
    	
	    if(window.location.search)
          window.location =   window.location + '&' + result;    
        else
          window.location =   window.location + '?' + result;
    }

    </script>	
    <input type="hidden" id="pageId" value="<%= Request.QueryString["pid"] %>" />
    <div>
        <input style="visibility:<%= MassEditVisibility() %>" type="button" onclick="if(confirm('<%= CommunityServer.Components.ResourceManager.GetString("FeedbackEditor_BulkDeleteSelected") %>')){bulkEdit('delete');}" value='<%= CommunityServer.Components.ResourceManager.GetString("FeedbackEditor_DeleteSelected", "ControlPanelResources.xml") %>' />
    </div>

    <div class="CommonListArea">
    <CSControl:WrappedRepeater ShowHeaderFooterOnNone="false" runat = "Server" id="theComments">
    <HeaderTemplate>
        <table id="CommentListing" cellSpacing="0" cellPadding="0" border="0" width="100%">
	        <thead>
		        <tr>
			        <th class="CommonListHeaderLeftMost" width="20px"><input type="checkbox" name="master" id="master" onclick="checkAll(this,'CommentListing');" /></th>
			        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_Comments_Comment"/></th>
			        <th class="CommonListHeader">&nbsp;</th>											
		        </tr>
	        </thead>
    </HeaderTemplate>
    <ItemTemplate>
	    <tr>
	    <td class="CommonListCellLeftMost"><input type="checkbox" name="cb-<%# DataBinder.Eval(Container.DataItem,"ID") %>" /></td>
	    <td class="CommonListCell">
		    <a href='<%# WikiUrls.Instance().Comments(((PageComment)Container.DataItem).Page) %>'>
	        <strong><%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PublishedDate")).ToString("MMM d, yyyy hh:mm tt")%></strong></a>
            <br />
	        <%# ForceExcerpt((PageComment)Container.DataItem)%>
	        <div style="font-size:.8em; color:#959595">
	        <CP:ResourceControl runat="server" ResourceName="CP_Blog_Comments_By" />
	        <%# RenderName( (PageComment) Container.DataItem ) %>
	        </div>
	    </td>
	    <td  class="CommonListCell Status" width="180px">
		    <input type="button" onclick="javascript:Telligent_Modal.Open('commenteditor.aspx?PageCommentID=<%# DataBinder.Eval(Container.DataItem,"ID") %>', 625, 475, refreshCallback);" value="Edit" />
		    <input type="button" onclick="if(confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Wiki_Comments_Delete_Warning") %>')){window.location='<%# GetActionUrl("delete",DataBinder.Eval(Container.DataItem, "ID"))%>';}" value="<%# ResourceManager.GetString("CP_Blog_GridCol_Delete", "ControlPanelResources.xml")%>" />
	    </td>
	    </tr>
    </ItemTemplate>
    <AlternatingItemTemplate>
	    <tr class="AltListRow">
	    <td class="CommonListCellLeftMost"><input type="checkbox" name="cb-<%# DataBinder.Eval(Container.DataItem,"ID") %>" /></td>
	    <td class="CommonListCell">
		    <a href='<%# WikiUrls.Instance().Comments(((PageComment)Container.DataItem).Page) %>'>
	        <strong><%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PublishedDate")).ToString("MMM d, yyyy hh:mm tt")%></strong></a>
            <br />
	        <%# ForceExcerpt((PageComment)Container.DataItem)%>
	        <div style="font-size:.8em; color:#959595">
	        <CP:ResourceControl runat="server" ResourceName="CP_Blog_Comments_By" />
	        <%# RenderName( (PageComment) Container.DataItem ) %>
	        </div>
	    </td>
	    <td  class="CommonListCell Status" width="180px">
		    <input type="button" onclick="javascript:Telligent_Modal.Open('commenteditor.aspx?PageCommentID=<%# DataBinder.Eval(Container.DataItem,"ID") %>', 625, 475, refreshCallback);" value="Edit" />
		    <input type="button" onclick="if(confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Wiki_Comments_Delete_Warning") %>')){window.location='<%# GetActionUrl("delete",DataBinder.Eval(Container.DataItem, "ID"))%>';}" value="<%# ResourceManager.GetString("CP_Blog_GridCol_Delete", "ControlPanelResources.xml")%>" />
	    </td>
	    </tr>
    </AlternatingItemTemplate>	
    <NoneTemplate>
        <div class="CommonMessageWarning">
            <table>
                <tr>
                    <td style="width:35px">
		                <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" />
                    </td>
                    <td>
                        <CP:ResourceControl runat="server" ResourceName="CP_Wiki_Comments_NoComments" />
                    </td>
                </tr>
            </table>
        </div>
    </NoneTemplate>		
    </CSControl:WrappedRepeater>
    </table>

    <asp:Panel id="HideWhenNoResults" runat="server">
        <div style="margin-top: 5px">
        <table cellpadding="0" cellspacing="0" border="0"  width="100%">
            <tr>
	            <td align="left">
	                <input type="button" onclick="if(confirm('<%= CommunityServer.Components.ResourceManager.GetString("FeedbackEditor_BulkDeleteSelected") %>')){bulkEdit('delete');}" value='<%= CommunityServer.Components.ResourceManager.GetString("FeedbackEditor_DeleteSelected", "ControlPanelResources.xml") %>' />
	            </td>
	            <td align="right">
                    <CSControl:Pager runat="Server" id="csPager" MessageText="More Comments" />
	            </td>
            </tr>
        </table>
        </div>
    </asp:Panel>
    </div>
	
</asp:Content>