<%@ Page language="c#" Codebehind="WikiEdit.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.WikiAdmin.WikiEdit" MasterPageFile="~/ControlPanel/Masters/WikiAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<asp:literal id="RegionTitle" runat="server"></asp:literal>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation runat="server" SelectedNavItem="WikiList" />
	<div class="CommonDescription">
		<asp:literal id="RegionDescription" runat="server"></asp:literal>
	</div>
	
    <cp:statusmessage id="Status" runat="server"></cp:statusmessage>
    <TWC:TabbedPanes id="TabStrip" runat="server"
	    PanesCssClass="CommonPane"
	    TabSetCssClass="CommonPaneTabSet"
	    TabCssClasses="CommonPaneTab"
	    TabSelectedCssClasses="CommonPaneTabSelected"
	    TabHoverCssClasses="CommonPaneTabHover"
	    >
	    <TWC:TabbedPane runat="server">
		    <Tab><CP:ResourceControl runat="server" ResourceName="CP_Wiki_WikiEdit_Tab_Basic" /></Tab>
		    <Content>
		    <table cellspacing="0" cellpadding="2" border="0">
	        <tr vAlign="top">
		        <td class="CommonFormFieldName">
			        <strong><CP:FORMLABEL id="Formlabel4" runat="Server" resourcename="CP_Wiki_WikiEdit_Name" controltolabel="WikiName" /></strong>
			        <br />
			        <CP:ResourceControl runat="Server" resourcename="CP_Wiki_WikiEdit_Name_Detail" />
		        </td>
		        <td class="CommonFormField">
			        <asp:textbox id="WikiName" columns="50" runat="server" maxlength="256" />
			        <asp:requiredfieldvalidator id="SectionNameValidator" runat="server" controltovalidate="WikiName">*</asp:requiredfieldvalidator>
			        <asp:RegularExpressionValidator ValidationExpression="^.*[^\s]+.*$" 
                             ControlToValidate="WikiName" Display="dynamic"
                             ErrorMessage="<br/>Name does not contain an alphanumeric character." runat="server" />
		        </td>
	        </tr>
	        <tr>
		        <td class="CommonFormFieldName" style="width:350px">
			        <strong><CP:FORMLABEL id="Formlabel17" runat="Server" resourcename="CP_Wiki_WikiEdit_AppKey" controltolabel="AppKey" /></strong>
			        <br />
			        <CP:ResourceControl runat="Server" resourcename="CP_Wiki_WikiEdit_AppKey_Detail" />
		        </td>
		        <td class="CommonFormField">
			        <ASP:Literal Runat="server" ID="AppKeyUrlPrefix" />
			        <asp:textbox id="AppKey" runat="server"  columns="50" maxlength="256" style="width: 100px;" /><ASP:Literal Runat="server" ID="AppKeyUrlSuffix" />
			        <asp:CustomValidator id="AppKeyValidator" runat="server">*</asp:CustomValidator>
		        </td>
	        </tr>
		    <tr>
			    <td class="CommonFormFieldName" valign="top">
				    <strong><cp:resourcelabel runat="server" resourcename="CP_Wiki_WikiEdit_Description" /></strong><br />
				    <cp:resourcecontrol runat="Server" resourcename="CP_Wiki_WikiEdit_Description_Detail" /></td>
			    <td class="CommonFormField">
				    <asp:textbox id="Description" runat="server" columns="40" maxlength="1000" textmode="MultiLine"
					    rows="3"></asp:textbox>
				    <asp:customvalidator id="DescriptionRequired" runat="server" controltovalidate="Description" font-bold="True"
					    errormessage="*"></asp:customvalidator></td>
		    </tr>
		    <tr>
			    <td class="CommonFormFieldName" nowrap="nowrap">
				    <strong><cp:resourcelabel runat="server" resourcename="CP_Wiki_WikiEdit_Enabled" /></strong><br />
				    <cp:resourcecontrol runat="Server" resourcename="CP_Wiki_WikiEdit_Enabled_Detail" /></td>
			    <td class="CommonFormField">
				    <cp:yesnoradiobuttonlist id="Enabled" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		    </tr>
		    </table>
		    </Content>
	    </TWC:TabbedPane>
	    
	    <TWC:TabbedPane ID="WikiPermissionsTab" runat="server">
		    <Tab><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_SectionEdit_Tab_Permissions" /></Tab>
		    <Content>
		        <div>
                    <asp:DropDownList runat="server" ID="UnchangedPermissionsList" DataTextField="RoleName" DataValueField="RoleName" />
                    <asp:Button runat="server" ID="AddUserPermissionButton" Text="Add Role" />
                </div>
                <br />
                <CP:RepeaterPlusNone runat="server" ID="PermissionList" ShowHeaderFooterOnNone="false">
                    <HeaderTemplate>
                        <table cellSpacing=0 cellPadding=0 width="100%">
                        <tbody>
                            <tr>
                                <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Forums_GridCol_Name" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermGrid_Create" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermGrid_Comment" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermGrid_Edit" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermGrid_Move" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermGrid_Delete" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermGrid_Lock" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermGrid_Moderate" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                            </tr>    
                    </HeaderTemplate>
                    <ItemTemplate>
                            <tr class="Row">
                                <td class="CommonListCellLeftMost"><%# Eval("RoleName") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleID") %>' Visible="false" /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Create") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Comment") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="MoveCheckbox" Checked='<%# Eval("Move") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LockCheckbox" Checked='<%# Eval("Lock") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ModerateCheckbox" Checked='<%# Eval("Moderate") %>' /></td>
                                <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("RoleName") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                            </tr>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                            <tr class="AlternatingRow">
                                <td class="CommonListCellLeftMost"><%# Eval("RoleName") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleID") %>' Visible="false" /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Create") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Comment") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="MoveCheckbox" Checked='<%# Eval("Move") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LockCheckbox" Checked='<%# Eval("Lock") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ModerateCheckbox" Checked='<%# Eval("Moderate") %>' /></td>
                                <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("RoleName") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                            </tr>
                    </AlternatingItemTemplate>
                    <FooterTemplate>
                        </tbody>
                        </table>
                    </FooterTemplate>
                    <NoneTemplate>
                        <div class="CommonMessageWarning">
                            <CP:ResourceControl runat="server" ResourceName="CP_Wiki_NoPermissionsMessage" />
                        </div>
                    </NoneTemplate>
                </CP:RepeaterPlusNone>
		    </Content>
	    </TWC:TabbedPane>

    </TWC:TabbedPanes>

	<p class="PanelSaveButton DetailsFixedWidth">
		<cp:resourcebutton id="SaveButton" runat="server" resourcename="Save" />
	</p>
</asp:Content>