<%@ Page language="c#" AutoEventWireup="false" Inherits="CommunityServerWeb.ControlPanel.Tools.ManageSpamRules" CodeBehind="ManageSpamRules.aspx.cs" MasterPageFile="~/ControlPanel/Masters/SetupAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol id="RegionTitle" runat="Server" resourcename="Spam_ManageSpamRules_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
	<CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="ToolsSpam" />
	<script type = "text/javascript">
	    function checkAll(cb, parent)
        {
	        var p =$(parent);
	        var pa = p.getElementsByTagName('INPUT');
	        for(var i=0; i<pa.length; i++)
	        {
		        var e = pa[i];
		        if(e.getAttribute('type') == 'checkbox' && e.name != cb.name)
		        {
		            e.checked = cb.checked;
		        }
	        }
        }
	</script>
	<asp:panel id="ConfigurationPanel" runat="server">
		<div class="CommonDescription">
			<cp:resourcecontrol runat="Server" resourcename="Spam_ManageSpamRules_ConfigDescription" />
		</div>

		<cp:statusmessage runat="server" id="Status" />
		<div class="CommonFormSubTitle">
		    <cp:resourcecontrol runat="Server" resourcename="Spam_ManageSpamRules_SubTitle_Settings" />
		</div>
		<table cellpadding="0" cellspacing="0" border="0">
		<tr>
		    <td class="CommonFormFieldName">
			    <asp:literal id="AutoModerateLabel" runat="Server" />
		    </td>
		    <td class="CommonFormField">
			    <asp:textbox id="AutoModerateValue" runat="server"  />
			    <asp:requiredfieldvalidator runat="server" errormessage="*" font-bold="True" controltovalidate="AutoModerateValue" id="AutoModerateValueValidator"/>
		    </td>
		</tr>

		<tr>
		    <td class="CommonFormFieldName">
			    <asp:literal id="AutoDeleteLabel" runat="Server" />
		    </td>
		    <td class="CommonFormField">
			    <asp:textbox id="AutoDeleteValue" runat="server" />
			    <asp:requiredfieldvalidator runat="server" errormessage="*" font-bold="True" controltovalidate="AutoDeleteValue" id="AutoDeleteValueValidator"/><br />
		    </td>
		</tr>
		
		<tr runat="server" id="GroupModerateRow">
		    <td class="CommonFormFieldName">
			    <strong>Group Contact Moderation Level</strong>
			    <br />
			    Group feedback that scores at this level or higher will automatically be moderated.
		    </td>
		    <td class="CommonFormField">
			    <asp:textbox id="GroupModerateValue" runat="server"  />
			    <asp:requiredfieldvalidator runat="server" errormessage="*" font-bold="True" controltovalidate="GroupModerateValue" />
		    </td>
		</tr>
		</table>
		
		<div class="CommonFormSubTitle">
		    <cp:resourcecontrol runat="Server" resourcename="Spam_ManageSpamRules_SubTitle_Rules" />
		</div>
		<div class="CommonFormFieldName">
			<cp:resourcecontrol runat="Server" resourcename="Spam_ManageSpamRules_RulesDescription" />
		</div>
		<div class="CommonFormField">
		    <asp:repeater id="RulesList" runat="server">
			    <headertemplate>
				    <table id="SpamRules" cellspacing="0" cellpadding="0" border="0" width="100%">
				    <tr>
					    <th class="CommonListHeaderLeftMost"><input type="checkbox" name="master" id="master" onclick="checkAll(this,'SpamRules');" />&nbsp;<cp:resourcecontrol runat="Server" resourcename="Spam_ManageSpamRules_EnabledColumnHeader" /></th>
					    <th class="CommonListHeader"><cp:resourcecontrol runat="Server" resourcename="Spam_ManageSpamRules_RuleNameColumnHeader" /></th>
					    <th class="CommonListHeader"><cp:resourcecontrol runat="Server" resourcename="Spam_ManageSpamRules_SettingsColumnHeader" /></th>
				    </tr>
			    </headertemplate>
			    <itemtemplate>
				    <tr>
					    <td class="CommonListCellLeftMost"><asp:checkbox id="RuleEnabled" value runat="Server" /><asp:literal id="RuleID" runat="Server" visible="false" /></td>
					    <td class="CommonListCell">
					        <strong><asp:literal id="RuleName" runat="Server" /></strong>
					        <br />
                            <asp:literal id="RuleDesc" runat="Server" />
					    </td>
					    <td class="CommonListCell">
						    <asp:Hyperlink id="Settings" runat="server" cssclass="CommonTextButton" />
						    &nbsp;
					    </td>
				    </tr>
			    </itemtemplate>
			    <AlternatingItemTemplate> 
				    <tr bgcolor="#F0F0F0">
					    <td class="CommonListCellLeftMost"><asp:checkbox id="RuleEnabled" value runat="Server" /><asp:literal id="RuleID" runat="Server" visible="false" /></td>
					    <td class="CommonListCell">
					        <strong><asp:literal id="RuleName" runat="Server" /></strong>
					        <br />
                            <asp:literal id="RuleDesc" runat="Server" />
					    </td>
					    <td class="CommonListCell">
						    <asp:hyperlink id="Settings" runat="server" cssclass="CommonTextButton" />
						    &nbsp;
					    </td>
				    </tr>
			    </AlternatingItemTemplate>
			    <footertemplate>
				    </table>
			    </footertemplate>
		    </asp:repeater>
        </div>
	
		<div class="CommonFormField PanelSaveButton">
			<cp:resourcebutton id="SaveButton" runat="server" resourcename="Save" />
			<CSControl:CSButton id="RefreshButton" runat="server" />
		</div>
	</asp:panel>
</asp:Content>