<%@ Page language="c#" Codebehind="Setup.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Setup" MasterPageFile="~/ControlPanel/Masters/Setup.master" %>

<asp:Content ContentPlaceHolderID="PanelNavigation" runat="server">
    <div class="DashboardMenuAreaFull">
        <CP:NavigationDropDownList CssClass="DashboardMenu" OpenCssClass="DashboardMenuOpen" runat="server" FileName="~/ControlPanel/DashboardMenu.config" MenuGroupCssClass="DashboardContextMenuGroup" MenuItemCssClass="DashboardContextMenuItem" MenuItemSelectedCssClass="DashboardContextMenuItemHover" MenuItemIconWidth="20" MenuItemIconHeight="20" MenuDirection="Down" />
    </div>
</asp:Content>

<asp:Content ContentPlaceHolderId="TopLeft" runat="server"></asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation SelectedTab="setup" runat="server" id="SelectedNavigation1" />
	
	<table width="100%" cellpadding="0" cellspacing="0" border="0">
    <tr>
    <td id="DashboardMainContentArea">
    
        <div class="CommonDescription" style="margin-right: 20px; margin-top: 0;">
            Choose what you would like to administer from the options below.
        </div>
    
		<div runat="server" id="BlogAdministrationArea" class="CommonDashboardAreaContainer">
			<div class="CommonDashboardArea">
				<div class="DashboardTileTitle">
					<strong><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/BlogAdmin/"><CP:ResourceControl runat="server" ResourceName="CP_Dashboard_BlogAdministration" /></asp:HyperLink></strong>
				</div>
				<div class="CommonDashboardContent">
					<div class="DashboardTileDescription">
						Create and manage blog groups, blogs, and manage blog settings.
					</div>
					<ul class="CommonDashboardActionList">
						<li><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/BlogAdmin/sectionedit.aspx"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_CreateNewBlog" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/BlogAdmin/Blogs.aspx"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_Blogs" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/BlogAdmin/Options/GeneralOptions.aspx"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_GeneralSettings" /></asp:HyperLink></li>
					</ul>
				</div>
				<div class="CommonDashboardContentFooter">
					<asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/BlogAdmin/">Enter Blog Administration...</asp:HyperLink>
				</div>
			</div>
		</div>

		<div runat="server" id="MediaGalleryAdministrationArea" class="CommonDashboardAreaContainer">
			<div class="CommonDashboardArea">
				<div class="DashboardTileTitle">
					<strong><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/MediaGalleryAdmin/"><CP:ResourceControl runat="server" ResourceName="CP_Dashboard_MediaGalleryAdministration" /></asp:HyperLink></strong>
				</div>
				<div class="CommonDashboardContent">
					<div class="DashboardTileDescription">
						Create and manage media gallery groups, media galleries, and manage media gallery settings.
					</div>
					<ul class="CommonDashboardActionList">
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/MediaGalleryAdmin/CreateEditMediaGallery.aspx"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_CreateNewMediaGallery" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/MediaGalleryAdmin/MediaGalleries.aspx"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_MediaGalleries" /></asp:HyperLink></li>
					</ul>
				</div>
				<div class="CommonDashboardContentFooter">
					<asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/MediaGalleryAdmin/">Enter Media Gallery Administration...</asp:HyperLink>
				</div>
			</div>
		</div>

		<div runat="server" id="ForumAdministrationArea" class="CommonDashboardAreaContainer">
			<div class="CommonDashboardArea">
				<div class="DashboardTileTitle">
					<strong><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Forums/"><CP:ResourceControl runat="server" ResourceName="CP_Forums_NavBar_Forums" /></asp:HyperLink></strong>
				</div>
				<div class="CommonDashboardContent">
					<div class="DashboardTileDescription">
						Create and manage forum groups, forums, and mange forum settings.
					</div>
					<ul class="CommonDashboardActionList">
						<li><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Forums/SectionEdit.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Forums_NavBar_ForumCreate" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/forums/Forums.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Forums_NavBar_ForumList" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/forums/options/PostOptions.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Forums_NavBar_PostSettings" /></asp:HyperLink></li>
					</ul>
				</div>
				<div class="CommonDashboardContentFooter">
					<asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Forums/">Enter Forum Administration...</asp:HyperLink>
				</div>
			</div>
		</div>

		<div runat="server" id="GroupsAdministrationArea" class="CommonDashboardAreaContainer">
			<div class="CommonDashboardArea">
				<div class="DashboardTileTitle">
					<strong><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/HubAdmin/"><CP:ResourceControl runat="server" ResourceName="CP_Hub_NavBar_Hubs" /></asp:HyperLink></strong>
				</div>
				<div class="CommonDashboardContent">
					<div class="DashboardTileDescription">
						Create and manage group categories, manage groups, and configure group settings.
					</div>
					<ul class="CommonDashboardActionList">
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/HubAdmin/createhub.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Hub_NavBar_CreateHub" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/HubAdmin/groups.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Hub_NavBar_GroupList" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/HubAdmin/hubs.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Hub_NavBar_HubList" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/HubAdmin/hubpermissions.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Hub_NavBar_Permissions" /></asp:HyperLink></li>
					</ul>
				</div>
				<div class="CommonDashboardContentFooter">
					<asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/HubAdmin/">Enter Group Administration...</asp:HyperLink>
				</div>
			</div> 
		</div>
		
		<div runat="server" id="WikiAdministrationArea" class="CommonDashboardAreaContainer">
			<div class="CommonDashboardArea">
				<div class="DashboardTileTitle">
					<strong><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/WikiAdmin/"><CP:ResourceControl runat="server" ResourceName="CP_Wiki_NavBar_Wikis" /></asp:HyperLink></strong>
				</div>
				<div class="CommonDashboardContent">
					<div class="DashboardTileDescription">
					    <CP:ResourceControl runat="server" ResourceName="CP_Wiki_MainDescription" />
					</div>
					<ul class="CommonDashboardActionList">
						<li><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/WikiAdmin/WikiEdit.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Wiki_NavBar_CreateWiki" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/WikiAdmin/Wikis.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Wiki_NavBar_WikiList" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/WikiAdmin/DefaultPermissionList.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Wiki_NavBar_WikiPermissions" /></asp:HyperLink></li>
					</ul>
				</div>
				<div class="CommonDashboardContentFooter">
					<asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/WikiAdmin/"><CP:ResourceControl runat="server" ResourceName="CP_Wiki_EnterLink" /></asp:HyperLink>
				</div>
			</div>
		</div>


		<div runat="server" id="MembershipArea" class="CommonDashboardAreaContainer">
			<div class="CommonDashboardArea">
				<div class="DashboardTileTitle">
					<strong><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Membership/membersearch.aspx?SelectedNavItem=BrowseMembers">Membership Administration</asp:HyperLink></strong>
				</div>
				<div class="CommonDashboardContent">
					<div class="DashboardTileDescription">
						Create and manage users, manage roles, and configure membership settings.
					</div>
					<ul class="CommonDashboardActionList">
						<li><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Membership/membersearch.aspx?SelectedNavItem=BrowseMembers"><CP:ResourceControl runat="server" ResourceName="CP_Membership_NavBar_SearchMember" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/membership/Roles.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Membership_NavBar_ManageRoles" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/membership/AccountSettings.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Membership_Settings_Account_Title" /></asp:HyperLink></li>
					</ul>
				</div>
				<div class="CommonDashboardContentFooter">
					<asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Membership/membersearch.aspx?SelectedNavItem=BrowseMembers">Enter Membership Administration...</asp:HyperLink>
				</div>
			</div>  
		</div>

		<div runat="server" id="SetupArea" class="CommonDashboardAreaContainer">
			<div class="CommonDashboardArea">
				<div class="DashboardTileTitle">
					<strong><asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Settings/default.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Settings_NavBar_Settings" /></asp:HyperLink></strong>
				</div>
				<div class="CommonDashboardContent">
					<div class="DashboardTileDescription">
						Manage site-wide configuration settings, content filters, the site theme, licenses, and use site tools.
					</div>
					<ul class="CommonDashboardActionList">
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/Settings/Setup.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Settings_Setup" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/tools/managelicenses.aspx">Manage Licenses</asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/Settings/ThemeConfiguration.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Settings_ThemeConfigurationSettings" /></asp:HyperLink></li>
						<li><asp:HyperLink runat="server" NavigateUrl="~/controlpanel/tools/EventLogViewer.aspx"><CP:ResourceControl runat="server" ResourceName="CP_Tools_NavBar_EventLog" /></asp:HyperLink></li>
					</ul>
				</div>
				<div class="CommonDashboardContentFooter">
					<asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Settings/default.aspx">Enter Site Administration...</asp:HyperLink>
				</div>
			</div>
		</div>
		<div style="clear:both"></div>
	
	</td>
	
	<td id="DashboardSidebarArea">
	    <div class="CommonDashboardArea CommonDashboardSidebarArea">
            <div class="DashboardTileTitle">
                <strong><CP:ResourceControl runat="server" ResourceName="CP_Dashboard_Announcements" /></strong>
                <CP:ResourceControl runat="server" ResourceName="CP_Dashboard_Announcements_ReadMore" />
            </div>
            <div class="CommonDashboardContent AnnouncementsContent">
                <cp:RepeaterPlusNone runat="server" id="Announcements" ShowHeaderFooterOnNone="false">
	                <HeaderTemplate>
	                    <ul class="CommonDashboardActionList">
	                </HeaderTemplate>
	                <ItemTemplate>
		                <li>
		                    <a href="<%# DataBinder.Eval(Container.DataItem, "Link")%>"><%#DataBinder.Eval(Container.DataItem, "Title")%></a>										
		                    <div><%#DataBinder.Eval(Container.DataItem, "Description")%></div>
		                </li>
	                </ItemTemplate>
	                <AlternatingItemTemplate>
		                <li>
		                    <a href="<%# DataBinder.Eval(Container.DataItem, "Link")%>"><%#DataBinder.Eval(Container.DataItem, "Title")%></a>										
		                    <div><%#DataBinder.Eval(Container.DataItem, "Description")%></div>
		                </li>
	                </AlternatingItemTemplate>
	                <FooterTemplate>
	                    </ul>
	                </FooterTemplate>
	                <NoneTemplate>
		                <div style="margin-bottom: 8px; margin-top: 8px;">
		                    <CP:ResourceControl runat="server" ResourceName="CP_Dashboard_NoAnnouncements" />
		                </div>
	                </NoneTemplate>
                </cp:RepeaterPlusNone>
            </div>
            <div class="CommonDashboardContentFooter">
                <CP:ResourceControl runat="server" ResourceName="CP_Dashboard_Announcements_More" />
            </div>
        </div>
        
        <asp:PlaceHolder runat="server" ID="VersionArea">
            <div class="CommonDashboardArea CommonDashboardSidebarArea">
                <div class="DashboardTileTitle">
                    <strong><CP:ResourceControl runat="server" ResourceName="CP_Dashboard_Version" /></strong>
                </div>
                <div class="CommonDashboardContent">
		            <ul class="CommonDashboardActionList">
		            <li>
		                <asp:HyperLink runat="server" id="NewVersionAvailable" />
		                <div id="License" runat="Server">
                            <asp:HyperLink runat="server" NavigateUrl="~/ControlPanel/Tools/ManageLicenses.aspx"><CP:ResourceControl ID="ResourceControl33" runat="server" ResourceName="CP_Dashboard_License_Action" /></asp:HyperLink>
                        </div>
                    </li>
                    </ul>
	            </div>
	            <div class="CommonDashboardContentFooter">
                    <asp:Literal runat="server" id="Version" />
                </div>
            </div>
        </asp:PlaceHolder>
    </td>
    </tr>
    </table>
</asp:Content>