<%@ Page Language="C#" EnableViewState="false" AutoEventWireup="true" CodeBehind="ThemeConfiguration.aspx.cs" Inherits="CommunityServer.ControlPanel.Settings.ThemeConfiguration" MasterPageFile="~/ControlPanel/Masters/SetupAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
    <CP:ResourceControl ResourceName="CP_ThemeConfiguration_Title" runat="server" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="ThemeConfigurationSettings" />

    <script type="text/javascript">
    // <![CDATA[
    function refresh(shouldRefresh)
    {
        if (shouldRefresh)
            window.location = window.location;
    }
    // ]]>
    </script>

	<DIV class="CommonDescription">
	    <CP:ResourceControl runat="server" ResourceName="CP_ThemeConfiguration_Description" />
	</DIV>
	<CP:StatusMessage id="StatusMessage" runat="server" />
	<DIV class="CommonFormArea">
        <div style="margin-bottom: 1em;">
            <div class="CommonFormFieldName">
                    <strong><CP:ResourceControl runat="server" ResourceName="CP_ThemeConfiguration_ThemeName" /></strong>
            </div>
            <div class="CommonFormField">
                    <TWC:DropDownList runat="server" ID="Themes" ShowHtmlWhenSelected="false" SelectListWidth="440" SelectListHeight="375" />
            </div>
        </div>
        
	    <div style="float: left;"><asp:Image runat="server" id="ThemePreviewImage" Width="100" Height="75" BorderWidth="1" style="margin-right: 1em;" /></div>
	    <h4 class="CommonFormTitle"><asp:Literal runat="server" id="ThemeName" /></h4>
	    <div class="CommonFormDescription">
	        <asp:Literal runat="server" id="ThemePreviewText" />
	    </div>
	    <div style="clear: both; padding-bottom: 1em;"></div>
	
	    <CSDynConfig:ConfigurationForm runat="server" id="ConfigurationForm"
	        RenderGroupsInTabs="true" 
	        PanesCssClass="CommonPane"
		    TabSetCssClass="CommonPaneTabSet"
		    TabCssClasses="CommonPaneTab"
		    TabSelectedCssClasses="CommonPaneTabSelected"
		    TabHoverCssClasses="CommonPaneTabHover"
		    >
		    <PropertyFormGroupHeaderTemplate>
		        <div class="CommonFormDescription">
		            <CSDynConfig:PropertyGroupData Property="Description" runat="server" />
		        </div>
		        <table cellspacing="0" cellpadding="2" border="0" width="100%">
		    </PropertyFormGroupHeaderTemplate>
		    <PropertyFormSubGroupHeaderTemplate>
		        <tr><td colspan="2">
                    <div class="CommonFormSubTitle"><CSDynConfig:PropertySubGroupData Property="Name" runat="server" /></div>
                </td></tr>
		    </PropertyFormSubGroupHeaderTemplate>
		    <PropertyFormPropertyTemplate>
		        <tr valign="top">
		            <td class="CommonFormFieldName" style="width:50%"><strong><CSDynConfig:PropertyData Property="Name" runat="server" /></strong><br /><CSDynConfig:PropertyData Property="Description" runat="server" /></td>
		            <td class="CommonFormField"><CSDynConfig:PropertyControl runat="server" /></td>
		        </tr>
		    </PropertyFormPropertyTemplate>
		    <PropertyFormSubGroupFooterTemplate>
		        <tr><td colspan="2"><div style="height: .5em;"></div></td></tr>
		    </PropertyFormSubGroupFooterTemplate>
		    <PropertyFormGroupFooterTemplate>
		        </table>
		    </PropertyFormGroupFooterTemplate>
		    <AppendedTabbedPanes>
		        <TWC:TabbedPane runat="server">
		            <Tab><CP:ResourceControl ResourceName="CP_ThemeConfiguration_Preview_Title" runat="server" /></Tab>
		            <Content>
		                <asp:Literal runat="server" id="PreviewMessage" />
	                    <p />
   	                    <asp:HyperLink runat="server" id="OpenPreview" Target="_blank" runat="server" CssClass="CommonTextButton"><cp:ResourceControl runat="server" ResourceName="CP_ThemeConfiguration_OpenNewPreviewWindow" /></asp:HyperLink>
	                    <cp:resourcelinkbutton id="UpdatePreviewButton" runat="server" ResourceName="CP_ThemeConfiguration_StartPreview" cssclass="CommonTextButton" />
                        <cp:resourcelinkbutton id="EndPreviewButton" runat="server" ResourceName="CP_ThemeConfiguration_EndPreview" Visible="false" cssclass="CommonTextButton" />
		            </Content>
		        </TWC:TabbedPane>
		    </AppendedTabbedPanes>
	    </CSDynConfig:ConfigurationForm>
	<p class="PanelSaveButton">
        <cp:resourcelinkbutton id="RestoreDefaultsButton" runat="server" resourcename="CP_ThemeConfiguration_RestoreDefaults" cssclass="CommonTextButton" />
        &nbsp;&nbsp;
        <cp:ModalLink runat="server" id="ImportButton" Width="550" Height="200" Callback="refresh" Text="Import" CssClass="CommonTextButton" />
        <asp:HyperLink runat="server" id="ExportConfiguration" CssClass="CommonTextButton">Export</asp:HyperLink>
        &nbsp;&nbsp;	        
        <cp:resourcelinkbutton id="SaveButton" runat="server" resourcename="Save" cssclass="CommonTextButton" />
	</p>
</DIV>
</asp:Content>
