<%@ Page language="c#" Codebehind="Setup.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Settings.SettingsSetup" MasterPageFile="~/ControlPanel/Masters/SetupAdmin.master" %>
<%@ Register TagPrefix="MG" TagName="Accounts" Src = "~/ControlPanel/Settings/MGAccounts.ascx" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
    <cp:resourcecontrol id="RegionTitle" runat="Server" resourcename="CP_Settings_Setup" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation selectednavitem="SettingsSetup" runat="server" />
    <DIV class="CommonDescription">
    Use this page to setup your site, such as disabling applications and setting a site name.
    </DIV>
	<cp:statusmessage id="Status" runat="server" />
	<div class="CommonFormArea">
	
	<TWC:TabbedPanes runat="server"
	    PanesCssClass="CommonPane"
	    TabSetCssClass="CommonPaneTabSet"
	    TabCssClasses="CommonPaneTab"
	    TabSelectedCssClasses="CommonPaneTabSelected"
	    TabHoverCssClasses="CommonPaneTabHover">
	    
	<TWC:TabbedPane runat="server">
	    <Tab><cp:resourcecontrol runat="Server" resourcename="CP_Settings_Setup_SiteNameTabTitle" /></Tab>
	    <Content>
	        <table width="100%">
                <tr>
                    <td colspan="2">
                        <div class="CommonFormSubTitle">
                            Configure your site name and description
                        </div>
                    </td>
                </tr>
    	        <TR>
		            <TD colspan="2">
		                <div class="CommonFormFieldName">
		                <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_Name" /></strong>
		                <br />
		                <cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_Name_Descr" />
		                </div>
		                
			            <div class="CommonFormField">
		                <asp:textbox class="ControlPanelTextInput" id="SiteName" runat="server" maxlength="512" columns="55" />
		                </div>
		            </TD>
	            </TR>
	            <TR>
		            <TD colspan="2">
		                <div class="CommonFormFieldName">
		                <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_Description" /></strong>
                        <br />
			            <cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_Description_Descr" />
			            </div>

			            <div class="CommonFormField">
    			            <asp:textbox class="ControlPanelTextInput" id="SiteDescription" runat="server" columns="55" textmode="Multiline" rows="6" />
    			        </div>
		            </TD>
	            </TR>

                <tr>
                    <td colspan="2">
                        <div class="CommonFormSubTitle">
                            <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_DateTime"></cp:resourcecontrol>
                        </div>
                    </td>
                </tr>
				<TR>
					<TD class="CommonFormFieldName" style="width:350px;">
					    <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_TimeZone" /></strong>
					    <br />
						<cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_TimeZone_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:timezonedropdownlist id="Timezone" runat="server"></cp:timezonedropdownlist>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
					    <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_DateTime_Date" /></strong>
					    <br />
						<cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_DateTime_Date_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:dateformatdropdownlist id="DateFormat" runat="server"></cp:dateformatdropdownlist>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
					    <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_DateTime_Time" /></strong>
					    <br />
						<cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_DateTime_Time_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:timeformatdropdownlist id="TimeFormat" runat="server"></cp:timeformatdropdownlist>
					</TD>
				</TR>
			</TABLE>
	    </Content>
    </TWC:TabbedPane>
    
    <TWC:TabbedPane runat="server">
        <Tab><CP:ResourceControl runat="server" ResourceName="CP_Settings_Setup_ApplicationsTabTitle" /></Tab>
        <Content>
			<TABLE width="100%">
			    <tr>
			        <td colspan="2">
                        <div class="CommonFormSubTitle">
                            <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_EnableApplications"></cp:resourcecontrol>
                        </div>
			        </td>
			    </tr>
				<TR>
					<TD class="CommonFormFieldName">
                            <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_EnableForum" /></strong>
                            <br />
                            <cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_EnableForum_Descr" />
					</td>
				
				    <td class="CommonFormField">
					        <cp:yesnoradiobuttonlist id="Forum" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
					        <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_EnableBlog" /></strong>
					        <br />
						    <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_EnableBlog_Descr" />
					</TD>
					<TD class="CommonFormField">
    						<cp:yesnoradiobuttonlist id="Weblog" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
					        <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_EnableMediaGallery" /></strong>
					        <br />
						    <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_EnableMediaGallery_Descr" />
				    </TD>
					<TD class="CommonFormField">
					    	<cp:yesnoradiobuttonlist id="MediaGallery" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
					        <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_EnableWiki" /></strong>
					        <br />
						    <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_EnableWiki_Descr" />
					</TD>
					<TD class="CommonFormField">
    						<cp:yesnoradiobuttonlist id="Wiki" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
					        <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_EnableGroups" /></strong>
					        <br />
						    <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_EnableGroups_Descr" />
				    </TD>
					<TD class="CommonFormField">
					    	<cp:yesnoradiobuttonlist id="Hub" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
					        <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_EnableBlogRoller"/></strong>
					        <br />
						    <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_EnableBlogRoller_Descr" />
					</TD>
					<TD class="CommonFormField">
    						<cp:yesnoradiobuttonlist id="BlogRoller" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist>
					</TD>
				</TR>
			</TABLE>
        </Content>
    </TWC:TabbedPane>
    
    <TWC:TabbedPane runat="server">
        <Tab><CP:ResourceControl runat="server" ResourceName="CP_Settings_GeneralSettings" /></Tab>
        <Content>
            <TABLE width="100%">
                <tr>
                    <td colspan="2">
                        <div class="CommonFormSubTitle">
                            General Settings
                        </div>
                    </td>
                </tr>
				<TR>
					<TD class="CommonFormFieldName">
					    <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_General_Menu_SiteUrl" /></strong>
					    <br />
						<cp:resourcecontrol runat="Server" resourcename="CP_Settings_General_Menu_SiteUrl_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:TextBox id="SiteUrl" runat="server" />
						<asp:RequiredFieldValidator runat="server" ErrorMessage="*" Font-Bold="True" ControlToValidate="SiteUrl" />
					</TD>
				</TR>
				<TR>
		            <TD class="CommonFormFieldName">
			            <strong><cp:resourcecontrol id="lblSearchMetaDescription" runat="server" resourcename="CP_Settings_SiteContent_SearchMetaDescription" /></strong><br />
			            <cp:ResourceControl runat="Server" resourcename="CP_Settings_SiteContent_SearchMetaDescription_Descr" />
		            </TD>
		            <TD class="CommonFormField">
			            <asp:textbox id="SearchMetaDescription" runat="Server" maxlength="512" columns="55" />
		            </TD>
	            </TR>
	            <TR>
		            <TD class="CommonFormFieldName">
			            <strong><cp:resourcecontrol id="lblSearchMetaKeyword" runat="server" resourcename="CP_Settings_SiteContent_SearchMetaKeyword" /></strong><br />
			            <cp:ResourceControl runat="Server" resourcename="CP_Settings_SiteContent_SearchMetaKeyword_Descr" />
		            </TD>
		            <TD class="CommonFormField">
			            <asp:textbox id="SearchMetaKeywords" runat="Server" maxlength="512" columns="55" />
		            </TD>
	            </TR>
	            <TR>
		            <TD class="CommonFormFieldName">
			            <strong><cp:resourcecontrol id="lblCopyright" runat="server" resourcename="CP_Settings_SiteContent_Copyright" /></strong><br />
			            <cp:ResourceControl runat="Server" resourcename="CP_Settings_SiteContent_Copyright_Descr" />
		            </TD>
		            <TD class="CommonFormField">
			            <asp:textbox id="Copyright" runat="Server" columns="55" />
		            </TD>
	            </TR>
				<TR>
					<TD class="CommonFormFieldName">
					    <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_General_Menu_TOS" /></strong>
					    <br />
						<cp:resourcecontrol runat="Server" resourcename="CP_Settings_General_Menu_TOS_Descr" />
                    </TD>
					<TD class="CommonFormField">
						<asp:TextBox id="TermsOfServiceUrl" runat="server" />
					</TD>
				</TR>	
				<TR>
					<TD class="CommonFormFieldName">
					    <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_General_Menu_EnableSectionLocalization" /></strong>
					    <br />
						<cp:resourcecontrol runat="Server" resourcename="CP_Settings_General_Menu_EnableSectionLocalization_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="EnableSectionLocalization" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>			
				<TR runat="server" id="DisplayEulaArea">
					<TD class="CommonFormFieldName">
					    <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_General_Menu_Eula" /></strong>
					    <br />
						<cp:resourcecontrol runat="Server" resourcename="CP_Settings_General_Menu_Eula_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="DisplayEula" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>
				<tr>
				    <td class="CommonFormFieldName"> 
				        <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLogging" /></strong>
				        <br />
						<cp:resourcecontrol runat="Server" resourcename="CP_Settings_ActivityLogging_Desc" />
				    </td>
				    <td class="CommonFormField">
				        <cp:yesnoradiobuttonlist id="EnableActivityLogging" runat="server" repeatcolumns="2" />
				    </td>
				</tr>
				<tr>
				    <td colspan="2">
		                <div class="CommonFormFieldName">
				            <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes" /></strong>
				            <br />
						    <cp:resourcecontrol runat="Server" resourcename="CP_Settings_ActivityLoggingTypes_Desc" />
                        </div>
                        <div class="CommonFormField" style="margin-left: 200px;">
                            <table cellpadding="8" cellspacing="0" border="0">
				                <tr>
				                    <td colspan="3">
				                        <asp:CheckBox runat="server" ID="ActivityLoggingAll" onclick="CheckUncheckAll(this.checked);" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_AllActivities" />
				                    </td>
				                </tr>
				                <tr>
				                    <td valign="top">
				                        <strong> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_UserActivities" /></strong><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewUser" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewUser" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewProfileAnnouncement" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewProfileAnnouncement" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewProfileComment" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewProfileComment" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewUserAvatar" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewUserAvatar" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewUserFile" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewUserFile" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewUserFolder" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewUserFolder" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewFriendship" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewFriendship" />
				                    </td>
				                    <td valign="top">
				                        <strong> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_BlogActivities" /></strong><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewBlog" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewBlog" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewBlogPost" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewBlogPost" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewBlogComment" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewBlogComment" />
				                    </td>
				                    <td valign="top">
				                        <strong> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_ForumActivities" /></strong><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewForum" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewForum" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewForumThread" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewForumThread" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewForumPost" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewForumPost" />
				                    </td>
				                </tr>
				                <tr>
				                    <td valign="top">
	    			                    <strong> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_MediaGalleryActivities" /></strong><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewMediaGallery" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewMediaGallery" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewMediaGalleryPost" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewMediaGalleryPost" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewMediaGalleryComment" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewMediaGalleryComment" />
				                    </td>
				                    <td valign="top">
				                        <strong> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_GroupActivities" /></strong><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewGroup" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewGroup" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewGroupMember" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewGroupMember" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewGroupPage" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewGroupPage" />
				                    </td>
				                    <td valign="top">
				                        <strong> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_WikiActivities" /></strong><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewWikiPage" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewWikiPage" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingUpdatedWikiPage" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_UpdatedWikiPage" /><br />
				                        <asp:CheckBox runat="server" ID="ActivityLoggingNewWikiComment" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_NewWikiComment" />
				                    </td>
				                </tr>
				                <tr>
				                    <td valign="top">
				                        <asp:CheckBox runat="server" ID="ActivityLoggingThirdPartyMessageType" onclick="UncheckAllOption();" /> <cp:resourcecontrol runat="server" resourcename="CP_Settings_ActivityLoggingTypes_ThirdPartyActivities" />
				                    </td>
				                    <td valign="top">				                        
				                        <asp:CheckBox runat="server" ID="ActivityLoggingStatusMessage" onclick="UncheckAllOption();" /> <CP:ResourceControl ID="ResourceControl2" runat="server" ResourceName="CP_Settings_ActivityLoggingTypes_StatusMessages" />
                                    </td>
				                </tr>
				            </table>
                            <script type="text/javascript">
                            // <![CDATA[
                                function CheckUncheckAll(checked)
                                {
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewUser.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewProfileAnnouncement.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewProfileComment.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewUserAvatar.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewUserFile.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewUserFolder.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewFriendship.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewBlog.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewBlogPost.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewBlogComment.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewForum.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewForumThread.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewForumPost.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewMediaGallery.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewMediaGalleryPost.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewMediaGalleryComment.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewGroup.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewGroupMember.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewGroupPage.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewWikiPage.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingUpdatedWikiPage.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingNewWikiComment.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingThirdPartyMessageType.ClientID %>'), checked);
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingStatusMessage.ClientID %>'), checked);
                                }  
                                function CheckUncheck(el, val){
                                    if (val) el.checked = true;
                                    else el.checked = false;
                                }       
                                function UncheckAllOption(){
                                    CheckUncheck(document.getElementById('<%= ActivityLoggingAll.ClientID %>'), false);
                                }           
                            // ]]>
                            </script>
                        </div>
				    </td>
				</tr>
				<tr>
				    <td class="CommonFormFieldName"> 
				        <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Conversations" /></strong>
				        <br />
						<cp:resourcecontrol runat="Server" resourcename="CP_Settings_Conversations_Desc" />
				    </td>
				    <td class="CommonFormField">
				        <cp:yesnoradiobuttonlist id="EnableConversations" runat="server" repeatcolumns="2" />
				    </td>
				</tr>
				<tr>
				    <td class="CommonFormFieldName"> 
				        <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_UsertoUserEmail" /></strong>
				        <br />
						<cp:resourcecontrol runat="Server" resourcename="CP_Settings_UsertoUserEmail_Desc" />
				    </td>
				    <td class="CommonFormField">
				        <cp:yesnoradiobuttonlist id="EnableUserToUserEmail" runat="server" repeatcolumns="2" />
				    </td>
				</tr>
				<tr>
				    <td class="CommonFormFieldName"> 
				        <strong><CP:ResourceControl runat="server" ResourceName="CP_Settings_SiteContent_EnableRobotsMetaTag" /></strong>
				        <br />
						<CP:ResourceControl ID="ResourceControl1" runat="server" ResourceName="CP_Settings_SiteContent_EnableRobotsMetaTag_Descr" />
				    </td>
				    <td class="CommonFormField">
				        <cp:yesnoradiobuttonlist id="EnableRobotsMetaTags" runat="server" repeatcolumns="2" />
				    </td>
				</tr>
				<TR>
		            <TD colspan="2">
		                <div class="CommonFormFieldName">
                            <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_AdditionHeader"/></strong>
                            <br />
    			            <cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_AdditionHeader_Descr" />
                        </div>
                        
                        <div class="CommonFormField">
                            <asp:textbox class="ControlPanelTextInput" id="GenericHeader" runat="server" columns="55" textmode="Multiline" rows="6" />
                        </div>    			            
		            </TD>
	            </TR>
	            <TR>
		            <TD colspan="2">
		                <div class="CommonFormFieldName">
                            <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_GoogleAnalytics"/></strong>
                            <br />
    			            <cp:resourcecontrol runat="server" resourcename="CP_Settings_SiteContent_GoogleAnalytics_Descr" />
                        </div>
                        
                        <div class="CommonFormField">
                            <asp:textbox class="ControlPanelTextInput" id="GoogleAnalytics" runat="server" columns="55" textmode="Multiline" rows="6" />
                        </div>    			            
		            </TD>
	            </TR>

			</TABLE>
        </Content>
    </TWC:TabbedPane>
    
    <TWC:TabbedPane runat="server">
        <Tab><CP:ResourceControl runat="server" ResourceName="CP_Settings_Email_Title" /></Tab>
        <Content>
            <H3 class="CommonSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_SubTitle_General" /></H3>
			<TABLE cellSpacing="0" cellPadding="2" border="0">
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_Contact_AdminEmail" /></strong><br />
						<cp:ResourceControl  runat="Server" resourcename="Admin_SiteSettings_Contact_AdminEmail_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="AdminEmailAddress" runat="server" maxlength="128"></asp:textbox>
						<asp:regularexpressionvalidator id="RegularExpressionValidator1" runat="server" validationexpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"
							controltovalidate="AdminEmailAddress" >
							<cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_Contact_InvalidEmail" />
						</asp:regularexpressionvalidator>
					</TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_Enable" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_Enable_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="EnableEmail" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_Encoding" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_Encoding_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="EmailEncoding" runat="server" maxlength="64"></asp:textbox></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_SubjectEncoding" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_SubjectEncoding_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="EmailSubjectEncoding" runat="server" maxlength="64"></asp:textbox></TD>
				</TR>
				<TR id="EmailThrottle_Row">
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol id="lblEmailThrottle" runat="server" resourcename="CP_Settings_Email_EmailThrottle" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_EmailThrottle_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="EmailThrottle" runat="server" maxlength="5"></asp:textbox>
						<asp:requiredfieldvalidator id="EmailThrottleValidator" runat="server" controltovalidate="EmailThrottle" font-bold="True"
							errormessage="*"></asp:requiredfieldvalidator></TD>
				</TR>
				<TR id="SmtpServer_Row">
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_Server" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_Server_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="SmtpServer" runat="server" maxlength="64"></asp:textbox></TD>
				</TR>
			</TABLE>
		    <div id="SMTP_Login_Info_Area">
			<H3 class="CommonSubTitle">
				<cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_SubTitle_SMTP"></cp:resourcecontrol></H3>
			<TABLE cellSpacing="0" cellPadding="0" border="0" width="100%">
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_UsingSsl" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_UsingSsl_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="SmtpServerUsingSsl" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_UsingNtlm" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_UsingNtlm_Descr" /></TD>
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="SmtpServerUsingNtlm" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_NeedsLogin" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_NeedsLogin_Descr" />
					</TD>
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="SmtpServerRequiredLogin" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_UserName" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_UserName_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="SmtpServerUserName" runat="server" maxlength="64"></asp:textbox>
						<asp:requiredfieldvalidator id="SmtpServerUserNameValidator" runat="server" controltovalidate="SmtpServerUserName"
							font-bold="True" errormessage="*"></asp:requiredfieldvalidator></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_Password" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_Password_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="SmtpServerPassword" runat="server" maxlength="64"></asp:textbox>
						<asp:requiredfieldvalidator id="SmtpServerPasswordValidator" runat="server" controltovalidate="SmtpServerPassword"
							font-bold="True" errormessage="*"></asp:requiredfieldvalidator></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_PortNumber" /></strong><br />
						<cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_PortNumber_Descr" />
					</TD>
					<TD class="CommonFormField">
						<asp:textbox id="SmtpPortNumber" runat="server" maxlength="10"></asp:textbox></TD>
				</TR>
			</TABLE>
			</div>
			
            <H3 class="CommonSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_SubTitle_MailGatewayGeneral" /></H3>
            <TABLE cellSpacing="0" cellPadding="0" border="0" width="100%">
                <TR>
                    <TD class="CommonFormFieldName">
	                    <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_EnableMG" ResourceFile="MGResources.xml" /></strong><br />
	                    <cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_EnableMG_Descr" ResourceFile="MGResources.xml" />
	                </TD>
                    <TD class="CommonFormField">
	                    <cp:yesnoradiobuttonlist id="EnableMailGateway" runat="server" repeatcolumns="2" onclick="DisableFields();"></cp:yesnoradiobuttonlist></TD>
                </TR>
                <TR>
                    <TD class="CommonFormFieldName">
	                    <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_MG_RemoteAccessCode" ResourceFile="MGResources.xml" /></strong><br />
	                    <cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_MG_RemoteAccessCode_Descr" ResourceFile="MGResources.xml" />
	                </TD>
                    <TD class="CommonFormField">
	                    <asp:textbox id="MGSecurityCode" runat="server" maxlength="256"></asp:textbox></TD>
                </TR>
                <TR>
                    <TD class="CommonFormFieldName">
	                    <strong><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_MG_EmailDomain" ResourceFile="MGResources.xml" /></strong><br />
	                    <cp:ResourceControl runat="Server" resourcename="CP_Settings_Email_MG_EmailDomain_Descr" ResourceFile="MGResources.xml" />
	                </TD>
                    <TD class="CommonFormField">
	                    <asp:textbox id="MGEmailDomain" runat="server" maxlength="256"></asp:textbox></TD>
                </TR>
                <tr id="FromAddressArea" runat="server">
					<td class="CommonFormFieldName">
						<strong>From Address Type</strong><br />
						Choose how Mail Gateway / Evolution will set the from address from mailing list enabled forums / groups.  "Fake" will have it generate from addresses
						like bounce-username@domain.com, using the Email Domain setting as the domain.  "Public Email" will have it use the user's public email address profile setting, or the fake email address if they don't
						have a public email address set.  "Private Email" will use the user's private email address from their profile.
					</td>
					<td class="CommonFormField">
						<asp:DropDownList ID="FromAddressType" runat="server">
							<asp:ListItem Text="Fake" Value="Fake" />
							<asp:ListItem Text="Public Email" Value="PublicEmail" />
							<asp:ListItem Text="Private Email" Value="PrivateEmail" />
						</asp:DropDownList>
					</td>
                </tr>
            </TABLE>
            <H3 class="CommonSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Settings_Email_MG_Accounts" ResourceFile="MGResources.xml" /></H3>
            <MG:Accounts id="Accounts" runat="server" />
        </Content>
    </TWC:TabbedPane>
    <TWC:TabbedPane runat="server">
        <Tab><CP:ResourceControl runat="server" ResourceName="CP_Settings_Setup_AggregateApplicationsTitle" /></Tab>
        <Content>
			<TABLE cellSpacing="0" cellPadding="0" border="0" width="100%">
				<TR>
					<TD class="CommonFormFieldName">
						<strong>Use Only Public Weblog Sections for Aggregate Areas</strong><br />
						When enabled only content visible by the everyone role will appear on aggregate pages of the site
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="WeblogPublicMode" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>
				<TR>
					<TD class="CommonFormFieldName">
						<strong>Use Only Public Media Gallery Sections for Aggregate Areas</strong><br />
						When enabled only content visible by the everyone role will appear on aggregate pages of the site
					<TD class="CommonFormField">
						<cp:yesnoradiobuttonlist id="MediaGalleryPublicMode" runat="server" repeatcolumns="2"></cp:yesnoradiobuttonlist></TD>
				</TR>
				

			</TABLE>

        </Content>
    </TWC:TabbedPane>
    
    </TWC:TabbedPanes>
        
    <p class="PanelSaveButton">
        <cp:resourcebutton id="SaveButton" runat="server" resourcename="Save" />
    </p>
    </div>
    
    <script type="text/javascript">
        // <![CDATA[
        function DisableFields()
        {
            var enableMailGateway = document.getElementsByName('<%=EnableMailGateway.ClientID.Replace("_", "$") %>');

            if(enableMailGateway.length > 0)
            {
                var yesButton = enableMailGateway[0];
                if(yesButton.checked)
                {
                    HideOrShowControl(document.getElementById('<%=MGSecurityCode.ClientID %>'), true);
                    HideOrShowControl(document.getElementById('<%=MGEmailDomain.ClientID %>'), true);
                }
                else
                {
                    HideOrShowControl(document.getElementById('<%=MGSecurityCode.ClientID %>'), false);
                    HideOrShowControl(document.getElementById('<%=MGEmailDomain.ClientID %>'), false);
                }
            }
        }
        
        function HideOrShowControl(control, visible)
        {
            if(visible)
                control.disabled = false;
            else
                control.disabled = true;
        }
        
        function EnableForSubmit()
        {
            HideOrShowControl(document.getElementById('<%=MGSecurityCode.ClientID %>'), true);
            HideOrShowControl(document.getElementById('<%=MGEmailDomain.ClientID %>'), true);
        }

        DisableFields();
        // ]]> 
    </script>
</asp:Content>