<%@ Page language="c#" Codebehind="ManageRanks.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Settings.ManageRanks" MasterPageFile="~/ControlPanel/Masters/SetupAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl id="SectionDescription" runat="server" ResourceName="CP_ManageRanks_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">	
    <cp:controlpanelselectednavigation selectednavitem="ManageRanks" runat="server" />
	<cp:statusmessage id="Status" runat="server" />
	<DIV class="CommonDescription">
        <cp:resourcecontrol runat="server" resourcename="CP_ManageRanks_SubTitle" />
    </DIV>
    
	<TWC:TabbedPanes runat="server"
            PanesCssClass="CommonPane"
            TabSetCssClass="CommonPaneTabSet"
            TabCssClasses="CommonPaneTab"
            TabSelectedCssClasses="CommonPaneTabSelected"
            TabHoverCssClasses="CommonPaneTabHover"
            >
            <TWC:TabbedPane runat="server">
	            <Tab><cp:resourcecontrol runat="Server" resourcename="CP_RankSettings_Tab" /></Tab>
	            <Content>
	                <table cellSpacing="0" cellPadding="2" border="0">
	                    <TR>
		                    <TD class="CommonFormFieldName">
			                    <strong><cp:resourcecontrol id="Resourcecontrol130" runat="server" resourcename="Admin_SiteSettings_Posting_UserActivityDisplay" /></strong><br />
			                    <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_Posting_UserActivityDisplay_Descr" />
		                    </TD>
		                    <TD class="CommonFormField" nowrap="nowrap">
			                    <cp:useractivitydisplayradiobuttonlist id="PostingActivityDisplay" runat="server" repeatcolumns="2" cssclass="ControlPanelTextInput" />
		                    </TD>
	                    </TR>
	                    <TR>
                            <TD class="CommonFormFieldName">
                                <strong><cp:resourcecontrol runat="server" resourcename="Admin_SiteSettings_Posting_DisplayRankAsPicture" /></strong><br />
                                <cp:resourcecontrol runat="Server" resourcename="Admin_SiteSettings_Posting_DisplayRankAsPicture_Descr" />
                            </TD>
                            <TD class="CommonFormField" nowrap="nowrap">
                                <cp:yesnoradiobuttonlist id="DisplayUserRankAsPicture" runat="server" repeatcolumns="2" cssclass="ControlPanelTextInput" />
                            </TD>
                        </TR>
	                </table>
	                <div class="PanelSaveButton">
	                    <cp:resourcebutton id="SaveButton" runat="server" resourcename="Save" />
	                </div>
	            </Content>
	        </TWC:TabbedPane>
	        <TWC:TabbedPane runat="server">
	            <Tab><cp:resourcecontrol runat="Server" resourcename="CP_ManageRanks_Tab" /></Tab>
	            <Content>
                	
                    <div class="PanelSaveButton">
                        <input type="button" value='<%= CommunityServer.Components.ResourceManager.GetString("CP_ManageRanks_Add", "ControlPanelResources.xml") %>' onclick="Telligent_Modal.Open('CreateUpdateRank.aspx', 500, 400, refresh);" />
                    </div>

                    <asp:Repeater runat="server" ID="RankList">
                        <HeaderTemplate>
                            <div class="CommonListArea">
                            <table id="Listing" cellSpacing="0" cellPadding="0" border="0" width="100%">
                                <thead>
	                                <tr>
		                                <th class="CommonListHeaderLeftMost">
		                                    &nbsp;
		                                </th>
		                                <th class="CommonListHeader">
			                                <cp:resourcecontrol runat="server" resourcename="Rank_Name" />				        
		                                </th>
		                                <th class="CommonListHeader">
			                                <cp:resourcecontrol runat="server" resourcename="Rank_MinPosts" />
		                                </th>
		                                <th class="CommonListHeader">
			                                <cp:resourcecontrol runat="server" resourcename="Rank_MaxPosts" />
		                                </th>
		                                <th class="CommonListHeader">
		                                    &nbsp;	
	                                    </th>
	                                </tr>
                                </thead>
                        </HeaderTemplate>
                        <ItemTemplate>
                            <tr>
                                <td class="CommonListCellLeftMost">
                                    <%# string.IsNullOrEmpty(Eval("RankIconUrl").ToString()) ? "&nbsp;" : "<img src=\"" + ResolveUrl(Eval("RankIconUrl").ToString()) + "\" style=\"max-height: 80px; max-width: 60px;\" />" %>
                                </td>
                                <td class="CommonListCell">
                                    <a href="javascript: Telligent_Modal.Open('CreateUpdateRank.aspx?RankID=<%# Eval("RankID") %>', 500, 400, null);"><%# Eval("RankName") %></a>
                                </td>
                                <td class="CommonListCell">
                                    <%# Eval("PostingCountMinimum")%>
                                </td>
                                <td class="CommonListCell">
                                    <%# Eval("PostingCountMaximum")%>
                                </td>
                                <td class="CommonListCell">
                                   <input type="button" value="Edit" onclick="Telligent_Modal.Open('CreateUpdateRank.aspx?RankID=<%# Eval("RankID") %>', 500, 400, refresh);" />
                                   <input type="button" value="Delete" onclick="Telligent_Modal.Open('CreateUpdateRank.aspx?Delete=1&RankID=<%# Eval("RankID") %>', 500, 400, refresh);" />
                                </td>
                            </tr>
                        </ItemTemplate>
                        <AlternatingItemTemplate>
                            <tr class="AltListRow">
                                <td class="CommonListCellLeftMost">
                                    <%# string.IsNullOrEmpty(Eval("RankIconUrl").ToString()) ? "&nbsp;" : "<img src=\"" + ResolveUrl(Eval("RankIconUrl").ToString()) + "\" style=\"max-height: 80px; max-width: 60px;\" />" %>
                                </td>
                                <td class="CommonListCell">
                                    <a href="javascript: Telligent_Modal.Open('CreateUpdateRank.aspx?RankID=<%# Eval("RankID") %>', 500, 400, null);"><%# Eval("RankName") %></a>
                                </td>
                                <td class="CommonListCell">
                                    <%# Eval("PostingCountMinimum")%>
                                </td>
                                <td class="CommonListCell">
                                    <%# Eval("PostingCountMaximum")%>
                                </td>
                                <td class="CommonListCell">
                                   <input type="button" value="Edit" onclick="Telligent_Modal.Open('CreateUpdateRank.aspx?RankID=<%# Eval("RankID") %>', 500, 400, refresh);" />
                                   <input type="button" value="Delete" onclick="Telligent_Modal.Open('CreateUpdateRank.aspx?Delete=1&RankID=<%# Eval("RankID") %>', 500, 400, refresh);" />
                                </td>
                            </tr>
                        </AlternatingItemTemplate>
                        <FooterTemplate>
                            </table>
                            </div>
                        </FooterTemplate>
                    </asp:Repeater>
                </Content>
	        </TWC:TabbedPane>
	    </TWC:TabbedPanes>
</asp:Content>