<%@ Import Namespace="CommunityServer.ControlPanel.Controls" %>
<%@ Import Namespace="CommunityServer.Components" %>
<%@ Page language="c#" Codebehind="UserEdit.aspx.cs" AutoEventWireup="true" Inherits="CommunityServer.ControlPanel.Membership.UserEdit" MasterPageFile="~/ControlPanel/Masters/MembershipAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<asp:literal id="PanelDescription" runat="server"></asp:literal>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation selectednavitem="SearchMembers" runat="server" id="SelectedNavigation1" />
	<DIV>
		<CP:statusmessage id="anonymousWarning" runat="server"></CP:statusmessage>
		<CP:statusmessage id="formStatus" runat="server"></CP:statusmessage>
		<CP:statusmessage id="impersonateWarning" runat="server" Visible="false"></CP:statusmessage>
	</DIV>
	<TWC:TabbedPanes id="UserEditTabs" runat="server"
	PanesCssClass="CommonPane"
	TabSetCssClass="CommonPaneTabSet"
	TabCssClasses="CommonPaneTab"
	TabSelectedCssClasses="CommonPaneTabSelected"
	TabHoverCssClasses="CommonPaneTabHover"
	>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_UserEdit_Tab_Admin" /></Tab>
		<Content>
			<table cellpadding="2" cellspacing="0" runat="server" id="UserSettingsTable">
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_UserID" id="Resourcelabel2" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:literal id="userID" runat="server" />
					</td>
				</tr>
				<tr id="isLockedOutRow" runat="server" visible="false">
					<td class="CommonFormFieldName">
						<font color="#FF0000">
							<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_IsLockedOut" id="Resourcelabel9" /></strong>
						</font>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="unlockUser" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="CP_UserEdit_UserName" /></strong>
					</td>
					<td class="CommonFormField">
						<a runat="server" id="changeUserName" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_Password" id="Resourcelabel15" /></strong>
					</td>
					<td class="CommonFormField">
						<a runat="server" id="changePassword" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="CP_UserEdit_Roles" id="Resourcelabel52" /></strong>
					</td>
					<td class="CommonFormField">
						<a runat="server" id="changeRoles" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="CP_UserEdit_ImpersonateLabel" /></strong>
					</td>
					<td class="CommonFormField">
					    <CP:ResourceLinkButton runat="server" ResourceName="CP_UserEdit_ImpersonateLink" ID="impersonateUserButton" CausesValidation="false" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_ForceLogin" id="Resourcelabel6" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="forceLogin" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_IsIgnored" id="Resourcelabel29" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="isIgnored" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_AccountStatus" id="Resourcelabel7" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:accountstatusdropdownlist  id="accountStatus" runat="server" AutoPostBack="true" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_ModerationLevel" id="Resourcelabel8" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:moderationleveldropdownlist  id="moderationLevel" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_DummyTotalPosts" id="Resourcelabel1" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="dummyTotalPosts" size="10" runat="server" maxlength="10" />
					</td>
				</tr>
			</table>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_UserEdit_Tab_AboutUser" /></Tab>
		<Content>
			<table cellpadding="3" cellspacing="0" runat="server" id="AboutUserTable">
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutUserName" id="Resourcelabel18" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="usernameEdit" runat="server" />
						<asp:requiredfieldvalidator id="UsernameEditValidator" runat="server" controltovalidate="UsernameEdit" enableclientscript="false" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_DateCreated" id="Resourcelabel19" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:literal id="dateCreated" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_LastLogin" id="Resourcelabel20" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:literal id="lastLogin" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_LastActivity" id="Resourcelabel21" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:literal id="lastActivity" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="EditProfile_CommonName" id="ResourceControl2" name="ResourceControl2" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="CommonName" size="30" maxlength="50" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutLocation" id="Resourcelabel22" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="location" size="50" runat="server" maxlength="50" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutOccupation" id="Resourcelabel23" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="occupation" size="50" runat="server" maxlength="50" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutInterests" id="Resourcelabel24" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="interests" size="50" runat="server" maxlength="50" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:ResourceControl runat="server" ResourceName="EditProfile_Birthday" id="Resourcecontrol22"/></strong>
					</td>
					<td class="CommonFormField">
						<asp:RadioButton GroupName="Birthday" ID="enableBirthdayRadioButton" runat="server" /><TWC:DateTimeSelector runat="server" id="birthdayDateTimeSelector" DateTimeFormat="MMMM d, yyyy" ShowCalendarPopup="true" /><br />
					    <asp:RadioButton GroupName="Birthday" ID="disableBirthdayRadioButton" runat="server" Text="Not Set" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutGender" id="Resourcelabel25" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:genderradiobuttonlist  id="gender" repeatcolumns="3" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutWebAddress" id="Resourcelabel26" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="webAddress" size="50" runat="server" maxlength="255" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutWebLog" id="Resourcelabel27" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="webLog" size="50" runat="server" maxlength="255" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutWebGallery" id="Resourcelabel51" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="webGallery" size="50" runat="server" maxlength="255" />
					</td>
				</tr>
				<tr>
				    <td class="CommonFormFieldName">
				        <strong>Share Favoritets</strong>
				    </td>
				    <td class="CommonFormField">
				        <CP:YesNoRadioButtonList runat="server" ID="shareFavorites" repeatcolumns="2" />
				    </td>
				</tr>
				<tr>
					<td class="CommonFormFieldName" valign="top">
						<strong>Bio</strong>
					</td>
					<td>
					    <CSControl:Editor runat="server" id="bio" />
					</td>
				</tr>
			</table>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_UserEdit_Tab_Avatar" /></Tab>
		<Content>
			<table cellpadding="3" cellspacing="0" runat="server" id="AvatarSection">
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="ViewUserProfile_Avatar" id="Resourcelabel36" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:useravatar OverrideUser="true" visible="False" id="avatar" runat="server" padimage="False" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="UserAdmin_IsAvatarApproved" id="Resourcelabel5" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="isAvatarApproved" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AvatarEnable" id="Resourcelabel37" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="enableAvatar" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_UploadAvatar" id="Resourcelabel38" /></strong>
					</td>
					<td class="CommonFormField">
						<input type="file" runat="server" id="uploadedAvatar" name="uploadedAvatar" />
						<asp:button id="avatarUpdateButton" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AvatarUrl" id="Resourcelabel39" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:textbox id="avatarUrl" size="50" runat="server" maxlength="256" />
					</td>
				</tr>
			</table>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_UserEdit_Tab_SiteOptions" /></Tab>
		<Content>
			<table cellpadding="3" cellspacing="0" runat="server" id="ForumOptionsTable">
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_OptionsLanguage" id="Resourcelabel43" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:languagedropdownlist id="language" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_AboutTimeZone" id="Resourcelabel41" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:timezonedropdownlist id="timezone" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_OptionsDateFormat" id="Resourcelabel44" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:dateformatdropdownlist id="dateFormat" runat="server" />
					</td>
				</tr>
				<tr id="ThreadSortOptions" runat="server">
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_OptionsSortOrder" id="Resourcelabel17" name="Resourcelabel17" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:sortorderdropdownlist  id="sortOrder" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_FontSize" id="Resourcelabel35" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:fontsizedropdownlist id="FontSize" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_Editor" id="Resourcelabel40" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:dropdownlist id="EditorList" runat="server" />
					</td>
				</tr>
				<tr runat="server" visible = "<%# CSContext.Current.SiteSettings.EnableDisplayNames %>">
					<td class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="EditProfile_DisplayName" id="Resourcecontrol17" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="enableDisplayNames" runat="server" repeatcolumns="2" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_DisplayInMemberList" id="Resourcelabel45" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="displayInMemberList" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr id="EnablePostPreviewPopupRow" runat="server">
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="Admin_SiteSettings_EnablePostPreviewPopup" id="Resourcelabel46" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="enablePostPreviewPopup" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="Admin_SiteSettings_EnableCollapsingPanels" id="Resourcelabel47" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="EnableCollapsingPanels" runat="server" repeatcolumns="2" />
					</td>
				</tr>
				<tr>
				    <td class="CommonFormFieldName">
				        <strong>Enable Conversation Notifications</strong>
				    </td>
				    <td class="CommonFormField">
				        <CP:YesNoRadioButtonList runat="server" ID="conversationNotifications" repeatcolumns="2" />
				    </td>
				</tr>
				<tr>
				    <td class="CommonFormFieldName">
				        <strong>Enable Comment Notifications</strong>
				    </td>
				    <td class="CommonFormField">
				        <CP:YesNoRadioButtonList runat="server" ID="commentNotifications" repeatcolumns="2" />
				    </td>
				</tr>
				<tr id="EmoticonRow" runat="Server">
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="Admin_SiteSettings_EnableEmoticons" id="Resourcelabel14"
							name="Resourcelabel14" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="enableEmoticons" runat="server" repeatcolumns="2" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="EditProfile_EnableUserAvtars" id="Resourcecontrol18" /></strong>
					</td>
					<td class="CommonFormField" nowrap="nowrap">
						<cp:yesnoradiobuttonlist  id="enableUserAvtars" runat="server" repeatcolumns="2" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcecontrol runat="server" resourcename="EditProfile_EnableUserSignatures" id="Resourcecontrol19" /></strong>
					</td>
					<td class="CommonFormField" nowrap="nowrap">
						<cp:yesnoradiobuttonlist  id="enableUserSignatures" runat="server" repeatcolumns="2" />
					</td>
				</tr>
				<tr>
                    <td class="CommonFormFieldName">
	                    <CSControl:FormLabel runat="server" ResourceName="EditProfile_CPGridItemsPerPage" LabelForId="ControlPanelPageSizeDropDownList" />
                    </td>
                    <td class="CommonFormField">
	                    <asp:dropdownlist id="ControlPanelPageSizeDropDownList" runat="Server">
		                    <asp:listitem value="5">5</asp:listitem>
		                    <asp:listitem value="10">10</asp:listitem>
		                    <asp:listitem value="20">20</asp:listitem>
		                    <asp:listitem value="30">30</asp:listitem>
		                    <asp:listitem value="40">40</asp:listitem>
		                    <asp:listitem value="50">50</asp:listitem>
	                    </asp:dropdownlist>
                    </td>
                </tr>
				<tr>
					<td class="CommonFormFieldName" valign="top">
						<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_AboutSignature" id="Resourcelabel28" /></strong>
					</td>
					<td class="CommonFormField" valign="top">
					    <CSControl:Editor runat="server" id="signature" />
						<asp:rangevalidator controltovalidate="signature" id="signatureMaxLengthValidator" enableclientscript="false"
							runat="server" />
					</td>
				</tr>
			</table>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_UserEdit_Tab_EmailContactInfo" /></Tab>
		<Content>	
				<h3 class="CommonSubTitle">
					<cp:resourcecontrol runat="server" resourcename="EditProfile_PrivateTitle" id="Resourcecontrol4" /></h3>
				<table cellpadding="2" cellspacing="0" border="0">
					<tr>
						<td class="CommonFormFieldName">
							<strong><cp:resourcelabel runat="server" resourcename="EditProfile_ContactPrivateEmail" id="Resourcelabel16" /></strong>
						</td>
						<td class="CommonFormField">
							<asp:textbox id="privateEmail" size="50" runat="server" maxlength="50" />
							<asp:requiredfieldvalidator runat="server" controltovalidate="privateEmail">*</asp:requiredfieldvalidator>
						    <asp:regularexpressionvalidator runat="server" controltovalidate="privateEmail"
							    validationexpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*">Email not in correct format.</asp:regularexpressionvalidator>
						</td>
					</tr>
				</table>

				<h3 class="CommonSubTitle">
					<cp:resourcecontrol runat="server" resourcename="EditProfile_EmailTitle" id="Resourcecontrol1" /></h3>
				<table cellpadding="2" cellspacing="0" border="0">
					<tr>
						<td class="CommonFormFieldName">
							<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_OptionsReceiveEmails" id="Resourcelabel48" /></strong>
						</td>
						<td class="CommonFormField">
							<cp:yesnoradiobuttonlist  id="enableEmail" runat="server" repeatdirection="Horizontal" />
						</td>
					</tr>
					<tr>
						<td class="CommonFormFieldName">
							<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_OptionsHtmlEmail" id="Resourcelabel49" /></strong>
						</td>
						<td class="CommonFormField">
							<cp:yesnoradiobuttonlist  id="enableHtmlEmail" runat="server" repeatdirection="Horizontal" />
						</td>
					</tr>
					<tr>
						<td class="CommonFormFieldName">
							<strong><CP:ResourceLabel runat="server" resourcename="EditProfile_OptionsEmailTracking" id="Resourcelabel50" /></strong>
						</td>
						<td class="CommonFormField">
							<cp:yesnoradiobuttonlist  id="enableEmailTracking" runat="server" repeatdirection="Horizontal" />
						</td>
					</tr>
				</table>

                <h3 class="CommonSubTitle"><cp:ResourceControl runat="server" ResourceName="EditProfile_ConversationsPreferences" /></h3>
                <table>				                    
                    <tr>
                        <td class="CommonFormFieldName">
                            <strong><cp:ResourceControl runat="server" ResourceName="EditProfile_AllowConversationsFrom" /></strong>
                        </td>
                        <td class="CommonFormField">
                            <cp:usercontacttyperadiobuttonlist id="enableStartConversations" RepeatColumns="3" runat="server" RepeatLayout="flow" />
                        </td>
                    </tr>
                </table>

				<h3 class="CommonSubTitle">
					<cp:resourcecontrol runat="server" resourcename="EditProfile_ContactTitle" id="Resourcecontrol3" /></h3>
				<table cellpadding="3" cellspacing="0">
					<tr>
						<td class="CommonFormFieldName">
							<strong><cp:resourcelabel runat="server" resourcename="EditProfile_ContactPublicEmail" id="Resourcelabel30" /></strong>
						</td>
						<td class="CommonFormField">
							<asp:textbox id="publicEmail" size="50" runat="server" maxlength="50" />
							<asp:regularexpressionvalidator runat="server" controltovalidate="publicEmail"
							    validationexpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*">Email not in correct format.</asp:regularexpressionvalidator>
						</td>
					</tr>
					<tr>
						<td class="CommonFormFieldName">
							<strong><cp:resourcelabel runat="server" resourcename="EditProfile_ContactMsn" id="Resourcelabel31" /></strong>
						</td>
						<td class="CommonFormField">
							<asp:textbox id="msnIM" size="50" runat="server" maxlength="50" />
						</td>
					</tr>
					<tr>
						<td class="CommonFormFieldName">
							<strong><cp:resourcelabel runat="server" resourcename="EditProfile_ContactAol" id="Resourcelabel32" /></strong>
						</td>
						<td class="CommonFormField">
							<asp:textbox id="aolIM" size="50" runat="server" maxlength="50" />
						</td>
					</tr>
					<tr>
						<td class="CommonFormFieldName">
							<strong><cp:resourcelabel runat="server" resourcename="EditProfile_ContactYahoo" id="Resourcelabel33" /></strong>
						</td>
						<td class="CommonFormField">
							<asp:textbox id="yahooIM" size="50" runat="server" maxlength="50" />
						</td>
					</tr>
					<tr>
						<td class="CommonFormFieldName">
							<strong><cp:resourcelabel runat="server" resourcename="EditProfile_ContactIcq" id="Resourcelabel34" /></strong>
						</td>
						<td class="CommonFormField">
							<asp:textbox id="icq" size="50" runat="server" maxlength="50" />
						</td>
					</tr>
				</table>

		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_UserEdit_Tab_Ban" /></Tab>
		<Content>
			<table cellpadding="3" cellspacing="0" visible="false" runat="server" id="userBanSection">
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_UserBanPeriod" id="Resourcelabel10" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:userbandropdownlist  id="userBanPeriod" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_UserBanReason" id="Resourcelabel4" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:userbanreasondropdownlist  id="userBanReason" runat="server" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_BanedUntilDate" id="Resourcelabel11" /></strong>
					</td>
					<td class="CommonFormField">
						<asp:label id="bannedUntilDate" runat="server" />
					</td>
				</tr>
			</table>
			<table cellpadding="3" cellspacing="0" visible="false" runat="server" id="userApprovalSection">
				<tr>
					<td colspan="2">
						<cp:resourcelabel runat="server" resourcename="EditProfile_UserApprovalTitle" id="Resourcelabel12" />
					</td>
				</tr>
				<tr>
					<td class="CommonFormFieldName">
						<strong><cp:resourcelabel runat="server" resourcename="EditProfile_UserApproval" id="Resourcelabel13" /></strong>
					</td>
					<td class="CommonFormField">
						<cp:yesnoradiobuttonlist  id="isApproved" runat="server" repeatdirection="Horizontal" />
					</td>
				</tr>
			</table>
		</Content>
	</TWC:TabbedPane>
	</TWC:TabbedPanes>
	<p class="PanelSaveButton DetailsFixedWidth">
		<cp:resourcelinkbutton id="updateButton" runat="server" cssclass="CommonTextButton" resourcename="EditProfile_Update" />
	</p>
</asp:Content>