<%@ Page language="c#" Codebehind="Roles.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Membership.Roles" MasterPageFile="~/ControlPanel/Masters/MembershipAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
    <cp:resourcelabel id=Resourcelabel1 runat="server" resourcename="CP_Membership_Roles_Title"></cp:resourcelabel>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation selectednavitem="Roles" runat="server" />
    <script type="text/javascript">
    function reloadRoles(res) {
        
        if(res)
        {
	        refresh();
	    }
    }
    </script>
	    <table cellpadding="0" cellspacing="0" border="0"  width="100%">
		    <tr>
			    <td>
				    <cp:resourcelabel id="DescResourceLabel" runat="server" resourcename="CP_Membership_Roles_ItemsPerPage"></cp:resourcelabel>&nbsp;
				    <asp:dropdownlist id="PageList" runat="Server" AutoPostBack="True">
					    <asp:listitem value="10">10</asp:listitem>
					    <asp:listitem value="20">20</asp:listitem>
					    <asp:listitem value="30">30</asp:listitem>
					    <asp:listitem value="40">40</asp:listitem>
					    <asp:listitem value="50">50</asp:listitem>
				    </asp:dropdownlist>
			    </td>
			    <td nowrap="nowrap" style="text-align:right; padding-right: 10px;">
				    <cp:ModalButton Height="280" Width="550" runat="Server" ResourceName="CP_Membership_Roles_AddRole" Callback="reloadRoles" id="AddRole" />
			    </td>
		    </tr>
	    </table>
    <br />

    <CP:RepeaterPlusNone runat="server" ID="RolesRepeater">
        <HeaderTemplate>
        <table cellpadding="0" cellspacing="0" border="0"  width="100%">
            <tr>
                <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Membership_Roles_GridCol_Name" /></th>
                <th class="CommonListHeader"><CP:ResourceControl runat="server" ResourceName="CP_Membership_Roles_GridCol_Description" /></th>
                <th class="CommonListHeader">&nbsp;</th>
            </tr>
        </HeaderTemplate>
        <ItemTemplate>
            <tr>
                <td class="CommonListCellLeftMost">
                    <a href='javascript:Telligent_Modal.Open("RoleEdit.aspx?RoleID=<%# Eval("RoleID") %>", 500, 400, reloadRoles);' title='Edit <%# Eval("Name") %> Role'><%# Eval("Name") %></a>
                </td>
                <td class="CommonListCell">
                    <%# Eval("Description") %>&nbsp;
                </td>
                <td class="CommonListCell"  nowrap="true">
                       <input type="button" value="Edit" onclick='Telligent_Modal.Open("RoleEdit.aspx?RoleID=<%# Eval("RoleID") %>", 500, 400, reloadRoles);' />
                       &nbsp;
                       <input type="button" value="View" onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("membership_ControlPanel_UserSearch_Role", Eval("RoleID").ToString()) %>'"  />
                       &nbsp;
                       <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("RoleID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this role?');" ResourceName="CP_PermissionList_Delete" />
                </td>
            </tr>
        </ItemTemplate>
        <AlternatingItemTemplate>
            <tr class="AltListRow">
                <td class="CommonListCellLeftMost">
                    <a href='javascript:Telligent_Modal.Open("RoleEdit.aspx?RoleID=<%# Eval("RoleID") %>", 500, 400, reloadRoles);' title='Edit <%# Eval("Name") %> Role'><%# Eval("Name") %></a>
                </td>
                <td class="CommonListCell">
                    <%# Eval("Description") %>&nbsp;
                </td>
                <td class="CommonListCell" nowrap="true">
                       <input type="button" value="Edit" onclick='Telligent_Modal.Open("RoleEdit.aspx?RoleID=<%# Eval("RoleID") %>", 500, 400, reloadRoles);' />
                       &nbsp;
                       <input type="button" value="View"onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("membership_ControlPanel_UserSearch_Role", Eval("RoleID").ToString()) %>'"  />
                       &nbsp;
                       <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("RoleID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this role?');" ResourceName="CP_PermissionList_Delete" />
                </td>
            </tr>
        </AlternatingItemTemplate>
        <FooterTemplate>
        </table>
        </FooterTemplate>
    </CP:RepeaterPlusNone>

    <CSControl:Pager runat="Server" id="csPager" />

</asp:Content>