<%@ Control Language="c#" AutoEventWireup="false" Codebehind="MediaGalleryEditControlDetails.ascx.cs" Inherits="CommunityServer.ControlPanel.MediaGalleryAdmin.MediaGalleryEditControlDetails" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Import Namespace="CommunityServer.Components" %>

<script type="text/javascript">
    function IsNewGroup(groupId)
    {
        var groupRow = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "newGroupRow").ClientID %>');
        if (groupRow && groupId != 0)
        {
            groupRow.style.visibility = "hidden";
            groupRow.style.position = "absolute";
            return;
        }  
        
        if (groupRow)
        {
            groupRow.style.visibility = "visible";
            groupRow.style.position = "relative";
        }
    }
    
    function IsNewGroupNameValid(sender, args)
    {
        var adminGroupList = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "AdminGroupList").ClientID %>');
        
        if (!adminGroupList || adminGroupList.value != 0)
        {
            args.IsValid = true;
            return;
        }
        
        var groupNameField = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "NewGroupName").ClientID %>');
        
        if (!groupNameField || groupNameField.value.length < 1)
        {
            args.IsValid = false;
            return;
        }
        
        args.IsValid = true;    
        return;
    }
</script>

<table cellspacing="0" cellpadding="0" border="0" id="AdvancedProperties" runat="server">
	<tr>
		<td class="CommonFormFieldName">
			<strong><CP:ResourceControl runat="Server" ResourceName="CP_MediaGalleryAdmin_MediaGalleryEditControl_Name" /></strong><br />
			<cp:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Name_Detail" />
		</td>
		<td class="CommonFormField">
			<asp:textbox id="Name" runat="server" maxlength="256" columns="50" ></asp:textbox>
			<asp:requiredfieldvalidator id="Requiredfieldvalidator1" runat="server" controltovalidate="Name">*</asp:requiredfieldvalidator>
			<asp:RegularExpressionValidator ValidationExpression="^.*[^\s]+.*$" 
                 ControlToValidate="Name" Display="dynamic"
                 ErrorMessage="<br/>Name does not contain an alphanumeric character." runat="server" />
		</td>
	</tr>
	<tr>
		<td class="CommonFormFieldName">
			<strong><CP:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_AppKey" /></strong><br />
			<cp:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_AppKey_Detail" />
		</td>
		<td class="CommonFormField">
			<ASP:Literal Runat="server" ID="AppKeyUrlPrefix" /><asp:textbox id="AppKey" runat="server" maxlength="256" columns="50"  style="width: 100px;"></asp:textbox><ASP:Literal Runat="server" ID="AppKeyUrlSuffix" />
			<asp:requiredfieldvalidator id="AppKeyValidator" runat="server" controltovalidate="Name">*</asp:requiredfieldvalidator>
		</td>
	</tr>
	<tr runat="server" id="groupSelectRow">
		<td class="CommonFormFieldName">
			<strong><CP:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Group" /></strong><br />
			<cp:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Group_Detail" />
		</td>
		<td class="CommonFormField">
			<asp:DropDownList id="AdminGroupList" Runat="server" onchange="IsNewGroup(this.value)" />
			<asp:RequiredFieldValidator runat="server" ErrorMessage="*" ControlToValidate="AdminGroupList"
				ID="AdminGroupValidator" />
		</td>
	</tr>
	<tr runat="server" id="newGroupRow" style="visibility: hidden; position:absolute;">
	    <td class="CommonFormFieldName" vAlign="top">
			<strong><CP:FORMLABEL runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_NewGroup" controltolabel="AdminGroupList" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_CreateEditMediaGallery_NewGroup_Desc" />
		</td>
		<td class="CommonFormField">
			<asp:TextBox runat="server" ID="NewGroupName" Text="General" />
			<asp:CustomValidator runat="server" ClientValidationFunction="IsNewGroupNameValid" ErrorMessage="*" />
		</td>
	</tr>
	<tr>
		<td class="CommonFormFieldName">
			<strong><CP:ResourceControl runat="Server" ResourceName="CP_MediaGalleryAdmin_MediaGalleryEditControl_Enable" /></strong><br />
			<cp:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Enable_Detail" />
		</td>
		<td class="CommonFormField">
			<cp:yesnoradiobuttonlist id="ynIsActive" runat="server" repeatcolumns="2"  />
		</td>
	</tr>
	<tr>
		<td class="CommonFormFieldName">
			<strong><CP:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Index" /></strong><br />
			<cp:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Index_Detail" />
		</td>
		<td class="CommonFormField">
			<cp:yesnoradiobuttonlist id="ynIsSearchable" runat="server" repeatcolumns="2"  />
		</td>
	</tr>
	<tr>
		<td class="CommonFormFieldName">
			<strong><CP:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Owners" /></strong><br />
			<cp:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Owners_Detail" />
			<em>
				<CP:ResourceControl runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_Optional" id="Resourcecontrol38" /></em>
		</td>
		<td class="CommonFormField">
			<CSControl:UserLookUpTextBox runat="server" ID="Owners" Width="275px" />
		</td>
	</tr>
	<tr runat="server" id="SectionLocalizationArea">
		<td class="CommonFormFieldName">
			<strong><cp:resourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_DefaultLanguage" /></strong><br />
			<cp:ResourceControl runat="Server" resourcename="CP_MediaGalleryAdmin_MediaGalleryEditControl_DefaultLanguage_Detail" />
		</td>
		<td class="CommonFormField">
			<cp:FilterLanguageDropDownList runat="server" id="DefaultLanguage" />
		</td>
	</tr>
	<tr runat="server" id="ViewModePanel">
        <td class="CommonFormFieldName">
            <strong><CP:ResourceControl runat="Server" ResourceName="CP_MediaGalleries_PresentationOptions_ViewMode" /></strong><br />
            <CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_PresentationOptions_ViewMode_Help" />
        </td>
        <td class="CommonFormField">
            <asp:DropDownList runat="server" ID="ViewModeDropDown" />
        </td>
    </tr>
</table>
