<%@ Control Language="c#" AutoEventWireup="false" Codebehind="MediaGalleryEditControl.ascx.cs" Inherits="CommunityServer.ControlPanel.MediaGalleryAdmin.MediaGalleryEditControl" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="CP" TagName = "MediaGalleryDetails" Src = "~/ControlPanel/MediaGalleryAdmin/MediaGalleryEditControlDetails.ascx" %>
<%@ Register TagPrefix="CP" TagName = "MediaGalleryOptions" Src = "~/ControlPanel/MediaGalleryAdmin/MediaGalleryOptionsControl.ascx" %>
<%@ Register TagPrefix="CP" TagName = "MediaGalleryQuotas" Src = "~/ControlPanel/MediaGalleryAdmin/MediaGalleryQuotasControl.ascx" %>

<TWC:TabbedPanes id="EditorTabs" runat="server"
	PanesCssClass="CommonPane"
	TabSetCssClass="CommonPaneTabSet"
	TabCssClasses="CommonPaneTab"
	TabSelectedCssClasses="CommonPaneTabSelected"
	TabHoverCssClasses="CommonPaneTabHover"
	>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_CreateEditMediaGallery_Tab_Settings" /></Tab>
		<Content>
			<CP:MediaGalleryDetails id="SectionDetails1" runat="Server"></CP:MediaGalleryDetails>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" ID="AdvancedTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_CreateEditMediaGallery_Tab_Options" /></Tab>
		<Content>
			<CP:MediaGalleryOptions id="MediaGalleryOptions1" runat="Server"></CP:MediaGalleryOptions>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" id="PermissionsTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_CreateEditMediaGallery_Tab_Permissions" /></Tab>
		<Content>
			<div>
                <asp:DropDownList runat="server" ID="UnchangedPermissionsList" DataTextField="Name" DataValueField="Name" />
                <asp:Button runat="server" ID="AddUserPermissionButton" Text="Add Role" />
            </div>
            <br />
            <CP:RepeaterPlusNone runat="server" ID="PermissionList" ShowHeaderFooterOnNone="false">
                <HeaderTemplate>
                    <table cellSpacing=0 cellPadding=0 width="100%">
                    <tbody>
                        <tr>
                            <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Name" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_View" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Download" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Delete" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Edit" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Reply" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Post" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_LocalAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_RemoteAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                        </tr>    
                </HeaderTemplate>
                <ItemTemplate>
                        <tr class="Row">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Download") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </ItemTemplate>
                <AlternatingItemTemplate>
                        <tr class="AlternatingRow">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Download") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </AlternatingItemTemplate>
                <FooterTemplate>
                    </tbody>
                    </table>
                </FooterTemplate>
                <NoneTemplate>
                    <div class="CommonMessageWarning">
                        <CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_NoPermissionsMessage" />
                    </div>
                </NoneTemplate>
            </CP:RepeaterPlusNone>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" id="QuotasTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_CreateEditMediaGallery_Tab_Quotas" /></Tab>
		<Content>
		    <CP:MediaGalleryQuotas runat="server" id="MediaGalleryQuotas1" />
		</Content>
    </TWC:TabbedPane>
</TWC:TabbedPanes>	
