<%@ Page language="c#" Codebehind="MediaGalleries.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.MediaGalleryAdmin.MediaGalleries" MasterPageFile="~/ControlPanel/Masters/MediaGalleryAdmin.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl id="ResourceControl1" runat="server" ResourceName="CP_MediaGalleryAdmin_MediaGalleries_Title"></CP:ResourceControl>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="MediaGalleries" />
    
	<DIV class="CommonDescription">
	    <CSControl:ConditionalContent runat="server">
            <ContentConditions>
                <CSControl:QueryStringPropertyValueComparison runat="server" QueryStringProperty="SectionID" Operator="GreaterThan" ComparisonValue="-1" />
                <CSMedia:MediaGalleryPropertyValueComparison runat="server" ComparisonProperty="Name" Operator="IsSetOrTrue" />
            </ContentConditions>
            <TrueContentTemplate>
                <CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_NewMediaGalleryMessage">
                    <Parameter1Template><CSMedia:MediaGalleryData runat="server" Property="Name" LinkTo="MediaGalleryHome" /></Parameter1Template>
                </CP:ResourceControl>
            </TrueContentTemplate>
            <FalseContentTemplate>
                <CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_MediaGalleries_Description" />
            </FalseContentTemplate>
        </CSControl:ConditionalContent>
	</DIV>
	
	<h3><CP:CSLiteral runat="server" ID="message" /></h3>
    <h4><CP:CSLiteral runat="server" ID="deletedMessage" /></h4>
    
    <table border="0" cellpadding="3" cellspacing="0">
        <tr>
            <td width="75px"><CP:ResourceControl resourcename="CP_MediaGalleryAdmin_MediaGalleries_Filter" runat = "Server"/></td>
            <td><cp:AlphaPicker runat = "Server" id = "picker" /></td>
        </tr>
        <tr>
            <td width="75px"><CP:ResourceControl resourcename="CP_MediaGalleryAdmin_MediaGalleries_Search" runat = "Server"/></td>
            <td><input type="text" id = "q" name="q" value ="<%= Server.HtmlEncode(Request.QueryString["q"]) %>"></input> <input type="button" onclick="javascript:window.location = window.location.pathname + '?q=' + escape(q.value)" value ="Go" /></td>
        </tr>
    </table>
    			
    <div class="CommonListArea" style="clear:both">
    <asp:Repeater runat = "Server" id = "theMediaGalleries">
    <HeaderTemplate>
    <table id="BlogLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
    <thead>
    <tr>
        <th class="CommonListHeaderLeftMost" ><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_MG" ID="Resourcecontrol5" NAME="Resourcecontrol3"/></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Name" ID="Resourcecontrol6" NAME="Resourcecontrol4"/></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Owners" ID="Resourcecontrol7" NAME="Resourcecontrol4"/></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Group" ID="Resourcecontrol8" NAME="Resourcecontrol4"/></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Enabled" ID="Resourcecontrol9" NAME="Resourcecontrol4"/></th>    
        <th class="CommonListHeader">&nbsp;</th>
    </tr>
    </thead>
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td class="CommonListCellLeftMost"><a href="<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().ViewMediaGallery(Eval("ApplicationKey").ToString()) %>"><%# Formatter.RemoveHtml(Eval("ApplicationKey").ToString(), 50) %></a></td>
        <td class="CommonListCell"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></td>
        <td class="CommonListCell"><%# FormatOwners(DataBinder.Eval(Container.DataItem,"Owners")) %>&nbsp;</td>
        <td  class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
	    <td class="CommonListCell" align="center"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.gif" width="16" height="15" /></td>    
	    <td class ="CommonListCell" nowrap="nowrap">
		    <CP:SectionIsPublicToggleButton runat="server" id="sectionIsPublic" Tag="Span" CssClass="CommonTextButton"></CP:SectionIsPublicToggleButton>
		    <input type="button" onclick="window.location = 'CreateEditMediaGallery.aspx?SelectedNavItem=MediaGalleries&amp;SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>';" value="Edit" />
            <input type="button" onclick="window.location = '../mediagalleries/default.aspx?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>';" value="Manage" /> 
            <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this media gallery?');" ResourceName="CP_PermissionList_Delete" />
	    </td>
    </tr>
    </ItemTemplate>
    <AlternatingItemTemplate>
    <tr class="AltListRow">
        <td class="CommonListCellLeftMost"><a href="<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().ViewMediaGallery(Eval("ApplicationKey").ToString()) %>"><%# Formatter.RemoveHtml(Eval("ApplicationKey").ToString(), 50)%></a></td>
        <td class="CommonListCell"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></td>
        <td class="CommonListCell"><%# FormatOwners(DataBinder.Eval(Container.DataItem,"Owners")) %>&nbsp;</td>
        <td  class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
	    <td class="CommonListCell" align="center"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.gif" width="16" height="15" /></td>    
	    <td class ="CommonListCell" nowrap="nowrap">
	        <CP:SectionIsPublicToggleButton runat="server" id="SectionIsPublicToggleButton1" Tag="Span" CssClass="CommonTextButton"></CP:SectionIsPublicToggleButton>
		    <input type="button" onclick="window.location = 'CreateEditMediaGallery.aspx?SelectedNavItem=MediaGalleries&amp;SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>';" value="Edit" />
            <input type="button" onclick="window.location = '../mediagalleries/default.aspx?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>';" value="Manage" /> 
            <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this media gallery?');" ResourceName="CP_PermissionList_Delete" />
	    </td>	
    </tr>
    </AlternatingItemTemplate>
    <FooterTemplate>
    </table>
    </FooterTemplate>
    </asp:Repeater>
    </div>					
</asp:Content>