<%@ Page language="c#" Codebehind="Groups.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.MediaGalleryAdmin.MediaGalleryGroups" MasterPageFile="~/ControlPanel/Masters/MediaGalleryAdmin.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_MediaGalleryGroups_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="MediaGalleryGroups" />
	<div class="CommonDescription">
		<CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_MediaGalleryGroups_Description" />
	</div>
		    
    <p style="text-align: right;">
        <input type=button onclick="window.location = 'GroupForm.aspx?GroupID=-1';" runat="Server" value='Add New Group' />
    </p>
    <div class="CommonListArea" style="clear:both">
        <CSControl:WrappedRepeater runat = "Server" id = "theGroups">
            <HeaderTemplate>
                <table id="GroupLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
                <thead>
                <tr>
                    <th class="CommonListHeaderLeftMost"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGroupGrid_Name" /></th>
                    <th class="CommonListHeader" ><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGroupGrid_Description" /></th>
                    <th class="CommonListHeader">&nbsp;</th>
                </tr>
                </thead>
            </HeaderTemplate>
            <ItemTemplate>
                <tr>
                    <td class="CommonListCellLeftMost">
                        <a href="<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().ViewMediaGalleryGroup(int.Parse(Eval("GroupID").ToString())) %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a>
                    </td>
                    <td class="CommonListCell">
                        <%# DataBinder.Eval(Container.DataItem,"Description") %>&nbsp;
                    </td>
                    <td class="CommonListCell">
                        <input type="button" onclick="window.location = 'GroupForm.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Edit" />
                        <input type="button" onclick="window.location = 'MediaGalleries.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Manage" /> 
                        <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("GroupID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this media gallery group?');" ResourceName="CP_PermissionList_Delete" />
                    </td>
                </tr>
            </ItemTemplate>
            <AlternatingItemTemplate>
                <tr class="AltListRow">
                    <td class="CommonListCellLeftMost">
                        <a href="<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().ViewMediaGalleryGroup(int.Parse(Eval("GroupID").ToString())) %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a>
                    </td>
                    <td class="CommonListCell">
                        <%# DataBinder.Eval(Container.DataItem,"Description") %>&nbsp;
                    </td>
                    <td class="CommonListCell">
                        <input type="button" onclick="window.location = 'GroupForm.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Edit" />
                        <input type="button" onclick="window.location = 'MediaGalleries.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Manage" /> 
                        <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("GroupID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this media gallery group?');" ResourceName="CP_PermissionList_Delete" />
                    </td>
                </tr>
            </AlternatingItemTemplate>
            <FooterTemplate>
                </table>
            </FooterTemplate>
            <NoneTemplate>
                <tr>
                    <td colspan="6">
                        <div class="CommonMessageWarning">
                            <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" width="16" height="16" />
                            <CP:ResourceControl runat="server" ResourceName="CP_MediagalleryAdmin_MediaGalleryGroupList_NoGroups" />
                        </div>
                    </td>
                </tr>
            </NoneTemplate>	
        </CSControl:WrappedRepeater>
    </div>
	
</asp:Content>