<%@ Page language="c#" Codebehind="GroupForm.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.MediaGalleryAdmin.MediaGalleryGroupForm" MasterPageFile="~/ControlPanel/Masters/MediaGalleryAdmin.master" %>
<%@ Import Namespace="CommunityServer.Components" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server" />

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation ID="ControlPanelSelectedNavigation1" runat="server" SelectedNavItem="MediaGalleryGroups" />
    <asp:Panel runat="server" DefaultButton="Save">
    <TWC:TabbedPanes runat="server"
        PanesCssClass="CommonPane"
        TabSetCssClass="CommonPaneTabSet"
        TabCssClasses="CommonPaneTab"
        TabSelectedCssClasses="CommonPaneTabSelected"
        TabHoverCssClasses="CommonPaneTabHover"
    >
    <TWC:TabbedPane runat="server">
        <Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_Basic" /></Tab>
        <Content>
		
				<DIV class="CommonFormFieldName">
					<CP:FormLabel id="tt" runat="Server" ControlToLabel="GroupName" resourcename="CP_MediaGalleryAdmin_MediaGalleryGroup_GroupName"></CP:FormLabel>
					<asp:requiredfieldvalidator id="ForumGroupNameValidator" runat="server" controltovalidate="GroupName" errormessage="*"></asp:requiredfieldvalidator></DIV>
				<DIV class="CommonFormField">
					<asp:TextBox id="GroupName" Runat="server" CssClass="ControlPanelTextInput" MaxLength="256"></asp:TextBox></DIV>
				<DIV class="CommonFormFieldName">
					<CP:FormLabel id="Formlabel1" runat="Server" ControlToLabel="GroupDesc" ResourceName="CP_MediaGalleryAdmin_MediaGalleryGroup_Description"></CP:FormLabel></DIV>
				<DIV class="CommonFormField">
					<asp:TextBox id="GroupDesc" Runat="server" CssClass="ControlPanelTextInput" MaxLength="256" TextMode="MultiLine" Rows="7"></asp:TextBox>
				</DIV>
        </Content>
    </TWC:TabbedPane>
    
    <TWC:TabbedPane runat="server" id="PermissionsTab">
	    <Tab><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_CreateEditMediaGallery_Tab_Permissions" /></Tab>
	    <Content>
		    <div>
                <asp:DropDownList runat="server" ID="UnchangedPermissionsList" DataTextField="Name" DataValueField="Name" />
                <asp:Button runat="server" ID="AddUserPermissionButton" Text="Add Role" />
            </div>
            <br />
		    <div id="GrayGrid">
            <CP:RepeaterPlusNone runat="server" ID="PermissionList" ShowHeaderFooterOnNone="false">
                <HeaderTemplate>
                    <table class="Grid" cellSpacing=0 cellPadding=0 width="100%">
                    <tbody>
                        <tr>
                            <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Name" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_View" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Download" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Delete" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Edit" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Reply" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_Post" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_LocalAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleryAdmin_PermissionsGrid_RemoteAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                        </tr>    
                </HeaderTemplate>
                <ItemTemplate>
                        <tr class="Row">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Download") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </ItemTemplate>
                <AlternatingItemTemplate>
                        <tr class="AlternatingRow">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Download") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </AlternatingItemTemplate>
                <FooterTemplate>
                    </tbody>
                    </table>
                </FooterTemplate>
                <NoneTemplate>
                    <div class="CommonMessageWarning">
                        <CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_NoPermissionsMessage" />
                    </div>
                </NoneTemplate>
            </CP:RepeaterPlusNone>
            </div>
	    </Content>
    </TWC:TabbedPane>
   
    </TWC:TabbedPanes>
    </asp:Panel>	
	<p class="PanelSaveButton DetailsFixedWidth">
		<cp:ResourceButton id="Save" runat="Server" ResourceName="Save" />
	</p>
</asp:Content>