<%@ Page language="c#" Codebehind="switch.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.MediaGalleries._switch" MasterPageFile="~/ControlPanel/Masters/MediaGalleries.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace="CommunityServer.MediaGalleries.Components" %>

<asp:Content ContentPlaceHolderID="PanelNavigation" runat="server">
    <div class="DashboardMenuAreaFull">
        <CP:NavigationDropDownList CssClass="DashboardMenu" OpenCssClass="DashboardMenuOpen" runat="server" FileName="~/ControlPanel/DashboardMenu.config" MenuGroupCssClass="DashboardContextMenuGroup" MenuItemCssClass="DashboardContextMenuItem" MenuItemSelectedCssClass="DashboardContextMenuItemHover" MenuItemIconWidth="20" MenuItemIconHeight="20" MenuDirection="Down" />
    </div>
</asp:Content>

<asp:Content ContentPlaceHolderId="TopLeft" runat="server"></asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation id="SelectedNavigation1" runat="server" SelectedTab="MediaGalleries" />
	<DIV class="CommonDescription">
		<CP:ResourceControl id="ResourceControl3" runat="server" ResourceName="CP_MediaGalleries_Switch_Description"></CP:ResourceControl></DIV>
	<CP:StatusMessage id="Status" runat="server" Visible="false"></CP:StatusMessage>
	<h3><CP:CSLiteral runat="server" ID="message" /></h3>
    <table border="0" cellpadding="3" cellspacing="0">
        <tr>
            <td width="75px"><CP:ResourceControl resourcename="CP_MediaGalleryAdmin_MediaGalleries_Filter" runat = "Server"/></td>
            <td><cp:AlphaPicker runat = "Server" id = "picker" /></td>
        </tr>
        <tr>
            <td width="75px"><CP:ResourceControl resourcename="CP_MediaGalleryAdmin_MediaGalleries_Search" runat = "Server"/></td>
            <td><input type="text" id = "q" name="q" value ="<%= Server.HtmlEncode(Request.QueryString["q"]) %>"></input> <input type="button" onclick="javascript:window.location = window.location.pathname + '?q=' + escape(q.value)" value ="Go" /></td>
        </tr>
    </table>			

    			
    <div class="CommonListArea" style="clear:both">
    <asp:Repeater runat = "Server" id = "theMediaGallerys">
    <HeaderTemplate>
    <table id="BlogLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
    <thead>
    <tr>
        <th class="CommonListHeaderLeftMost" ><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_AppKey" /></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Name" /></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Owners" /></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Group" /></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleryAdmin_MediaGalleryGrid_Enabled" /></th>    
    </tr>
    </thead>
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td class="CommonListCellLeftMost"><a href="default.aspx?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50) %></a></td>
        <td class="CommonListCell"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></td>
        <td class="CommonListCell"><%# FormatOwners(DataBinder.Eval(Container.DataItem,"Owners")) %>&nbsp;</td>
        <td  class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
	    <td class="CommonListCell" align="center"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.gif" width="16" height="15" /></td>    
    </tr>
    </ItemTemplate>
    <AlternatingItemTemplate>
    <tr class="AltListRow">
        <td class="CommonListCellLeftMost"><a href="default.aspx?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50) %></a></td>
        <td class="CommonListCell"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></td>
        <td class="CommonListCell"><%# FormatOwners(DataBinder.Eval(Container.DataItem,"Owners")) %>&nbsp;</td>
        <td  class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
	    <td class="CommonListCell" align="center"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.gif" width="16" height="15" /></td>    
    </tr>
    </AlternatingItemTemplate>
    <FooterTemplate>
    </table>
    </FooterTemplate>
    </asp:Repeater>
    </div>					
</asp:Content>