<%@ Control Language="c#" AutoEventWireup="false" Codebehind="FileList.ascx.cs" Inherits="CommunityServer.ControlPanel.MediaGalleries.FileList1" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<%@ Import Namespace="CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.MediaGalleries.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

    <script type="text/javascript">
    // <!--
    function ValidateDelete(multiple)
    {
        if (multiple)
            return confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_MediaGalleries_FileList_DeleteSelected") %>');
        else
            return confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_MediaGalleries_FileList_Delete") %>');
    }
    
    function checkAll(isChecked)
    {
	    var pa = document.getElementsByName('FileCheck');
	    for(var i=0; i<pa.length; i++)
	    {
		    pa[i].checked = isChecked;
	    }
    }
    
    function openQuickUpload()
    {
        Telligent_Modal.Open('QuickUpload.aspx', 400, 300, new Function('doReload', 'if (doReload) { window.location = window.location; }'));
    }
    
    // -->
    </script>

	<table cellpadding="0" cellspacing="0" border="0"  width="100%">
		<tr>
		    <td align="left">
		        <asp:PlaceHolder ID="ActionButtons" runat="server">
				    <CP:ResourceButton ID="PublishSelected" runat="server" ResourceName="CP_MediaGalleries_PublishSelected" />
				    <CP:ResourceButton ID="UnpublishSelected" runat="server" ResourceName="CP_MediaGalleries_UnpublishSelected" />
				    <CP:ResourceButton ID="DeleteSelected" runat="server" ResourceName="CP_MediaGalleries_DeleteSelected" OnClientClick="return ValidateDelete(true);" />
				</asp:PlaceHolder>
			</td>
			<td align="right">
				<CP:ResourceControl resourcename="CP_MediaGalleries_FileList_FilterBy" runat="Server" id="FeedbackFilterLabel"/>
				<asp:DropDownList id="CategoryList" Runat="Server" />
				<asp:DropDownList id="PublishedStatusList" Runat="Server" />
				<CP:ResourceButton runat="server" ID="ApplyFilter" ResourceName="CP_MediaGalleries_FileList_ApplyFilter" />
			</td>
		</tr>
	</table>

    <div class="CommonListArea">
		<CSControl:WrappedRepeater runat="Server" ShowHeaderFooterOnNone="false" id = "theposts">
		<HeaderTemplate>
		<table id="CommentListing" cellSpacing="0" cellPadding="0" border="0" width="100%">
		<thead>
			<tr>
			    <th class="CommonListHeaderLeftMost"><input type="checkbox" name="master" id="master" onclick="checkAll(this.checked);" /></th>
				<th class="CommonListHeader PostHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_FileGrid_Title" /></th>
				<th class="CommonListHeader PostHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_FileGrid_Views" /></th>
				<th class="CommonListHeader PostHeader"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_FileGrid_Downloads" /></th>
                <th class="CommonListHeader PostHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_FileGrid_Comments" /></th>
				<th class="CommonListHeader PostHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_FileGrid_Published" /></th>
                <th class="CommonListHeader">&nbsp;</th>
			</tr>
		</thead>
		</HeaderTemplate>
			<ItemTemplate>
			<tr>
			    <td class="CommonListCellLeftMost">
			        <input type="checkbox" name="FileCheck" value="<%# Eval("PostID") %>" />
			    </td>
			    <td class="CommonListCell">
			        <CSMedia:MediaGalleryPostViewer runat="server" ViewType="Preview" Width="32" Height="32" Tag="Div" style="float: left; width: 40px;" />
			        <div style="float: left;">
			            <span><a href="<%# DataBinder.Eval(Container.DataItem, "ViewPostURL")%>">
			                <%# ShorterTitle((string)DataBinder.Eval(Container.DataItem,"Subject"), 90)%></a></span>
	        	        <div style="font-size:.8em; color:#959595">
			            <CP:ResourceControl runat="Server" resourcename="CP_Published_By" /> <%# DataBinder.Eval(Container.DataItem,"DisplayName") %>
			            <CP:ResourceControl runat="server" ResourceName="CP_On"/>
			            <%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PostDate")).ToString("MMM d, yyyy")%>
			            <CP:ResourceControl runat="server" ResourceName="CP_At" />
			            <%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PostDate")).ToString("h:mm tt")%>
			            </div>
			         </div>
			         <div style="clear: both;"></div>
			    </td>
			    <td class="CommonListCell PostViewsCell">
		            <%# Eval("Views")%>
			    </td>
			    <td class="CommonListCell PostViewsCell">
    	            <a href="<%# "userdownloads.aspx?pid=" + Eval("PostID").ToString() %>"><%# Eval("Downloads") %></a>
			    </td>
			    <td class="CommonListCell PostCommentsCell">
			        <a href="<%#  "comments.aspx?pid=" + DataBinder.Eval(Container.DataItem,"PostID") %>"><%# DataBinder.Eval(Container.DataItem,"Replies") %></a>
			    </td>			    			    			    
			    <td class="CommonListCell PostImageStatusCell">
			        <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsApproved").ToString()) ? "published" : "unpublished" %>.png"
			            title="<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsApproved").ToString()) ? "Published" : "Unpublished" %>"/>
			    </td>
			    <td  class="CommonListCell">
			        <input type="button" onclick="window.location='fileeditor.aspx?SectionID=<%# Eval("SectionID") %>&amp;PostID=<%# Eval("PostID") %>'; return false;" value="<%# ResourceManager.GetString("CP_MediaGalleries_FileList_Edit", "ControlPanelResources.xml") %>" />
			        <cp:ResourceButton OnClientClick="return ValidateDelete(false);" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "PostID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_MediaGalleries_FileList_Delete" />
			    </td>
			  </tr>
			</ItemTemplate>
            <AlternatingItemTemplate>
            <tr class="AltListRow">
                <td class="CommonListCellLeftMost">
			        <input type="checkbox" name="FileCheck" value="<%# Eval("PostID") %>" />
			    </td>
			    <td class="CommonListCell">
			        <CSMedia:MediaGalleryPostViewer runat="server" ViewType="Preview" Width="32" Height="32" Tag="Div" style="float: left; width: 40px;" />
			        <div style="float: left;">
			            <span><a href="<%# DataBinder.Eval(Container.DataItem, "ViewPostURL")%>">
			                <%# ShorterTitle((string)DataBinder.Eval(Container.DataItem,"Subject"), 90)%></a></span>
	        	        <div style="font-size:.8em; color:#959595">
			            <CP:ResourceControl runat="Server" resourcename="CP_Published_By" /> <%# DataBinder.Eval(Container.DataItem,"DisplayName") %>
			            <CP:ResourceControl runat="server" ResourceName="CP_On"/>
			            <%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PostDate")).ToString("MMM d, yyyy")%>
			            <CP:ResourceControl runat="server" ResourceName="CP_At" />
			            <%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PostDate")).ToString("h:mm tt")%>
			            </div>
			         </div>
			         <div style="clear: both;"></div>
			    </td>
			    <td class="CommonListCell PostViewsCell">
		            <%# Eval("Views") %>
			    </td>
			    <td class="CommonListCell PostViewsCell">
    	            <a href="<%# "userdownloads.aspx?pid=" + Eval("PostID").ToString() %>"><%# Eval("Downloads") %></a>
			    </td>
			    <td class="CommonListCell PostCommentsCell">
			        <a href="<%#  "comments.aspx?pid=" + DataBinder.Eval(Container.DataItem,"PostID") %>"><%# DataBinder.Eval(Container.DataItem,"Replies") %></a>
			    </td>			    			    			    
			    <td class="CommonListCell PostImageStatusCell">
			        <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsApproved").ToString()) ? "published" : "unpublished" %>.png"
			            title="<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsApproved").ToString()) ? "Published" : "Unpublished" %>"/>
			    </td>
			    <td  class="CommonListCell">
			        <input type="button" onclick="window.location='fileeditor.aspx?SectionID=<%# Eval("SectionID") %>&amp;PostID=<%# Eval("PostID") %>'; return false;" value="<%# ResourceManager.GetString("CP_MediaGalleries_FileList_Edit", "ControlPanelResources.xml") %>" />
			        <cp:ResourceButton OnClientClick="return ValidateDelete(false);" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "PostID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_MediaGalleries_FileList_Delete" />
			    </td>
			  </tr>
			</AlternatingItemTemplate>			
			
			
			<FooterTemplate>
			    </table>
			</FooterTemplate>

            <NoneTemplate>
                <div class="CommonMessageWarning">
                    <table>
                        <tr>
                            <td style="width:35px">
            		            <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" />
                            </td>
                            
                            <td>
                                <CP:ResourceControl ID="ResourceControl2" runat="server" ResourceName="CP_MediaGalleries_FileList_NoFiles" />
                            </td>
                        </tr>
                    </table>
                </div>
            </NoneTemplate>		
        </CSControl:WrappedRepeater>
			
        <CSControl:Pager runat = "Server" id = "thePager" />
        
	</div>	
	
	<div style="margin-top: 5px">
	<table cellpadding="0" cellspacing="0" border="0"  width="100%">
		<tr>
		    <td align="left">
	             <asp:PlaceHolder ID="ActionButtons2" runat="server">
                    <CP:ResourceButton ID="PublishSelected2" runat="server" ResourceName="CP_MediaGalleries_PublishSelected" />
		            <CP:ResourceButton ID="UnpublishSelected2" runat="server" ResourceName="CP_MediaGalleries_UnpublishSelected" />
		            <CP:ResourceButton ID="DeleteSelected2" runat="server" ResourceName="CP_MediaGalleries_DeleteSelected" OnClientClick="return ValidateDelete(true);" />
                </asp:PlaceHolder>
            </td>
            <td align="right">
                <CP:ResourceButton runat="server" ResourceName="CP_MediaGalleries_MultipleUpload" OnClientClick="openQuickUpload(); return false;" />  
            </td>
        </tr>
    </table>
    </div>        

