<%@ Page language="c#" Codebehind="FileEditor.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.MediaGalleries.FileEditor" MasterPageFile="~/ControlPanel/Masters/MediaGalleries.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_FileEditor_Title" /></asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation SelectedNavItem="Files" runat="server" id="SelectedNavigation1" />

    <CSMedia:CreateEditMediaGalleryPostForm runat="server" ID="CreatePost"
        AddUpdateAttachmentModalId="UploadFile" 
        FilenameLabelId="FileName" 
        MediaGalleryPostBodyEditorId="PostBody" 
        MediaGalleryPostSubjectTextBoxId="PostSubject" 
        NoFileErrorMessageControlId="NoFilePanel" 
        PreviewMediaGalleryPostListId="PreviewList" 
        SubFormIds="PostTags" 
        SubmitButtonId="PostButton" 
        FileStorageQuotaExceededErrorMessageControlId="StorageQuotaExceededPanel" 
        FileCountQuotaExceededErrorMessageControlId="CountQuotaExceededPanel" 
        PublishedCheckBoxId="IsApproved">
        <ModeratedSuccessActions>
            <CSControl:GoToSiteUrlAction runat="server" UrlName="mediaGallery_MediaGalleryPosts" />
        </ModeratedSuccessActions>
        <UnmoderatedSuccessActions>
            <CSControl:GoToSiteUrlAction runat="server" UrlName="mediaGallery_MediaGalleryPosts" />
        </UnmoderatedSuccessActions>
        <FormTemplate>

            <div id="NoFilePanel" class="CommonMessageError" runat="server" visible="False">
	            <CSControl:ResourceControl ResourceName="MediaGalleryPostAdmin_NoFileUploaded" ResourceFile="MediaGallery.xml" runat="server" />
            </div>
            
            <div id="StorageQuotaExceededPanel" class="CommonMessageError" runat="server" visible="False">
	            <CSControl:ResourceControl ResourceName="MediaGalleryPostAdmin_StorageQuotaExceeded" ResourceFile="MediaGallery.xml" runat="server" />
            </div>
            
            <div id="CountQuotaExceededPanel" class="CommonMessageError" runat="server" visible="False">
	            <CSControl:ResourceControl ResourceName="MediaGalleryPostAdmin_FileCountQuotaExceeded" ResourceFile="MediaGallery.xml" runat="server" />
            </div>


            <TWC:TabbedPanes id="EditorTabs" runat="server"
	            PanesCssClass="CommonPane"
	            TabSetCssClass="CommonPaneTabSet"
	            TabCssClasses="CommonPaneTab"
	            TabSelectedCssClasses="CommonPaneTabSelected"
	            TabHoverCssClasses="CommonPaneTabHover"
	            >
	            <TWC:TabbedPane runat="server">
		            <Tab><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_FileEditor_Tab_File" /></Tab>
		            <Content>
			            <div class="CommonFormFieldName">
				            <strong><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_FileEditor_FileOrUrlField" ID="Resourcelabel2"/></strong>
			            </div>
			            <div class="CommonFormField">
				            <asp:Label ID="FileName" Runat="server" />
				            <CSControl:Modal resourcename="CP_MediaGalleries_FileEditor_FileOrUrl_Upload" ResourceFile="ControlPanelResources.xml" ModalType="Link" ID="UploadFile" Runat="server" CssClass="CommonTextButton" Width="500" Height="300" />
			            </div>
			            <p />
			            <div class="CommonFormFieldName">
				            <strong><CP:ResourceControl id="tt" runat="Server" ResourceName="CP_MediaGalleries_FileEditor_TitleField" /></strong>
				            <asp:requiredfieldvalidator id="postSubjectValidator" runat="server" ControlToValidate="PostSubject">*</asp:requiredfieldvalidator>
			            </div>
			            <div class="CommonFormField">
				            <asp:TextBox id="PostSubject" CssClass="ControlPanelTextInput" MaxLength="256" runat="server" />
			            </div>
			            <p />
			            <div class="CommonFormFieldName">
				            <strong><CP:ResourceControl id="Formlabel1" runat="Server" ResourceName="CP_MediaGalleries_FileEditor_BodyField" /></strong>
				            <asp:requiredfieldvalidator id="Requiredfieldvalidator1" Display="Dynamic" runat="server"
					            ControlToValidate="PostBody">*</asp:requiredfieldvalidator>
			            </div>
			            <div class="CommonFormField">
				            <CSControl:Editor runat="Server" id="PostBody" width="100%" columns="110" />
			            </div>
			            
			            <CSMedia:MediaGalleryPostTagsSubForm ID="PostTags" runat="server" 
	                        SelectTagsModalButtonId="SelectTags" 
	                        TagsTextBoxId="Tags">
	                        <FormTemplate>
                                <p />
	                            <div class="CommonFormFieldName">
		                            <strong><CP:ResourceControl runat="Server" ResourceName="CP_MediaGalleries_FileEditor_CategoriesField" /></strong><br />
		                            <cp:ResourceControl runat="Server" resourcename="CP_MediaGalleries_FileEditor_CategoriesField_Detail" />
	                            </div>
	                            <div class="CommonFormField">
                                    <table cellpadding="0" cellspacing="0" border="0">
                                    <tr valign="top">
                                    <td>
                                        <asp:TextBox Columns="50" ID="Tags" runat="server" />
                                        &nbsp;&nbsp;<CP:Modal modaltype="Button" width="400" height="300" runat="Server" id="SelectTags" ResourceName="TagEditor_SelectTags" />
                                    </td>
                                    </tr>
                                    </table>
                                </div>
	                        </FormTemplate>
	                    </CSMedia:MediaGalleryPostTagsSubForm>
		            </Content>
	            </TWC:TabbedPane>
	            <TWC:TabbedPane runat="server">
		            <Tab><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_FileEditor_Tab_Options" /></Tab>
		            <Content>
			            <table cellspacing="0" cellpadding="0" border="0">
				            <tr>
					            <td class="CommonFormFieldName">
						            <strong><cp:ResourceControl id="Formlabel6" runat="Server" resourcename="CP_MediaGalleries_FileEditor_Published" /></strong><br />
						            <cp:ResourceControl runat="Server" resourcename="CP_MediaGalleries_FileEditor_Published_Detail" />
					            </td>
					            <td class="CommonFormField">
					                <CSControl:YesNoCheckBox ID="IsApproved" runat="server" />
					            </td>
				            </tr>
			            </table>
		            </Content>
	            </TWC:TabbedPane>
	            <TWC:TabbedPane runat="server">
		            <Tab OnClickClientFunction="Preview"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_FileEditor_Tab_Preview" /></Tab>
		            <Content>
			            <script type="text/javascript">
	                    // <![CDATA[
	                        function Preview()
	                        {
	                            document.getElementById('previewloading').style.display = 'block';
	                            <%# ((CreateEditMediaGalleryPostForm) MediaGalleryControlUtility.Instance().FindControl(this, "CreatePost")).GetPreviewScript("PreviewCallback();") %>
	                        }
		                    
	                        function PreviewCallback()
	                        {
	                            document.getElementById('previewloading').style.display = 'none';
	                        }
	                    // ]]>
	                    </script>
                    
                        <div id="previewloading" style="display:none">Loading <img src = "<%=CommunityServer.Components.SiteUrls.Instance().LoadingImageUrl%>"/></div>
                        <CSMedia:MediaGalleryPostList runat="server" ID="PreviewList">
                            <ItemTemplate>
                                <h3><CSMedia:MediaGalleryPostData runat="server" Property="Subject" /></h3>
                                <CSMedia:MediaGalleryPostViewer runat="server" ViewType="View" Width="400" Height="300" Tag="Div" style="width: 400px; margin: 1em 0;" />
                                <CSMedia:MediaGalleryPostData Property="FormattedBody" runat="server" />
                            </ItemTemplate>
                        </CSMedia:MediaGalleryPostList>
		            </Content>
	            </TWC:TabbedPane>
            </TWC:TabbedPanes>

            <p class="PanelSaveButton DetailsFixedWidth">
	            <cp:ResourceLinkButton id="PostButton" runat="Server" CssClass="CommonTextButtonBig" ResourceName="Save"></cp:ResourceLinkButton>
            </p>
        </FormTemplate>
    </CSMedia:CreateEditMediaGalleryPostForm>

</asp:Content>