<%@ Page language="c#" Codebehind="FileCategories.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.MediaGalleries.FileCategories" MasterPageFile="~/ControlPanel/Masters/MediaGalleries.master" %>
<%@ Import Namespace="CommunityServer.Components" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl runat="server" resourcename="CP_MediaGalleries_FileCategories_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation SelectedNavItem="FileCategories" runat="server" id="SelectedNavigation1" />
	<div class="CommonDescription">
		<CP:ResourceControl runat="server" resourcename="CP_MediaGalleries_FileCategories_Description" />
	</div>
	
    <script language = "javascript" type="text/javascript">
     
      function reloadCategories()
      {
	    window.location = window.location;
      }

      function editCategory(categoryId)
      {
        Telligent_Modal.Open('CategoryForm.aspx?sectionid=<%= CurrentMediaGallery.SectionID.ToString() %>&categoryID=' + categoryId, 400, 300, reloadCategories);
      }
      
      function VerifyDelete()
      {
        return window.confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_MediaGalleries_FileCategoryList_Delete") %>');
      }

    </script>

    <table cellpadding="0" cellspacing="0" border="0"  width="100%">
		<tr>
			<td align="right">
        	    <cp:ModalButton Url="CategoryForm.aspx" ModalType="Link" Height="300" Width="400" runat="Server" Callback="reloadCategories" id="NewCategory" ><CP:ResourceControl ResourceName="CP_MediaGalleries_FileCategoryList_New" Runat="server" /></cp:ModalButton>
            </td>
        </tr>
    </table>
    
    <div class="CommonListArea">
		<CSControl:WrappedRepeater runat="Server" ShowHeaderFooterOnNone="false" id = "theCategories">
		<HeaderTemplate>
		<table id="CommentListing" cellSpacing="0" cellPadding="0" border="0" width="100%">
		<thead>
			<tr>
			    <th class="CommonListHeaderLeftMost"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_FileCategoryGrid_Name" /></th>
				<th class="CommonListHeader PostHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_FileCategoryGrid_Posts" /></th>
				<th class="CommonListHeader PostHeader"><CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_FileCategoryGrid_Published" /></th>
                <th class="CommonListHeader">&nbsp;</th>
			</tr>
		</thead>
		</HeaderTemplate>
			<ItemTemplate>
			<tr>
			    <td class="CommonListCellLeftMost">
			        <a href='<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().TagsBrowser(CurrentMediaGallery.ApplicationKey, new string[] { Eval("CategoryID").ToString() }) %>'><%# Eval("Name") %></a>
			    </td>
			    <td class="CommonListCell PostViewsCell">
		            <a href="<%# "filelist.aspx?cid=" + DataBinder.Eval(Container.DataItem,"CategoryID").ToString() %>"><%# Eval("TotalThreads")%></a>
			    </td>
			    <td class="CommonListCell PostImageStatusCell">
			        <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsEnabled").ToString()) ? "published" : "unpublished" %>.png"
			            title="<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsEnabled").ToString()) ? "Published" : "Unpublished" %>"/>
			    </td>
			    <td  class="CommonListCell">
			        <input type="button" onclick="editCategory(<%# Eval("CategoryID") %>); return false;" value="<%# ResourceManager.GetString("CP_MediaGalleries_FileList_Edit", "ControlPanelResources.xml") %>" />
			        <cp:ResourceButton OnClientClick="return VerifyDelete();" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "CategoryID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_MediaGalleries_FileList_Delete" />
			    </td>
			  </tr>
			</ItemTemplate>
            <AlternatingItemTemplate>
            <tr class="AltListRow">
                <td class="CommonListCellLeftMost">
			        <a href='<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().TagsBrowser(CurrentMediaGallery.ApplicationKey, new string[] { Eval("CategoryID").ToString() }) %>'><%# Eval("Name") %></a>
			    </td>
			    <td class="CommonListCell PostViewsCell">
		            <a href="<%# "filelist.aspx?cid=" + DataBinder.Eval(Container.DataItem,"CategoryID").ToString() %>"><%# Eval("TotalThreads")%></a>
			    </td>
			    <td class="CommonListCell PostImageStatusCell">
			        <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsEnabled").ToString()) ? "published" : "unpublished" %>.png"
			            title="<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsEnabled").ToString()) ? "Published" : "Unpublished" %>"/>
			    </td>
			    <td  class="CommonListCell">
			        <input type="button" onclick="editCategory(<%# Eval("CategoryID") %>); return false;" value="<%# ResourceManager.GetString("CP_MediaGalleries_FileList_Edit", "ControlPanelResources.xml") %>" />
			        <cp:ResourceButton OnClientClick="return VerifyDelete();" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "CategoryID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_MediaGalleries_FileList_Delete" />
			    </td>
			  </tr>
			</AlternatingItemTemplate>			
			
			<FooterTemplate>
			    </table>
			</FooterTemplate>

            <NoneTemplate>
                <div class="CommonMessageWarning">
                    <table>
                        <tr>
                            <td style="width:35px">
            		            <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" />
                            </td>
                            
                            <td>
                                <CP:ResourceControl ID="ResourceControl2" runat="server" ResourceName="CP_MediaGalleries_FileCategoryGrid_NoCategories" />
                            </td>
                        </tr>
                    </table>
                </div>
            </NoneTemplate>		
        </CSControl:WrappedRepeater>
			
        <CSControl:Pager runat = "Server" id = "thePager" />
        
	</div>	
	
</asp:Content>