<%@ Page language="c#" Codebehind="Comments.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.MediaGalleries.Comments" MasterPageFile="~/ControlPanel/Masters/MediaGalleries.master" %>
<%@ Import Namespace="CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.MediaGalleries.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>
<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl runat="server" resourcename="CP_MediaGalleries_Comments_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation SelectedNavItem="Comments" runat="server" id="SelectedNavigation1" />
	<div class="CommonDescription">
		<CP:ResourceControl runat="server" resourcename="CP_MediaGalleries_Comments_Description" />
	</div>
		
	<script type="text/javascript">
    // <!--
    
    function redirectUrl()
    {
        var filterPost = document.getElementById("postId");
        var filterPublished = $('<%=filterPublished.ClientID%>');
        var url = window.location.pathname + '?pid=' + filterPost.value + '&ip=' + filterPublished[filterPublished.selectedIndex].value;
        window.location = url; 
    }
    
    function ValidateDelete(isMultiple)
    {
        if (isMultiple)
            return confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_MediaGalleries_CommentList_DeleteSelectedWarning") %>');
        else
            return confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_MediaGalleries_CommentList_DeleteWarning") %>');
    }
    
    function checkAll(isChecked)
    {
	    var pa = document.getElementsByName('PostCheck');
	    for(var i=0; i<pa.length; i++)
	    {
		    pa[i].checked = isChecked;
	    }
    }
    
    function updatePublishStatus(postid, defaultStatus)
    {
        var basePath = '<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/';   
        var img = $('status-image-' + postid);
        var pubbutton = $('button-Pub-' + postid);
        
        if(pubbutton.isPublished == null)
        {
            pubbutton.isPublished = !defaultStatus;
        }
        else
        {
            pubbutton.isPublished = !pubbutton.isPublished;
        }

        Comments.Toggle(postid,null);

        if(pubbutton.isPublished)
        {
            pubbutton.disabled = true;
        }
        else 
        {
            pubbutton.disabled = false;
        }
        
        if (pubbutton.isPublished) 
        {
            img.src = basePath + 'published.png';
            img.title = "Published";
        }
        else
        {
            img.src = basePath + 'unpublished.png';
            img.title = "Unpublished";
        }
    }
    
    // -->
    </script>
	
	<input type="hidden" id="postId" value="<%= Request.QueryString["pid"] %>" />
	<table cellpadding="0" cellspacing="0" border="0"  width="100%">
	    <tr>
            <td align="left">
                <asp:PlaceHolder ID="ActionButtons" runat="server">
                    <CP:ResourceButton ID="PublishSelected" runat="server" ResourceName="CP_MediaGalleries_PublishSelected" />
    		        <CP:ResourceButton ID="DeleteSelected" runat="server" ResourceName="CP_MediaGalleries_DeleteSelected" OnClientClick="return ValidateDelete(true);" />
                </asp:PlaceHolder>
            </td>
		    <td align="right">
			    <asp:dropdownlist id="filterPublished" runat="server" onchange="redirectUrl();" />
		    </td>
	    </tr>
    </table>
    <div class="CommonListArea">
    <CSControl:WrappedRepeater ShowHeaderFooterOnNone="false" runat = "Server" id="theComments">
    <HeaderTemplate>
        <table id="CommentListing" cellSpacing="0" cellPadding="0" border="0" width="100%">
	        <thead>
		        <tr>
			        <th class="CommonListHeaderLeftMost"><input type="checkbox" name="master" id="master" onclick="checkAll(this.checked);" /></th>
			        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_CommentGrid_Comment"/></th>
			        <th class="CommonListHeader PostHeader"><cp:resourcecontrol runat="server" resourcename="CP_MediaGalleries_CommentGrid_Approved" /></th>											
			        <th class="CommonListHeader">&nbsp;</th>											
		        </tr>
	        </thead>
    </HeaderTemplate>
    <ItemTemplate>
	    <tr>
	    <td class="CommonListCellLeftMost"><input type="checkbox" name="PostCheck" value="<%# Eval("PostID") %>" /></td>
	    <td class="CommonListCell">
		    <a href='<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().ViewMediaGalleryPost(Eval("Section.ApplicationKey").ToString(), int.Parse(Eval("ParentID").ToString())) %>'>
	        <strong><%# DataBinder.Eval(Container.DataItem,"Subject")%></strong></a>
            <br />
	        <%# DataBinder.Eval(Container.DataItem,"ForceExcerpt") %>
	        <div style="font-size:.8em; color:#959595">
	        <CP:ResourceControl runat="server" ResourceName="CP_Blog_Comments_By" />
	        <%# RenderName( (MediaGalleryPost) Container.DataItem ) %>
	        <CP:ResourceControl runat="server" ResourceName="CP_Blog_Comments_On" />
	        <%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PostDate")).ToString("MMM d, yyyy")%>
	        </div>
	    </td>
	    <td class="CommonListCell Status">
		    <img id = "status-image-<%# DataBinder.Eval(Container.DataItem,"PostID") %>"  src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# ((bool) DataBinder.Eval(Container.DataItem,"IsApproved")) ? "published" : "unpublished" %>.png" 
		        title="<%# ((bool) DataBinder.Eval(Container.DataItem,"IsApproved")) ? ResourceManager.GetString("CP_Blog_Comments_Published", "ControlPanelResources.xml") : ResourceManager.GetString("CP_Blog_Comments_NotPublished", "ControlPanelResources.xml")%>" />
	    </td>
	    <td  class="CommonListCell Status" width="180px">
		    <input type="button" onclick="javascript:Telligent_Modal.Open('commenteditor.aspx?cid=<%# DataBinder.Eval(Container.DataItem,"PostID") %>', 625, 475, refreshCallback);" value="Edit" />
		    <input id="button-Pub-<%# DataBinder.Eval(Container.DataItem,"PostID") %>" type="button" onclick="updatePublishStatus(<%# DataBinder.Eval(Container.DataItem,"PostID") %>,<%# DataBinder.Eval(Container.DataItem,"IsApproved").ToString().ToLower() %>)" value="<%# ResourceManager.GetString("CP_Blog_Comments_Publish", "ControlPanelResources.xml") %>" <%# (bool)DataBinder.Eval(Container.DataItem, "IsApproved") ? "disabled" : "enabled" %> />
		    <cp:ResourceButton OnClientClick="return ValidateDelete(false);" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "PostID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_MediaGalleries_FileList_Delete" />
	    </td>
	    </tr>
    </ItemTemplate>
    <AlternatingItemTemplate>
	    <tr class="AltListRow">
	    <td class="CommonListCellLeftMost"><input type="checkbox" name="PostCheck" value="<%# Eval("PostID") %>" /></td>
	    <td class="CommonListCell">
	        <a href='<%# CommunityServer.MediaGalleries.Components.MediaGalleryUrls.Instance().ViewMediaGalleryPost(Eval("Section.ApplicationKey").ToString(), int.Parse(Eval("ParentID").ToString())) %>'>
	        <strong><%# DataBinder.Eval(Container.DataItem,"Subject")%></strong></a>
            <br />
	        <%# DataBinder.Eval(Container.DataItem,"ForceExcerpt") %>
	        <div style="font-size:.8em; color:#959595">
	        <CP:ResourceControl ID="ResourceControl3" runat="server" ResourceName="CP_Blog_Comments_By" />
	        <%# RenderName( (MediaGalleryPost) Container.DataItem ) %>
	        <CP:ResourceControl ID="ResourceControl4" runat="server" ResourceName="CP_Blog_Comments_On" />
	        <%# UserTime.ConvertToUserTime((DateTime)DataBinder.Eval(Container.DataItem, "PostDate")).ToString("MMM d, yyyy")%>
	        </div>
	    </td>
	    <td class="CommonListCell Status">
		    <img id = "status-image-<%# DataBinder.Eval(Container.DataItem,"PostID") %>"  src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# ((bool) DataBinder.Eval(Container.DataItem,"IsApproved")) ? "published" : "unpublished" %>.png" 
		        title="<%# ((bool) DataBinder.Eval(Container.DataItem,"IsApproved")) ? ResourceManager.GetString("CP_Blog_Comments_Published", "ControlPanelResources.xml") : ResourceManager.GetString("CP_Blog_Comments_NotPublished", "ControlPanelResources.xml")%>" />
	    </td>
	    <td  class="CommonListCell Status" width="180px">
		    <input type="button" onclick="javascript:Telligent_Modal.Open('commenteditor.aspx?cid=<%# DataBinder.Eval(Container.DataItem,"PostID") %>', 625, 475, refreshCallback);" value="Edit" />
		    <input id="button-Pub-<%# DataBinder.Eval(Container.DataItem,"PostID") %>" type="button" onclick="updatePublishStatus(<%# DataBinder.Eval(Container.DataItem,"PostID") %>,<%# DataBinder.Eval(Container.DataItem,"IsApproved").ToString().ToLower() %>)" value="<%# ResourceManager.GetString("CP_Blog_Comments_Publish", "ControlPanelResources.xml") %>" <%# (bool)DataBinder.Eval(Container.DataItem, "IsApproved") ? "disabled" : "enabled" %> />
            <cp:ResourceButton OnClientClick="return ValidateDelete(false);" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "PostID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_MediaGalleries_FileList_Delete" />
	    </td>
	    </tr>
    </AlternatingItemTemplate>	
    <NoneTemplate>
        <div class="CommonMessageWarning">
            <table>
                <tr>
                    <td style="width:35px">
		                <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" />
                    </td>
                    
                    <td>
                        <CP:ResourceControl runat="server" ResourceName="CP_MediaGalleries_CommentGrid_NoComments" />
                    </td>
                </tr>
            </table>
        </div>
    </NoneTemplate>	
    <FooterTemplate>
        </table>    
    </FooterTemplate>	
    </CSControl:WrappedRepeater>
    </div>
    
    <asp:PlaceHolder ID="ActionButtons2" runat="server">
        <table cellspacing="0" cellpadding="0" style="padding-top: 5px;" width="100%">
        <tr>
            <td align="left">
                <CP:ResourceButton ID="PublishSelected2" runat="server" ResourceName="CP_MediaGalleries_PublishSelected" />
			    <CP:ResourceButton ID="DeleteSelected2" runat="server" ResourceName="CP_MediaGalleries_DeleteSelected" OnClientClick="return ValidateDelete();" />
            </td>
            <td align="right">
                <CSControl:Pager runat="Server" id="csPager" MessageText="More Comments" />
            </td>
        </tr>
        </table>
    </asp:PlaceHolder>
	
	
</asp:Content>