<%@ Page language="c#" Codebehind="Hubs.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.HubAdmin.HubsPage" MasterPageFile="~/ControlPanel/Masters/HubAdmin.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
    <cp:resourcecontrol id="SectionDescription" runat="server" resourcename="CP_Hub_HubList_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="ManageHubs" />
	<div class="CommonDescription">
	    <CSControl:ConditionalContent runat="server">
            <ContentConditions>
                <CSControl:QueryStringPropertyValueComparison runat="server" QueryStringProperty="SectionID" Operator="GreaterThan" ComparisonValue="-1" />
            </ContentConditions>
            <TrueContentTemplate>
                <CP:ResourceControl runat="server" ResourceName="CP_HubAdmin_NewHub_Message">
                    <Parameter1Template><CSHub:HubData runat="server" Property="Name" LinkTo="HomePage" /></Parameter1Template>
                </CP:ResourceControl>
            </TrueContentTemplate>
            <FalseContentTemplate>
                <cp:resourcecontrol id="Section_Sub_Description" runat="server" resourcename="CP_Hub_HubList_Description" />
            </FalseContentTemplate>
        </CSControl:ConditionalContent>
	</div>
		<h3><CP:CSLiteral runat="server" ID="message" /></h3>

    <table border="0" cellpadding="3" cellspacing="0">
        <tr>
            <td width="75px"><CP:ResourceControl resourcename="CP_Hub_HubList_Filter" runat = "Server" ID="Resourcecontrol1"/></td>
            <td><cp:AlphaPicker runat = "Server" id = "picker" /></td>
        </tr>
        <tr>
            <td width="75px"><CP:ResourceControl resourcename="CP_Hub_HubList_Search" runat = "Server" ID="Resourcecontrol2"/></td>
            <td><input type="text" id = "q" name="q" value ="<%= Server.HtmlEncode(Request.QueryString["q"]) %>"></input> <input type="button" onclick="javascript:window.location = window.location.pathname + '?q=' + escape(q.value)" value ="Go" /></td>
        </tr>
    </table>
    			
    <div class="CommonListArea" style="clear:both">
    <asp:Repeater runat="server" id="theHubs">
        <HeaderTemplate>
            <table id="BlogLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
            <thead>
                <tr>
                    <th class="CommonListHeaderLeftMost" ><cp:resourcecontrol runat="server" resourcename="CP_Hub_GridCol_Name" ID="Resourcecontrol5" NAME="Resourcecontrol3"/></th>
                    <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Hub_GridCol_Title" ID="Resourcecontrol6" NAME="Resourcecontrol4"/></th>
                    <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Hub_GridCol_Owners" ID="Resourcecontrol7" NAME="Resourcecontrol4"/></th>
                    <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Hub_GridCol_Group" ID="Resourcecontrol8" NAME="Resourcecontrol4"/></th>
                    <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Hub_GridCol_Enabled" ID="Resourcecontrol9" NAME="Resourcecontrol4"/></th>    
                    <th class="CommonListHeader">&nbsp;</th>
                </tr>
            </thead>
        </HeaderTemplate>
        <ItemTemplate>
            <tr>
                <td class="CommonListCellLeftMost"><a href="<%# DataBinder.Eval(Container.DataItem,"Url") %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50) %></a></td>
                <td class="CommonListCell"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></td>
                <td class="CommonListCell"><%# FormatOwners(DataBinder.Eval(Container.DataItem,"Owners")) %>&nbsp;</td>
                <td  class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
	            <td class="CommonListCell" align="center"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.gif" width="16" height="15" /></td>    
	            <td class ="CommonListCell" nowrap="nowrap">
	                <input type="button" onclick="window.location = '<%# EditLink(DataBinder.Eval(Container.DataItem,"SectionID")) %>'" value="Edit" />
			        <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this group?');" ResourceName="CP_PermissionList_Delete" />
	            </td>
            </tr>
        </ItemTemplate>
        <AlternatingItemTemplate>
            <tr class="AltListRow">
                <td class="CommonListCellLeftMost"><a href="<%# DataBinder.Eval(Container.DataItem,"Url") %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50) %></a></td>
                <td class="CommonListCell"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></td>
                <td class="CommonListCell"><%# FormatOwners(DataBinder.Eval(Container.DataItem,"Owners")) %>&nbsp;</td>
                <td  class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
	            <td class="CommonListCell" align="center"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.gif" width="16" height="15" /></td>    
	            <td class ="CommonListCell" nowrap="nowrap">
	                <input type="button" onclick="window.location = '<%# EditLink(DataBinder.Eval(Container.DataItem,"SectionID")) %>'" value="Edit" />
			        <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this group?');" ResourceName="CP_PermissionList_Delete" />
	            </td>	
            </tr>
        </AlternatingItemTemplate>
        <FooterTemplate>
            </table>
        </FooterTemplate>
    </asp:Repeater>
    </div>				
			
</asp:Content>