<%@ Page language="c#" Codebehind="Groups.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.HubAdmin.GroupsPage" MasterPageFile="~/ControlPanel/Masters/HubAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl id="SectionDescription" runat="server" ResourceName="CP_Hub_GroupList_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="ManageHubGroups" />
    
    <script type="text/javascript">
    // <![CDATA[

    function GetCurrentGroupId()
    {
        var node = <%= CategoriesTree.ClientID %>.GetSelectedNode();
        if (node == null)
        {
            alert('Please select a category');
            return -1;
        }
        else
            return node.Value;
    }

    function EditGroup()
    {
        var groupId = GetCurrentGroupId();
        if (groupId < 0)
            return;
    
        Telligent_Modal.Open('GroupForm.aspx?GroupID=' + groupId, 540, 300, refresh);
    }

    function DeleteGroup(groupId)
    {
        var groupId = GetCurrentGroupId();
        if (groupId < 0)
            return;
            
        if (window.confirm('Are you sure you want to delete this group category?'))
        {
            GroupsPage.DeleteGroup(groupId, null);
            refresh();
        }
    }
    
    function ManageGroup()
    {
        var groupId = GetCurrentGroupId();
        if (groupId < 0)
            return;
            
        window.location = '../HubAdmin/Hubs.aspx?GroupID=' + groupId;
    }

    function nodeMoved(tree, movedNode, parentNode)
    {
        var groupId = movedNode.Value; 
        GroupsPage.NodeMoved(groupId, null);
    }

    function canHaveChildren(tree, treeNode)
    {
        return (treeNode.GetParentNode() == null);
    }

    // ]]>
    </script>
    
    
	<DIV class="CommonDescription">
		<CP:ResourceControl id="Section_Sub_Description" runat="server" ResourceName="CP_Hub_GroupList_Description" /></DIV>
	
    <div class="CommonFormFieldName">
        <strong><CP:ResourceControl runat="server" ResourceName="CP_HubAdmin_GroupCategories" /></strong>
        <br />
        <CP:ResourceControl runat="server" ResourceName="CP_HubAdmin_GroupCategories_Desc" />    
    </div>
    
    <div class="CommonFormField">
        <TWC:Tree runat="server" ID="CategoriesTree" style="width: 600px; height: 300px;" OnNodeMovedClientFunction="nodeMoved" NodeCanHaveChildrenClientFunction="canHaveChildren" /> 
    </div>
    <div class="CommonFormField">
        <div style="float: right;"><CP:ModalButton Url="GroupForm.aspx?GroupID=-1" callback="refresh" Height="300" Width="540" runat="Server" resourcename="CP_Hub_GroupList_AddNew" id="NewGroup" /></div>
        <input type="button" value="Manage" onclick="ManageGroup(); return false;" />
        <input type="button" value="Edit" onclick="EditGroup(); return false;" />
        <input type="button" value="Delete" onclick="DeleteGroup(); return false;" />
    </div>

</asp:Content>