<%@ Page language="c#" EnableViewState="true" Codebehind="EditHub.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.HubAdmin.EditHub" MasterPageFile="~/ControlPanel/Masters/HubAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	Edit Group
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <script type="text/javascript">
        function canUncheckThreadType(control)
        {
            if (control.checked == true)
                return true;
            var questionAndAnswerInput = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "AllowQuestionCheckBox").ClientID %>');
            var discussionInput = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "AllowDiscussionCheckBox").ClientID %>');
            
            if ((questionAndAnswerInput && questionAndAnswerInput.checked == true) || (discussionInput && discussionInput.checked == true))
                return true;

            return false;
        }
    </script>
    
    <CP:ControlPanelSelectedNavigation SelectedNavItem="ManageHubs" runat="server" />

	<DIV class="CommonDescription">
		<CP:ResourceControl ID="ResourceControl1" runat="server" ResourceName="CP_HubAdmin_SectionEdit_Edit_Description" />
	</DIV>

    <CSHub:EditHubForm runat="server" SubFormIds="ForumConfiguration,BlogConfiguration,MediaConfiguration,WikiConfiguration,EvolutionEditHubSubForm"
        ApplicationKeyTextBoxId="AppKey" 
        HubTypeRadioButtonListId="HubType" 
        GroupDropDownListId="HubGroup" 
        DescriptionEditorId="HubDescription" 
        NameTextBoxId="HubName"
        EnableContactCheckBoxId="HubEnableContact"
        EnablePagesCheckBoxId="HubEnablePages"
        SubmitButtonId="Save">
        <SuccessActions>
            <CSControl:GoToSiteUrlAction UrlName="hub_ControlPanel_AdminHubs" runat="server" />
        </SuccessActions>
        <FormTemplate>
        
            <TWC:TabbedPanes id="EditorTabs" runat="server"
	            PanesCssClass="CommonPane"
	            TabSetCssClass="CommonPaneTabSet"
	            TabCssClasses="CommonPaneTab"
	            TabSelectedCssClasses="CommonPaneTabSelected"
	            TabHoverCssClasses="CommonPaneTabHover"
	            >
	            <TWC:TabbedPane runat="server">
		            <Tab><CSControl:ResourceControl runat="server" ResourceName="Hubs_Options" /></Tab>
		            <Content>
		                <table cellspacing="0" cellpadding="0" border="0">
		                    <tr>
		                        <td class="CommonFormFieldName">
		                            <CSControl:ResourceControl ResourceName="Name" runat="server" Tag="Strong" /><br />
		                            The name of this group.
		                        </td>
		                        <td class="CommonFormField"><asp:TextBox runat="server" ID="HubName" Columns="40" /> <asp:RequiredFieldValidator runat="server" ControlToValidate="HubName" Cssclass="validationWarning">*</asp:RequiredFieldValidator></td>
		                    </tr>
		                    <tr>
		                        <td class="CommonFormFieldName">
		                            <strong>Group Avatar</strong><br />
		                            The image that identifies this group.     
		                        </td>
		                        <td class="CommonFormField">
	                                <CSHub:HubAvatar runat="server" Width="80" Height="80" />
	                                <div>
	                                    <a href="javascript:Telligent_Modal.Open('ChangeGroupAvatar.aspx?SectionID=<%# CommunityServer.Components.CSContext.Current.GetCurrent<CommunityServer.Hubs.Components.Hub>(CommunityServer.Components.ApplicationType.Hub).SectionID %>', 500, 300, refresh);"><%= CommunityServer.Components.ResourceManager.GetString("Hubs_Avatar_Change")%></a>
                                    </div>
		                        </td>
		                    </tr>
		                    <tr>
	                            <td class="CommonFormFieldName">
		                            <strong>URL</strong><br />
		                            Unique value used to identify this group. This value should not be changed. White spaces will be changed to "_". Only numbers, letters, "-", and "_" are valid characters.
	                            </td>
	                            <td class="CommonFormField">
		                            <asp:Literal runat="server" ID="AppKeyUrlPrefix" /><asp:TextBox runat="server" ID="AppKey" Columns="20" /><asp:Literal runat="server" ID="AppKeyUrlSuffix" />
	                            </td>
                            </tr>
		                    
		                    <tr>
		                        <td colspan="2">
		                            <div class="CommonFormFieldName">
		                                <CSControl:ResourceControl ResourceName="Description" runat="server" Tag="Strong" /><br />
		                                The description of this group.    
		                            </div>
		                            <div class="CommonFormField"><CSControl:Editor runat="server" ID="HubDescription" Height="150px" /></div>
		                        </td>
		                    </tr>

                            <tr>
                                <td class="CommonFormFieldName">
                                    <CSControl:ResourceControl ResourceName="Hubs_Type" runat="server" Tag="Strong" /><br />
                                    The membership and visibility setting for this group.
                                </td>
                                <td class="CommonFormField"><asp:RadioButtonList runat="server" ID="HubType" /> <asp:RequiredFieldValidator runat="server" ControlToValidate="HubType" Cssclass="validationWarning">*</asp:RequiredFieldValidator></td>
                            </tr>
                            
                            <CSControl:PlaceHolder runat="server">
                                <DisplayConditions><CSControl:ControlPropertyValueComparison ComparisonControlId="HubGroup" ComparisonProperty="Items" Operator="GreaterThan" ComparisonValue="1" runat="server" /></DisplayConditions>
                                <ContentTemplate>
                                    <tr>
                                        <td class="CommonFormFieldName">
                                            <CSControl:ResourceControl ResourceName="Hubs_Group" runat="server" Tag="Strong" /><br />
                                            The category identifies where this group will be categorized in aggregate group lists.
                                        </td>
                                        <td class="CommonFormField"><asp:DropDownList runat="Server" ID="HubGroup" /></td>
                                    </tr>
                                </ContentTemplate>
                            </CSControl:PlaceHolder>
                            
                            <tr>
                                <td class="CommonFormFieldName">
                                    <CSControl:ResourceControl ResourceName="Hubs_EnableContact" Tag="Strong" runat="server" /><br />
                                    <CSControl:ResourceControl runat="server" ResourceName="Hubs_Contact_Desc" />
                                </td>
                                <td class="CommonFormField">
                                    <asp:CheckBox runat="server" ID="HubEnableContact" />
                                </td>
                            </tr>
                            <tr>
                                <td class="CommonFormFieldName">
                                    <CSControl:ResourceControl ResourceName="Hubs_EnablePages" Tag="Strong" runat="server" /><br />
                                    <CSControl:ResourceControl runat="server" ResourceName="Hubs_EnablePages_Desc" />
                                </td>
                                <td class="CommonFormField">
                                    <asp:CheckBox runat="server" ID="HubEnablePages" />
                                </td>
                            </tr>

							<CSMail:EvolutionCreateEditHubSubForm runat="server"
								id="EvolutionEditHubSubForm"
								EvolutionEmailAddressId="EvolutionEmailAddress"
								EvolutionEmailValidatorId="EvolutionEmailValidator"
								EnableEvolutionListNameId="EnableEvolutionListName">
					            <DisplayConditions>
									<CSControl:PackageInstalledCondition PackageName="Evolution" runat="server" />
					            </DisplayConditions>
								<FormTemplate>
									<tr>
										<td class="CommonFormFieldName">
											<strong>Group Email Address</strong><br />
											Set an email address to be used by this group to communicate with members by email.
										</td>
										<td class="CommonFormField">
											<asp:TextBox runat="server" ID="EvolutionEmailAddress" Columns="20" /> @<CSControl:SiteSettingsData ID="SiteSettingsData2" Property="MailGatewayEmailDomain" runat="server" />
											<asp:RegularExpressionValidator id="EvolutionEmailRegExValidator" runat="server" ControlToValidate="EvolutionEmailAddress" ValidationExpression="\w+([-+.]\w+)*">*</asp:RegularExpressionValidator>
											<asp:customvalidator id="EvolutionEmailValidator" runat="server" controltovalidate="EvolutionEmailAddress" font-bold="True" errormessage="*"></asp:customvalidator>
										</td>
									</tr>
									<tr>
										<td class="CommonFormFieldName">
											<strong>Use Group List Name</strong><br />
											Set whether or not you want to include the group name as a prefix in the subject for messages sent from the group, e.g., "Re: [Sales] Potential Client"
										</td>
										<td class="CommonFormField">
											<CSControl:YesNoCheckBox runat="server" ID="EnableEvolutionListName" />
										</td>
									</tr>
								</FormTemplate>
							</CSMail:EvolutionCreateEditHubSubForm>

                        </table>
                    </Content>
                </TWC:TabbedPane>
                <TWC:TabbedPane runat="server">
		            <Tab ID="ForumPane"><CSControl:ResourceControl runat="server" ResourceName="Hubs_ForumOptions" /></Tab>
		            <Content>
                        <CSForum:HubForumConfigurationSubForm runat="server" ID="ForumConfiguration" ControlIdsToHideWhenNotVisible="ForumPane"
                            EnableForumCheckBoxId="EnableForum"
                            EnableModerationCheckBoxId="EnableModeration"
                            MembersCanCreateThreadsCheckBoxId="MembersCanCreateThreads"
                            DefaultThreadTypeDropDownListId="DefaultThreadTypeDropDown"
                            AllowQuestionCheckBoxId="AllowQuestionCheckBox"
                            AllowDiscussionCheckBoxId="AllowDiscussionCheckBox"
                            SubFormIds="ForumMailingListConfiguration">
                            <FormTemplate>
                                
                                <table cellpadding="0" cellspacing="0" border="0">
                            
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="ForumAdmin_IsActive" runat="server" Tag="Strong" /><br />
		                                    Select 'Yes' to enable the forum within this group.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableForum" /></td>
		                            </tr>

                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="Hubs_EnableForumModeration" runat="server" Tag="Strong" /><br />
		                                    Enable moderation of members forum posts.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableModeration" /></td>
		                            </tr>
                                
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="Hubs_EnableMemberCreateThreads" runat="server" Tag="Strong" /><br />
		                                    Enable members to create new forum threads.  If set to 'No', members can only reply to existing threads.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="MembersCanCreateThreads" /></td>
		                            </tr>
                                    <CSControl:PlaceHolder runat="server">
                                        <DisplayConditions>
                                            <CSControl:ControlVisibilityCondition runat="server" ControlId="DefaultThreadTypeDropDown" ControlVisiblilityEquals="true" />
                                        </DisplayConditions>
                                        <ContentTemplate>
                                        <tr>
			                                <td class="CommonFormFieldName">
				                                <strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_EnableThreadStatusTracking" /></strong><br />
				                                <cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_EnableThreadStatusTracking_Detail" /></td>
			                                <td class="CommonFormField">
                                                <asp:DropDownList runat="server" ID="DefaultThreadTypeDropDown" />
                                            </td>
		                                </tr>
                                        </ContentTemplate>
                                    </CSControl:PlaceHolder>
		                            <tr>
		                                <td class="CommonFormFieldName">
		                                    <strong><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_AllowedThreads" /></strong><br />
		                                    <CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_AllowedThreads_Desc" />
		                                </td>
		                                <td class="CommonFormField">
		                                    <asp:CheckBox runat="server" ID="AllowQuestionCheckBox" onclick="return canUncheckThreadType(this);" /> 
                                            <CSControl:ResourceControl runat="server" resourcename="Forums_QuestionThreadType">
                                                <DisplayConditions><CSControl:ControlVisibilityCondition runat="server" ControlId="AllowQuestionCheckBox" ControlVisiblilityEquals="true" /></DisplayConditions>
                                                <TrailerTemplate><br /></TrailerTemplate>
                                            </CSControl:ResourceControl>
                                            <asp:CheckBox runat="server" ID="AllowDiscussionCheckBox" onclick="return canUncheckThreadType(this);" /> 
                                            <CSControl:ResourceControl runat="server" resourcename="Forums_DiscussionThreadType">
                                                <DisplayConditions><CSControl:ControlVisibilityCondition runat="server" ControlId="AllowDiscussionCheckBox" ControlVisiblilityEquals="true" /></DisplayConditions>
                                                <TrailerTemplate><br /></TrailerTemplate>
                                            </CSControl:ResourceControl>
		                                </td>
		                            </tr>

                                    <CSMail:HubForumMailingListConfigurationSubForm runat="server" ID="ForumMailingListConfiguration"
							            EnableMailGatewayId="EnableForumMailGateway"
							            ForumEmailAddressId="ForumEmailAddress"
							            ForumEmailValidatorId="ForumEmailValidator">
							            <DisplayConditions>
								            <CSControl:SiteSettingsPropertyComparison ComparisonProperty1="EnableMailGateway" Operator="issetortrue" runat="server" />
											<CSControl:PackageInstalledCondition PackageName="Evolution" PackagedInstalledEquals="false" runat="server" />
							            </DisplayConditions>
							            <FormTemplate>
    							        
							                <tr>
		                                        <td class="CommonFormFieldName">
		                                            <CSControl:ResourceControl ResourceName="Hubs_EnableEmailForum" runat="server" Tag="Strong" /><br />
		                                            Enable this groups forum to be accessed as a mailing list.
		                                        </td>
		                                        <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableForumMailGateway" /></td>
		                                    </tr>
    							        
								            <tr>
		                                        <td class="CommonFormFieldName">
		                                            <CSControl:ResourceControl ResourceName="Hubs_ForumMailAddress" runat="server" Tag="Strong" /><br />
		                                            Identify the email address used for this groups forums mailing list.		                                            
		                                        </td>
		                                        <td class="CommonFormField">
													<asp:TextBox runat="server" ID="ForumEmailAddress" Columns="20" /> @<CSControl:SiteSettingsData ID="SiteSettingsData1" Property="MailGatewayEmailDomain" runat="server" />
													<asp:RegularExpressionValidator id="emailRegExValidator" runat="server" ControlToValidate="ForumEmailAddress" ValidationExpression="\w+([-+.]\w+)*">*</asp:RegularExpressionValidator>
													<asp:customvalidator id="ForumEmailValidator" runat="server" controltovalidate="ForumEmailAddress" font-bold="True" errormessage="*"></asp:customvalidator>
												</td>
		                                    </tr>

							            </FormTemplate>
                                    </CSMail:HubForumMailingListConfigurationSubForm>
                                
                                </table>
                            </FormTemplate>
                        </CSForum:HubForumConfigurationSubForm>
                    </Content>
                </TWC:TabbedPane>
                <TWC:TabbedPane runat="server">
		            <Tab ID="BlogPane"><CSControl:ResourceControl runat="server" ResourceName="Hubs_BlogOptions" /></Tab>
		            <Content>
                        <CSBlog:HubWeblogConfigurationSubForm runat="server" ID="BlogConfiguration" ControlIdsToHideWhenNotVisible="BlogPane"
                                    EnableWeblogCheckBoxId="EnableBlog" 
                                    EnableWeblogCommentsCheckBoxId="EnableBlogComments"
                                    EnableWeblogRatingsCheckBoxId="EnableBlogRatings"
                                    EnableWeblogTrackbacksCheckBoxId="EnableBlogTrackbacks"
                                    SubFormIds="BlogMailingListConfiguration">
                            <FormTemplate>
                            
                                <table cellpadding="0" cellspacing="0" border="0">
                                
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="BlogSettings_IsEnabled" runat="server" Tag="Strong" /><br />
		                                    Select 'Yes' to enable the blog within this group.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableBlog" /></td>
		                            </tr>
                            
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="BlogSettings_EnableComments" runat="server" Tag="Strong" /><br />
		                                    Enable comments on posts within this groups blog.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableBlogComments" /></td>
		                            </tr>
                                
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="BlogSettings_EnableRatings" runat="server" Tag="Strong" /><br />
		                                    Enable ratings on posts within this groups blog.    
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableBlogRatings" /></td>
		                            </tr>
                                
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="BlogSettings_EnableTrackbacks" runat="server" Tag="Strong" /><br />
		                                    Enable trackbacks on posts within this groups blog.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableBlogTrackbacks" /></td>
		                            </tr>
                                
                                    <CSMail:HubBlogMailingListConfigurationSubForm runat="server" ID="BlogMailingListConfiguration"
							            EnableMailGatewayId="EnableBlogMailGateway">
							            <DisplayConditions>
								            <CSControl:SiteSettingsPropertyComparison ComparisonProperty1="EnableMailGateway" Operator="issetortrue" runat="server" />
							            </DisplayConditions>
							            <FormTemplate>
							                <tr>
		                                        <td class="CommonFormFieldName">
		                                            <CSControl:ResourceControl ResourceName="Hubs_EnableEmailBlog" runat="server" Tag="Strong" /><br />
		                                            Enable sending email to post to this groups blog.
		                                        </td>
		                                        <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableBlogMailGateway" /></td>
		                                    </tr>
							            </FormTemplate>
                                    </CSMail:HubBlogMailingListConfigurationSubForm>
                                    
                                </table>
                            </FormTemplate>
                        </CSBlog:HubWeblogConfigurationSubForm>
                    </Content>
                </TWC:TabbedPane>
                <TWC:TabbedPane runat="server">
		            <Tab ID="MediaPane"><CSControl:ResourceControl runat="server" ResourceName="Hubs_FileOptions" /></Tab>
		            <Content>
                        <CSMedia:HubMediaGalleryConfigurationSubForm runat="server" ID="MediaConfiguration" ControlIdsToHideWhenNotVisible="MediaPane"
                            EnableMediaGalleryCheckBoxId="EnableMedia" 
                            EnableModerationCheckBoxId="EnableModeration" 
                            MembersCanAddFilesCheckBoxId="MembersCanUpload">
                            <FormTemplate>
                                <table cellpadding="0" cellspacing="0" border="0">
                            
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="Hubs_EnableFiles" runat="server" Tag="Strong" /><br />
		                                    Select 'Yes' to enable the media gallery within this group.    
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableMedia" /></td>
		                            </tr>
                            
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="Hubs_EnableFilesModeration" runat="server" Tag="Strong" /><br />
		                                    Enable moderation of members media uploads.    
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableModeration" /></td>
		                            </tr>
                                
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="Hubs_EnableMemberUploadFiles" runat="server" Tag="Strong" /><br />
		                                    Enable members to upload media.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="MembersCanUpload" /></td>
		                            </tr>
                                
                                </table>
                            </FormTemplate>
                        </CSMedia:HubMediaGalleryConfigurationSubForm>
                    </Content>
                </TWC:TabbedPane>
                <TWC:TabbedPane runat="server">
		            <Tab ID="WikiPane"><CSControl:ResourceControl runat="server" ResourceName="Hubs_WikiOptions" /></Tab>
		            <Content>
                        <CSWiki:HubWikiConfigurationSubForm runat="server" ID="WikiConfiguration" ControlIdsToHideWhenNotVisible="MediaPane"
                            EnableWikiCheckBoxId="EnableWiki" 
                            MembersCanCreatePagesCheckBoxId="MembersCanCreatePages">
                            <FormTemplate>
                                <table cellpadding="0" cellspacing="0" border="0">
                            
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="Hubs_Wiki_IsActive" runat="server" Tag="Strong" /><br />
		                                    Select 'Yes' to enable the wikis within this group.    
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="EnableWiki" /></td>
		                            </tr>
                            
                                    <tr>
		                                <td class="CommonFormFieldName">
		                                    <CSControl:ResourceControl ResourceName="Hubs_MembersCanCreatePages" runat="server" Tag="Strong" /><br />
		                                    Enable members to create pages in wikis.
		                                </td>
		                                <td class="CommonFormField"><CSControl:YesNoCheckBox runat="server" ID="MembersCanCreatePages" /></td>
		                            </tr>
                                
                                </table>
                            </FormTemplate>
                        </CSWiki:HubWikiConfigurationSubForm>
                    </Content>
                </TWC:TabbedPane>
            </TWC:TabbedPanes>
                        
            <p class="PanelSaveButton DetailsFixedWidth">
		        <cp:ResourceLinkButton id="Save" runat="Server" CssClass="CommonTextButton" ResourceName="Save"></cp:ResourceLinkButton>
	        </p>                

        </FormTemplate>
    </CSHub:EditHubForm>

</asp:Content>
