<%@ Page Language="C#" AutoEventWireup="false" CodeBehind="SortOrder.aspx.cs" Inherits="CommunityServer.ControlPanel.Forums.ForumsSortOrder" MasterPageFile="~/ControlPanel/Masters/ForumAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol id="SectionDescription" runat="server" resourcename="CP_Forums_Reorder_Title"></cp:resourcecontrol>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation runat="server" SelectedNavItem="SortOrder" />
    <div class="CommonDescription">
		<cp:resourcecontrol runat="server" resourcename="CP_Forums_Reorder_Description" />
	</div>
    
    <script type="text/javascript">
    // <![CDATA[

    var reportingForumId = <%= reportingForumId %> 
    var deletedForumId = <%= deletedForumId %>;

    function nodeMoved(tree, node, previousParent)
    {
        var ids = node.Value.split(':');
        
        if (ids[0] == "s")
        {
            // its a section/forum
        
            if (ids[1] == reportingForumId || ids[1] == deletedForumId)
            {
                // cannot move reporting/deleted forums
            
                previousParent.AddNode(node);
                <%= theTree.ClientID %>.Refresh();
                
                alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Forums_Tree_ForumInvalidMove") %>');
                return;
            }
            
            if (!node.GetParentNode())
            {
                // cannot move a section to the root
                
                previousParent.AddNode(node);
                <%= theTree.ClientID %>.Refresh();
                
                alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Forums_Tree_ForumMustBeInGroup") %>');
                return;
            }
            
            var level = 0;
            var toSectionId = -1;
            var toGroupId = -1;
            var pNode = node.GetParentNode();
            while (pNode)
            {
                var ids2 = pNode.Value.split(':');
            
                if (ids2[0] == 's' && toSectionId == -1)
                    toSectionId = ids2[1];
                else if (ids2[0] == 'g' && toGroupId == -1)
                    toGroupId = ids2[1];
            
                level++;
                pNode = pNode.GetParentNode();
            }
            
            if (level > 3)
            {
                // only support 3 levels of nested sections
                
                previousParent.AddNode(node);
                <%= theTree.ClientID %>.Refresh();
                
                alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Forums_Tree_ForumOverThreeLevels") %>');
                return;
            }
            
            var index = -1;
            pNode = node.GetParentNode();
             for (var i = 0; i < pNode.GetNodeCount(); i++)
            {
                if (pNode.GetNodeAtIndex(i).Value == node.Value)
                {
                    index = i;
                    break;
                }
            }   
            
            ForumsSortOrder.MoveOrderForum(ids[1], toGroupId, toSectionId, index, moveForumCallback);
        }
        else
        {
            // its a group
        
            if (node.GetParentNode())
            {
                // cannot move a group away from root
                
                <%= theTree.ClientID %>.AddNode(node);        
                <%= theTree.ClientID %>.Refresh();
                
                alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Forums_Tree_GroupInvalidMove") %>');
            }
            
            var index = -1;
            for (var i = 0; i < <%= theTree.ClientID %>.GetNodeCount(); i++)
            {
                if (<%= theTree.ClientID %>.GetNodeAtIndex(i).Value == node.Value)
                {
                    index = i;
                    break;
                }
            }            
            
            ForumsSortOrder.OrderGroups(ids[1], index, moveGroupCallback);
        }
    }

    function moveForumCallback(res)
    {
	    if (res == null)
		    return;

	    if (res.value != "success")
		    alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Forums_Tree_ForumSaveError") %>');
    }

    function moveGroupCallback(res)
    {
	    if (res == null)
		    return;

	    if (res.value != "success")
		    alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_Forums_Tree_GroupSaveError") %>');
    }

    // ]]>
    </script>

    <TWC:Tree runat="server" Width="600px" Height="400px" ID="theTree" OnNodeMovedClientFunction="nodeMoved" />
    
</asp:Content>