<%@ Control language="c#" Codebehind="SectionEditControl.ascx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Forums.SectionEditControl" %>
<%@ Import Namespace="CommunityServer.Discussions.Components" %>
<cp:resourcecontrol id="AddSectionHelpResource" Tag="Div" CssClass="CommonDescription" runat="server" visible="false" resourcename="CP_Forums_Home_AddNewForumHelp"></cp:resourcecontrol>
<cp:statusmessage id="Status" runat="server"></cp:statusmessage>

<script type="text/javascript">
    function IsNewGroup(groupId)
    {
        var groupRow = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "newGroupRow").ClientID %>');
        if (groupRow && groupId != 0)
        {
            groupRow.style.visibility = "hidden";
            groupRow.style.position = "absolute";
            return;
        }  
        
        if (groupRow)
        {
            groupRow.style.visibility = "visible";
            groupRow.style.position = "relative";
        }
    }
    
    function IsNewGroupNameValid(sender, args)
    {
        var adminGroupList = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "AdminGroupList").ClientID %>');
        
        if (!adminGroupList || adminGroupList.value != 0)
        {
            args.IsValid = true;
            return;
        }
        
        var groupNameField = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "NewGroupName").ClientID %>');
        
        if (!groupNameField || groupNameField.value.length < 1)
        {
            args.IsValid = false;
            return;
        }
        
        args.IsValid = true;    
        return;
    }
    
    function toggleEnableEmbeddingFields()
    {
        var enableEmbedding = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "EmbedEnable").ClientID %>');
        var embedCode = document.getElementById('EmbedCodeRow');

        if (enableEmbedding && embedCode)
        {
            if (!getRadioSelectedValue(enableEmbedding))
                embedCode.style.display = 'none';
            else
            {
                try { embedCode.style.display = 'table-row'; }
                catch (e) { embedCode.style.display = 'block'; }
            }
        }
    }
    
    function toggleEmbedDomainFields()
    {
        var enableAllDomains = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "EmbedAllDomains").ClientID %>');
        var allowedDomains = document.getElementById('AllowedDomainsRow');

        if (enableAllDomains && allowedDomains)
        {
            if (getRadioSelectedValue(enableAllDomains))
                allowedDomains.style.display = 'none';
            else
            {
                try { allowedDomains.style.display = 'table-row'; }
                catch (e) { allowedDomains.style.display = 'block'; }
            }
        }
    }
    
    function getRadioSelectedValue(control)
    {
        if (control.getElementsByTagName)
        {
            var children = control.getElementsByTagName('INPUT');
            for (var i = 0; i < children.length; i++)
            {
                if (children[i].type == 'radio' && children[i].checked)
                    return children[i].value == 'True';
            }
        }
    }
    
    function canUncheckThreadType(control)
    {
        if (control.checked == true)
            return true;
        var questionAndAnswerInput = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "AllowQuestionCheckBox").ClientID %>');
        var discussionInput = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "AllowDiscussionCheckBox").ClientID %>');
        
        if ((questionAndAnswerInput && questionAndAnswerInput.checked == true) || (discussionInput && discussionInput.checked == true))
            return true;

        return false;
    }
</script>

<TWC:TabbedPanes id="TabStrip" runat="server"
	PanesCssClass="CommonPane"
	TabSetCssClass="CommonPaneTabSet"
	TabCssClasses="CommonPaneTab"
	TabSelectedCssClasses="CommonPaneTabSelected"
	TabHoverCssClasses="CommonPaneTabHover"
	>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_Basic" /></Tab>
		<Content>
		<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_Name" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Name_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="Name" runat="server" CssClass="ControlPanelTextInputBig" columns="40" maxlength="256"></asp:textbox>
				<asp:requiredfieldvalidator id="NameRequired" runat="server" controltovalidate="Name" font-bold="True" errormessage="*"></asp:requiredfieldvalidator>
				<asp:RegularExpressionValidator ValidationExpression="^.*[^\s]+.*$" 
                     ControlToValidate="Name" Display="Dynamic"
                     ErrorMessage="<br/>Forum Name does not contain an alphanumeric character." runat="server" />
            </td>
		</tr>
		<tr>
			<td class="CommonFormFieldName" valign="top">
				<cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_ForumDescription" /><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_ForumDescription_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="Description" runat="server" columns="40" maxlength="1000" textmode="MultiLine"
					rows="3"></asp:textbox>
				<asp:customvalidator id="DescriptionRequired" runat="server" controltovalidate="Description" font-bold="True"
					errormessage="*"></asp:customvalidator></td>
		</tr>
		<tr runat="server" id="groupSelectRow">
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_Group" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Group_Detail" /></td>
			<td class="CommonFormField">
				<asp:literal id="GroupValue" runat="server"></asp:literal>
				<asp:dropdownlist id="AdminGroupList" runat="server" autopostback="True" onchange="IsNewGroup(this.value)" />
			</td>
		</tr>
		<tr runat="server" id="newGroupRow" style="visibility: hidden; position:absolute;">
	        <td class="CommonFormFieldName" vAlign="top">
			    <strong><CP:FORMLABEL runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_NewGroup" controltolabel="AdminGroupList" /></strong>
			    <br />
			    <CP:ResourceControl runat="Server" resourcename="CP_Forums_SectionEdit_Settings_NewGroup_Detail" />
		    </td>
		    <td class="CommonFormField">
			    <asp:TextBox runat="server" ID="NewGroupName" Text="" />
			    <asp:CustomValidator runat="server" ClientValidationFunction="IsNewGroupNameValid" ErrorMessage="*" />
		    </td>
	    </tr>
		<tr>
		    <td class="CommonFormFieldName">
		        <strong><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_AllowedThreads" /></strong><br />
		        <CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_AllowedThreads_Desc" />
		    </td>
		    <td class="CommonFormField">
		        <asp:CheckBox runat="server" ID="AllowQuestionCheckBox" onclick="return canUncheckThreadType(this);" /> 
                <CSControl:ResourceControl runat="server" resourcename="Forums_QuestionThreadType">
                    <DisplayConditions><CSControl:ControlVisibilityCondition runat="server" ControlId="AllowQuestionCheckBox" ControlVisiblilityEquals="true" /></DisplayConditions>
                    <TrailerTemplate><br /></TrailerTemplate>
                </CSControl:ResourceControl>
                <asp:CheckBox runat="server" ID="AllowDiscussionCheckBox" onclick="return canUncheckThreadType(this);" /> 
                <CSControl:ResourceControl runat="server" resourcename="Forums_DiscussionThreadType">
                    <DisplayConditions><CSControl:ControlVisibilityCondition runat="server" ControlId="AllowDiscussionCheckBox" ControlVisiblilityEquals="true" /></DisplayConditions>
                    <TrailerTemplate><br /></TrailerTemplate>
                </CSControl:ResourceControl>
		    </td>
		</tr>
		<tr id="EnableThreadStatusTrackingRow" runat="server">
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_EnableThreadStatusTracking" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_EnableThreadStatusTracking_Detail" /></td>
			<td class="CommonFormField">
                <asp:DropDownList runat="server" ID="DefaultThreadTypeDropDown" />
            </td>
		</tr>
		<tr>
			<td class="CommonFormFieldName" nowrap="nowrap">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_IsActive" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_IsActive_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="IsActive" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		<tr id="EnableAnonymousPostingForUsersRow" runat="server">
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_EnableAnonymousPostingForUsers" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_EnableAnonymousPostingForUsers_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="EnableAnonymousPostingForUsers" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		<tr runat="server" id="SectionLocalizationArea">
			<td class="CommonFormFieldName">
				<strong><cp:resourceControl runat="Server" resourcename="CP_Forums_SectionEdit_DefaultLanguage" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_DefaultLanguage_Detail" />
			</td>
			<td class="CommonFormField">
				<cp:FilterLanguageDropDownList runat="server" id="DefaultLanguage" />
			</td>
		</tr>
		</table>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" ID="AdvancedTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_Advanced" /></Tab>
		<Content>
		<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_Url" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Url_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="Url" runat="server" columns="40" maxlength="512"></asp:textbox>
		</tr>
		<tr id="ParentForumRow" runat="server" visible="false">
			<td class="CommonFormFieldName">
				<cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_Parent" /><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Parent_Detail" />
			</td>
			<td class="CommonFormField">
				<cp:hyperlink id="ParentForumName" runat="server" />
				<asp:dropdownlist id="ForumList" runat="server" visible="False"/>
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_IsSearchable" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_IsSearchable_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="IsSearchable" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		<tr>
			<td class="CommonFormFieldName" nowrap="nowrap">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_IsModerated" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_IsModerated_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="IsModerated" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		<tr>
			<td class="CommonFormFieldName" nowrap="nowrap">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_EnableModeratedNotifications" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_EnableModeratedNotifications_Detail" />
            </td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="EnableModeratedNotifications" runat="server"  repeatcolumns="2" />
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName" nowrap="nowrap">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_EnablePostStatistics" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_EnablePostStatistics_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="EnablePostStatistics" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		<tr>
			<td class="CommonFormFieldName" nowrap="nowrap">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_EnablePostPoints" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_EnablePostPoints_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="EnablePostPoints" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		<tr id="EnableAnonymousPostingRow" runat="server">
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_EnableAnonymousPosting" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_EnableAnonymousPosting_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="EnableAnonymousPosting" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		</table>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" ID="UserPermissionsTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_UserPermissions" /></Tab>
		<Content>
		    <div>
		        <asp:DropDownList runat="server" ID="UnchangedPermissionsList" DataTextField="Name" DataValueField="Name" />
		        <asp:Button runat="server" ID="AddUserPermissionButton" Text="Add Role" CausesValidation="false" />
		    </div>
		    <br />
		        <CP:RepeaterPlusNone runat="server" ID="PermissionList" ShowHeaderFooterOnNone="false">
                    <HeaderTemplate>
                        <table cellSpacing=0 cellPadding=0 width="100%">
                        <tbody>
                            <tr>
                                <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Forums_GridCol_Name" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_View" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Read" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Post" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Reply" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Vote" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Video" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_LocalAttachment" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_RemoteAttachment" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                            </tr>    
                    </HeaderTemplate>
                    <ItemTemplate>
                            <tr class="Row">
                                <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Read") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VoteCheckbox" Checked='<%# Eval("Vote") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                                <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                            </tr>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                            <tr class="AlternatingRow">
                                <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Read") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VoteCheckbox" Checked='<%# Eval("Vote") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                                <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                            </tr>
                    </AlternatingItemTemplate>
                    <FooterTemplate>
                        </tbody>
                        </table>
                    </FooterTemplate>
                    <NoneTemplate>
                        <div class="CommonMessageWarning">
                            <CP:ResourceControl runat="server" ResourceName="CP_Forum_NoPermissionsMessage" />
                        </div>
                    </NoneTemplate>
                </CP:RepeaterPlusNone>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" ID="AdminPermissionsTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_AdminPermissions" /></Tab>
		<Content>
		     <div>
		        <asp:DropDownList runat="server" ID="UnchangedAdminPermissionsList" DataTextField="Name" DataValueField="Name" />
		        <asp:Button runat="server" ID="AddAdminPermissionButton" Text="Add Role" CausesValidation="false" />
		    </div>
		    <br />
                <CP:RepeaterPlusNone runat="server" ID="AdminPermissionList" ShowHeaderFooterOnNone="false">
                    <HeaderTemplate>
                        <table cellSpacing=0 cellPadding=0 width="100%">
                        <tbody>
                            <tr>
                                <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Forums_GridCol_Name" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Edit" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Delete" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_CreatePoll" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_MarkAsAnswer" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Sticky" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Announcement" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_EditOthers" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Moderate" /></th>
                                <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                            </tr>    
                    </HeaderTemplate>
                    <ItemTemplate>
                            <tr class="Row">
                                <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="CreatePollCheckbox" Checked='<%# Eval("CreatePoll") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="MarkAsAnswerCheckbox" Checked='<%# Eval("MarkAsAnswer") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="StickyCheckbox" Checked='<%# Eval("Sticky") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="AnnouncementCheckbox" Checked='<%# Eval("Announcement") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditOthersCheckbox" Checked='<%# Eval("EditOthers") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ModerateCheckbox" Checked='<%# Eval("Moderate") %>' /></td>
                                <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                            </tr>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                            <tr class="AlternatingRow">
                                <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="CreatePollCheckbox" Checked='<%# Eval("CreatePoll") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="MarkAsAnswerCheckbox" Checked='<%# Eval("MarkAsAnswer") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="StickyCheckbox" Checked='<%# Eval("Sticky") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="AnnouncementCheckbox" Checked='<%# Eval("Announcement") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditOthersCheckbox" Checked='<%# Eval("EditOthers") %>' /></td>
                                <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ModerateCheckbox" Checked='<%# Eval("Moderate") %>' /></td>
                                <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                            </tr>
                    </AlternatingItemTemplate>
                    <FooterTemplate>
                        </tbody>
                        </table>
                    </FooterTemplate>
                    <NoneTemplate>
                        <div class="CommonMessageWarning">
                            <CP:ResourceControl runat="server" ResourceName="CP_Forum_NoPermissionsMessage" />
                        </div>
                    </NoneTemplate>
                </CP:RepeaterPlusNone>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" id="EmbedTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Embed_Tab" /></Tab>
		<Content>
		<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<td class="CommonFormFieldName">
				<strong><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Embed_EnableEmbedding" /></strong><br />
				<cp:resourcecontrol  runat="Server" resourcename="CP_Forums_SectionEdit_Embed_EnableEmbedding_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="EmbedEnable" runat="server" repeatcolumns="2" onclick="toggleEnableEmbeddingFields();"></cp:yesnoradiobuttonlist>
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName">
				<strong><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Embed_EnableAllDomains" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Embed_EnableAllDomains_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="EmbedAllDomains" runat="server" repeatcolumns="2" onclick="toggleEmbedDomainFields();"></cp:yesnoradiobuttonlist></td>
			</td>
		</tr>
		<tr id="AllowedDomainsRow">
			<td class="CommonFormFieldName">
				<strong><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Embed_AllowedDomains" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Embed_AllowedDomains_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="EmbedDomains" runat="server" TextMode="MultiLine" Rows="5" Columns="40" Width="300px"></asp:textbox>
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName">
				<strong><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Embed_CreateNewThreadsAs" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Embed_CreateNewThreadsAs_Detail" /></td>
			<td class="CommonFormField">
				<CSControl:UserLookUpTextBox ID="EmbedThreadUser" runat="server" LookUpType="AllUsers" MaximumLookUpCount="20" MaximumUsers="1" Width="300px" />
			</td>
		</tr>
		<tr id="EmbedCodeRow">
			<td class="CommonFormFieldName">
				<strong><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Embed_Code" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_Embed_Code_Detail" /></td>
			<td class="CommonFormField">
				<asp:TextBox ID="EmbedCode" runat="server" Width="300px" onclick="this.select();" oncontextmenu="this.select();" />
			</td>
		</tr>
		</table>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" id="MailingListTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_MailingList" /></Tab>
		<Content>
		<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_LE_EnableMailingList" /></strong><br />
				<cp:resourcecontrol  runat="Server" resourcename="CP_Forums_SectionEdit_LE_EnableMailingList_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="LEEnableMailingList" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist>
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_LE_ListName" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_LE_ListName_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="LEListName" runat="server" columns="50" maxlength="256"></asp:textbox>
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_LE_EmailAddress" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_LE_EmailAddress_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="LEEmailAddress" runat="server" columns="20" maxlength="256"></asp:textbox>
				<asp:Literal ID="LEEmailDomain" Runat="server" />
				<asp:RegularExpressionValidator id="emailRegExValidator" runat="server" ControlToValidate="LEEmailAddress" ValidationExpression="\w+([-+.]\w+)*">*</asp:RegularExpressionValidator>
				<asp:customvalidator id="LEEmailValidator" runat="server" controltovalidate="LEEmailAddress" font-bold="True"
					errormessage="*"></asp:customvalidator>
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName" valign="top">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_LE_FooterMessage" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_LE_FooterMessage_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="LEFooterMessage" runat="server" columns="50" maxlength="1000" textmode="MultiLine" rows="3"></asp:textbox>
			</td>
		</tr>
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_LE_PassiveMode" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_LE_PassiveMode_Detail" /></td>
			<td class="CommonFormField">
				<cp:yesnoradiobuttonlist id="LEPassiveMode" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist></td>
		</tr>
		<tr>
			<td class="CommonFormFieldName">
				<strong><cp:resourcelabel runat="server" resourcename="CP_Forums_SectionEdit_LE_PassiveModeEmail" /></strong><br />
				<cp:resourcecontrol runat="Server" resourcename="CP_Forums_SectionEdit_LE_PassiveModeEmail_Detail" /></td>
			<td class="CommonFormField">
				<asp:textbox id="LEPassiveModeAddress" runat="server" columns="50" maxlength="256"></asp:textbox>
				<asp:RegularExpressionValidator id="Regularexpressionvalidator1" runat="server" ControlToValidate="LEPassiveModeAddress" ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*">*</asp:RegularExpressionValidator>
			</td>
		</tr>
		</table>
		</Content>
	</TWC:TabbedPane>
</TWC:TabbedPanes>

<script type="text/javascript">

toggleEmbedDomainFields();
toggleEnableEmbeddingFields();

</script>