<%@ Control language="c#" Codebehind="GroupEditControl.ascx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Forums.GroupEditControl" %>
<%@ Import Namespace="CommunityServer.Discussions.Components" %>
<div class="CommonFormArea">
<cp:statusmessage id="Status" runat="server"></cp:statusmessage>

<TWC:TabbedPanes id="TabStrip" runat="server"
	PanesCssClass="CommonPane"
	TabSetCssClass="CommonPaneTabSet"
	TabCssClasses="CommonPaneTab"
	TabSelectedCssClasses="CommonPaneTabSelected"
	TabHoverCssClasses="CommonPaneTabHover"
	>
	<TWC:TabbedPane runat="server">
    <Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_Basic" /></Tab>
    <Content>
        <div class="CommonFormFieldName">
	        <cp:resourcelabel runat="server" resourcename="CP_Forums_GroupEdit_ForumGroupName" id="Resourcelabel3"/>
        </div>
        <div class="CommonFormField">
	        <asp:textbox id="ForumGroupName" runat="server"  CssClass="ControlPanelTextInput" MaxLength="256"></asp:textbox>
	        <asp:requiredfieldvalidator runat="server" errormessage="*" controltovalidate="ForumGroupName" id="ForumGroupNameValidator" />
        </div>
        <p />
        <div class="CommonFormFieldName">
		        <cp:resourcelabel runat="server" resourcename="CP_Forums_GroupEdit_ForumGroupDesc" id="Resourcelabel4"/>
        </div>
        <div class="CommonFormField">
		        <asp:textbox id="ForumGroupDesc" runat="server" CssClass="ControlPanelTextInput" MaxLength="256"  Rows="8" TextMode="MultiLine"></asp:textbox>
        </div>
    </Content>
    </TWC:TabbedPane>
    
    <TWC:TabbedPane runat="server" ID="PermissionsTab">
    <Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_UserPermissions" /></Tab>
    <Content>
        <div>
	        <asp:DropDownList runat="server" ID="UnchangedUserPermissionsList" DataTextField="Name" DataValueField="Name" />
	        <asp:Button runat="server" ID="AddUserPermissionButton" Text="Add Role" CausesValidation="false" />
	    </div>
	    <br />
        <CP:RepeaterPlusNone runat="server" ID="UserPermissionList" ShowHeaderFooterOnNone="false">
            <HeaderTemplate>
                <table class="Grid" cellSpacing=0 cellPadding=0 width="100%">
                <tbody>
                    <tr>
                        <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Forums_GridCol_Name" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_View" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Read" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Post" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Reply" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Vote" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Video" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_LocalAttachment" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_RemoteAttachment" /></th>
                        <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                    </tr>    
            </HeaderTemplate>
            <ItemTemplate>
                    <tr class="Row">
                        <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Read") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VoteCheckbox" Checked='<%# Eval("Vote") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                        <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                    </tr>
            </ItemTemplate>
            <AlternatingItemTemplate>
                    <tr class="AlternatingRow">
                        <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReadCheckbox" Checked='<%# Eval("Read") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VoteCheckbox" Checked='<%# Eval("Vote") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                        <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                        <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                    </tr>
            </AlternatingItemTemplate>
            <FooterTemplate>
                </tbody>
                </table>
            </FooterTemplate>
            <NoneTemplate>
                <div class="CommonMessageWarning">
                    <CP:ResourceControl runat="server" ResourceName="CP_Forum_NoPermissionsMessage" />
                </div>
            </NoneTemplate>
        </CP:RepeaterPlusNone>
    </Content>
    </TWC:TabbedPane>
    
    <TWC:TabbedPane runat="server" ID="AdminPermissionsTab">
	<Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_AdminPermissions" /></Tab>
	<Content>
	     <div>
	        <asp:DropDownList runat="server" ID="UnchangedAdminPermissionsList" DataTextField="Name" DataValueField="Name" />
	        <asp:Button runat="server" ID="AddAdminPermissionButton" Text="Add Role" CausesValidation="false" />
	    </div>
	    <br />
	    <div id="GrayGrid">
            <CP:RepeaterPlusNone runat="server" ID="AdminPermissionList" ShowHeaderFooterOnNone="false">
                <HeaderTemplate>
                    <table class="Grid" cellSpacing=0 cellPadding=0 width="100%">
                    <tbody>
                        <tr>
                            <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Forums_GridCol_Name" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Edit" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Delete" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_CreatePoll" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_MarkAsAnswer" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Sticky" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Announcement" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_EditOthers" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Moderate" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                        </tr>    
                </HeaderTemplate>
                <ItemTemplate>
                        <tr class="Row">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="CreatePollCheckbox" Checked='<%# Eval("CreatePoll") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="MarkAsAnswerCheckbox" Checked='<%# Eval("MarkAsAnswer") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="StickyCheckbox" Checked='<%# Eval("Sticky") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="AnnouncementCheckbox" Checked='<%# Eval("Announcement") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditOthersCheckbox" Checked='<%# Eval("EditOthers") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ModerateCheckbox" Checked='<%# Eval("Moderate") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </ItemTemplate>
                <AlternatingItemTemplate>
                        <tr class="AlternatingRow">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditCheckbox" Checked='<%# Eval("Edit") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="DeleteCheckbox" Checked='<%# Eval("Delete") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="CreatePollCheckbox" Checked='<%# Eval("CreatePoll") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="MarkAsAnswerCheckbox" Checked='<%# Eval("MarkAsAnswer") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="StickyCheckbox" Checked='<%# Eval("Sticky") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="AnnouncementCheckbox" Checked='<%# Eval("Announcement") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="EditOthersCheckbox" Checked='<%# Eval("EditOthers") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ModerateCheckbox" Checked='<%# Eval("Moderate") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </AlternatingItemTemplate>
                <FooterTemplate>
                    </tbody>
                    </table>
                </FooterTemplate>
                <NoneTemplate>
                    <div class="CommonMessageWarning">
                        <CP:ResourceControl runat="server" ResourceName="CP_Forum_NoPermissionsMessage" />
                    </div>
                </NoneTemplate>
            </CP:RepeaterPlusNone>
        </div>
	</Content>
	</TWC:TabbedPane>
</TWC:TabbedPanes>
    
</div>