<%@ Page language="c#" Codebehind="Forums.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Forums.Forums" MasterPageFile="~/ControlPanel/Masters/ForumAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol id="SectionDescription" runat="server" resourcename="CP_Forums_ForumList_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation runat="server" SelectedNavItem="ForumList" />
	<div class="CommonDescription">
	    <CSControl:ConditionalContent runat="server">
            <ContentConditions>
                <CSControl:QueryStringPropertyValueComparison runat="server" QueryStringProperty="SectionID" Operator="GreaterThan" ComparisonValue="-1" />
            </ContentConditions>
            <TrueContentTemplate>
                <CP:ResourceControl runat="server" ResourceName="CP_Forums_ForumList_CreatedMessage">
                    <Parameter1Template><CSForum:ForumData runat="server" Property="Name" LinkTo="HomePage" /></Parameter1Template>
                </CP:ResourceControl>
            </TrueContentTemplate>
            <FalseContentTemplate>
                <cp:resourcecontrol id="Section_Sub_Description" runat="server" resourcename="CP_Forums_ForumList_SubTitle" />
            </FalseContentTemplate>
        </CSControl:ConditionalContent>
	</div>
	
	<div id="Filters">
        <cp:resourcecontrol id="FeedbackFilterLabel" runat="Server" resourcename="CP_Forums_ForumGroupList_Title"></cp:resourcecontrol>&nbsp;<asp:dropdownlist id="AdminGroupList" runat="server" autopostback="True"></asp:dropdownlist>
    </div>
	<asp:Repeater Runat="server" id="ForumList">
        <HeaderTemplate>
        <div class="CommonListArea">
	        <table id="Listing" cellSpacing="0" cellPadding="0" border="0" width="100%">
		        <thead>
			        <tr>
				        <th class="CommonListHeaderLeftMost">
					        <cp:resourcecontrol runat="server" resourcename="CP_Forums_SectionEdit_Name" />
				        </th>
				        <th class="CommonListHeader">
					        <cp:resourcecontrol runat="server" resourcename="CP_Description" />
				        </th>
				        <th class="CommonListHeader">
					        <cp:resourcecontrol runat="server" resourcename="CP_Forums_SectionEdit_Group" />
				        </th>
				        <th class="CommonListHeader">
					        <cp:resourcecontrol runat="server" resourcename="CP_Forums_SectionEdit_ForumEnabled" />
				        </th>
				        <th class="CommonListHeader">
				            &nbsp;	
			            </th>
			        </tr>
		        </thead>
        </HeaderTemplate>
        <ItemTemplate>
                <tr>
                    <td class="CommonListCellLeftMost">
                        <a href='<%# CommunityServer.Discussions.Components.ForumUrls.Instance().Forum(int.Parse(Eval("SectionID").ToString())) %>'><%# Eval("Name") %></a>
                    </td>
                    <td class="CommonListCell">
                        <%# Eval("Description") %>&nbsp;
                    </td>
                    <td class="CommonListCell">
                        <%# Eval("GroupName")%>&nbsp;
                    </td>
                    <td class="CommonListCell" style="text-align: center;">
                        <img src="<%= CommunityServer.Components.SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(Eval("IsActive").ToString()) ? "published" : "unpublished" %>.png"
	                        title="<%# Boolean.Parse(Eval("IsActive").ToString()) ? CommunityServer.Components.ResourceManager.GetString("CP_Blog_Comments_Published", "ControlPanelResources.xml") : CommunityServer.Components.ResourceManager.GetString("CP_Blog_Comments_NotPublished", "ControlPanelResources.xml")%>" />
                    </td>
                    <td class="CommonListCell" nowrap="nowrap">
                       <input type="button" value="Edit" onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forums_ControlPanel_EditForum", Eval("SectionID").ToString()) %>'" />
                       &nbsp;
                       <input type="button" value="Read" onclick="window.location = '<%# Eval("Url") %>'"  />
                       &nbsp;
                       <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this forum?');" ResourceName="CP_PermissionList_Delete" />
                    </td>
                </tr>
        </ItemTemplate>
        <AlternatingItemTemplate>
                <tr class="AltListRow">
                    <td class="CommonListCellLeftMost">
                        <a href='<%# CommunityServer.Discussions.Components.ForumUrls.Instance().Forum(int.Parse(Eval("SectionID").ToString())) %>'><%# Eval("Name") %></a>
                    </td>
                    <td class="CommonListCell">
                        <%# Eval("Description") %>&nbsp;
                    </td>
                    <td class="CommonListCell">
                        <%# Eval("GroupName")%>&nbsp;
                    </td>
                    <td class="CommonListCell" style="text-align: center;">
                        <img src="<%= CommunityServer.Components.SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(Eval("IsActive").ToString()) ? "published" : "unpublished" %>.png"
	                        title="<%# Boolean.Parse(Eval("IsActive").ToString()) ? CommunityServer.Components.ResourceManager.GetString("CP_Blog_Comments_Published", "ControlPanelResources.xml") : CommunityServer.Components.ResourceManager.GetString("CP_Blog_Comments_NotPublished", "ControlPanelResources.xml")%>" />
                    </td>
                    <td class="CommonListCell" nowrap="nowrap">
                       <input type="button" value="Edit" onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forums_ControlPanel_EditForum", Eval("SectionID").ToString()) %>'" />
                       &nbsp;
                       <input type="button" value="Read" onclick="window.location = '<%# Eval("Url") %>'"  />
                       &nbsp;
                       <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this forum?');" ResourceName="CP_PermissionList_Delete" />
                    </td>
                </tr>
        </AlternatingItemTemplate>
        <FooterTemplate>
            </table>
        </div>
        </FooterTemplate>
    </asp:Repeater>
	
	<p class="PanelSaveButton">
		<cp:resourcelinkbutton id="AddButton" runat="server" resourcename="CP_Forums_TreeView_NewForum" cssclass="CommonTextButton" /> &nbsp;&nbsp;&nbsp;
	</p>
</asp:Content>