<%@ Page language="c#" Codebehind="ForumGroups.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Forums.ForumGroupsPage" MasterPageFile="~/ControlPanel/Masters/ForumAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol id="SectionDescription" runat="server" resourcename="CP_Forums_ForumGroupList_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation runat="server" SelectedNavItem="ForumGroupList" />
	<div class="CommonDescription">
		<cp:resourcecontrol id="Section_Sub_Description" runat="server" resourcename="CP_Forums_ForumGroupList_SubTitle" />
	</div>
	
	<div class="PanelSaveButton">
		<cp:ResourceButton id="AddButton" runat="server" resourcename="CP_Forums_TreeView_NewGroup" />
	</div>
	
	<asp:Repeater Runat="server" id="GroupList">
        <HeaderTemplate>
        <div class="CommonListArea">
	        <table id="Listing" cellSpacing="0" cellPadding="0" border="0" width="100%">
		        <thead>
			        <tr>
				        <th class="CommonListHeaderLeftMost">
					        <cp:resourcecontrol runat="server" resourcename="CP_Forums_GroupEdit_ForumGroupName" />
				        </th>
				        <th class="CommonListHeader">
				            &nbsp;	
			            </th>
			        </tr>
		        </thead>
        </HeaderTemplate>
        <ItemTemplate>
                <tr>
                    <td class="CommonListCellLeftMost" style="width: 80%;">
                        <a href='<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forumGroup", Eval("GroupID").ToString()) %>'><%# Eval("Name") %></a>
                    </td>
                    <td class="CommonListCell" style="text-align: center;">
                       <input type="button" value="Edit" onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forums_ControlPanel_EditGroup", Eval("GroupID").ToString()) %>'" />
                       &nbsp;
                       <input type="button" value="Manage" onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forums_ControlPanel_ForumListByGroup", Eval("GroupID").ToString()) %>'"  />
                       &nbsp;
                       <CP:ResourceButton runat="server" CommandArgument='<%# Eval("GroupID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this group?');" ResourceName="CP_PermissionList_Delete" Enabled='<%# !CommunityServer.Discussions.Components.ForumGroups.HasChildSections(Int32.Parse(Eval("GroupID").ToString())) %>'  />
                    </td>
                </tr>
        </ItemTemplate>
        <AlternatingItemTemplate>
                <tr class="AltListRow">
                    <td class="CommonListCellLeftMost" style="width: 80%;">
                        <a href='<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forumGroup", Eval("GroupID").ToString()) %>'><%# Eval("Name") %></a>
                    </td>
                    <td class="CommonListCell" style="text-align: center;">
                       <input type="button" value="Edit" onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forums_ControlPanel_EditGroup", Eval("GroupID").ToString()) %>'" />
                       &nbsp;
                       <input type="button" value="Manage" onclick="window.location = '<%# CommunityServer.Components.Globals.GetSiteUrls().UrlData.FormatUrl("forums_ControlPanel_ForumListByGroup", Eval("GroupID").ToString()) %>'"  />
                       &nbsp;
                       <CP:ResourceButton runat="server" CommandArgument='<%# Eval("GroupID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this group?');" ResourceName="CP_PermissionList_Delete" Enabled='<%# !CommunityServer.Discussions.Components.ForumGroups.HasChildSections(Int32.Parse(Eval("GroupID").ToString())) %>'  />
                    </td>
                </tr>
        </AlternatingItemTemplate>
        <FooterTemplate>
            </table>
        </div>
        </FooterTemplate>
    </asp:Repeater>

</asp:Content>