<%@ WebHandler Language="C#" Class="CommunityServer.Blogs.Components.ThreadViewReport" %>


using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Xml;
using CommunityServer.Components;
using CommunityServer.Blogs.Components;
using CommunityServer.MediaGalleries.Components;

namespace CommunityServer.Blogs.Components
{
	public class ThreadViewReport : IHttpHandler 
	{
	    HttpContext context;
    
		public void ProcessRequest (HttpContext context) 
		{

            int sectionId = 0;
            int postId = 0;
            string appTypeValue;
            string report;
            
            int.TryParse(context.Request.QueryString["sid"], out sectionId);
            int.TryParse(context.Request.QueryString["pid"], out postId);
            appTypeValue = context.Request.QueryString["appType"];
            report = context.Request.QueryString["report"];
            
            this.context = context;
            
            switch (report) {
                case "ViewsBySection":
                    ViewsBySectionReport(sectionId);
                    break;
                case "ViewsByDay":
                    ViewsByDayReport(sectionId, postId);
                    break;
                case "ViewsByDayForApp":
                    ViewsByDayForAppReport(appTypeValue);
                    break;
                case "FileViewsBySection":
                    FileViewsBySectionReport(sectionId);
                    break;
            }
            
        }

        private void ViewsByDayReport (int sectionId, int postId) 
        {
            
            CommonDataProvider dp = CommonDataProvider.Instance();
            
            List<Post> threads = dp.ThreadViewsByDay(sectionId, postId);

			context.Response.ContentType = "text/xml";
			XmlTextWriter xml = new XmlTextWriter(context.Response.OutputStream, Encoding.UTF8);

			xml.WriteStartElement("chart");
	        
			// Series labels
			xml.WriteStartElement("xaxis");
			
			foreach (Post p in threads) {
			    xml.WriteStartElement("value");
			    xml.WriteAttributeString("xid", p.PostDate.ToString("d"));
			    xml.WriteValue(p.PostDate.ToString("d MMM"));
			    xml.WriteEndElement();
			}
	        
			xml.WriteEndElement();
	        
	        
			xml.WriteStartElement("graphs");
		    xml.WriteStartElement("graph");
		    xml.WriteAttributeString("gid", "1");
			
			foreach (Post p in threads) {
			    xml.WriteStartElement("value");
			    xml.WriteAttributeString("xid", p.PostDate.ToString("d"));
			    //xml.WriteAttributeString("url", "referrals.aspx?sectionid=" + sectionId.ToString() + "&postid=" + p.PostID.ToString());
			    xml.WriteValue(p.Views);
			    xml.WriteEndElement();
			}
	        
			xml.WriteEndElement();

			xml.Close();
        }

        private void ViewsByDayForAppReport(string appTypeValue)
        {
            CommonDataProvider dp = CommonDataProvider.Instance();
            List<Post> threads = null;

            if (!string.IsNullOrEmpty(appTypeValue))
            {
                ApplicationType appType = (ApplicationType)Enum.Parse(typeof(ApplicationType), appTypeValue, true);
                threads = dp.ThreadViewsByDay(appType);
            }
            else
                threads = dp.ThreadViewsByDay();

            if (threads == null)
                return;
                
            context.Response.ContentType = "text/xml";
            XmlTextWriter xml = new XmlTextWriter(context.Response.OutputStream, Encoding.UTF8);

            xml.WriteStartElement("chart");

            // Series labels
            xml.WriteStartElement("xaxis");

            foreach (Post p in threads)
            {
                xml.WriteStartElement("value");
                xml.WriteAttributeString("xid", p.PostDate.ToString("d"));
                xml.WriteValue(p.PostDate.ToString("d MMM"));
                xml.WriteEndElement();
            }

            xml.WriteEndElement();

            xml.WriteStartElement("graphs");
            xml.WriteStartElement("graph");
            xml.WriteAttributeString("gid", "1");

            foreach (Post p in threads)
            {
                xml.WriteStartElement("value");
                xml.WriteAttributeString("xid", p.PostDate.ToString("d"));
                xml.WriteValue(p.Views);
                xml.WriteEndElement();
            }

            xml.WriteEndElement();

            xml.Close();
        }
                
        private void ViewsBySectionReport(int sectionId) 
        {
            
            CommonDataProvider dp = CommonDataProvider.Instance();
            
            List<Post> threads = dp.ThreadViewsForSection(sectionId);

			context.Response.ContentType = "text/xml";
			XmlTextWriter xml = new XmlTextWriter(context.Response.OutputStream, Encoding.UTF8);

			xml.WriteStartElement("chart");
	        
			// Series labels
			xml.WriteStartElement("series");
			
			foreach (Post p in threads) {
			    xml.WriteStartElement("value");
			    xml.WriteAttributeString("xid", p.ThreadID.ToString());
			    xml.WriteValue(p.Subject);
			    xml.WriteEndElement();
			}
	        
			xml.WriteEndElement();
	        
	        
			xml.WriteStartElement("graphs");
		    xml.WriteStartElement("graph");
		    xml.WriteAttributeString("gid", "1");
			
			foreach (Post p in threads) {
			    xml.WriteStartElement("value");
			    xml.WriteAttributeString("xid", p.ThreadID.ToString());
			    xml.WriteAttributeString("url", "referrals.aspx?sectionid=" + sectionId.ToString() + "&postid=" + p.PostID.ToString());
			    xml.WriteValue(p.Views);
			    xml.WriteEndElement();
			}
	        
			xml.WriteEndElement();

			xml.Close();
        
	    }

        private void FileViewsBySectionReport(int sectionId)
        {
            MediaGalleryThreadQuery query = new MediaGalleryThreadQuery();
            query.SectionID = sectionId;
            query.ReturnFullThread = false;
            query.SortBy = MediaGalleryPostSortBy.PostDate;
            query.SortOrder = SortOrder.Descending;

            ThreadSet files = MediaGalleries.Components.MediaGalleryPosts.GetMediaGalleryPosts(query);

            context.Response.ContentType = "text/xml";
            XmlTextWriter xml = new XmlTextWriter(context.Response.OutputStream, Encoding.UTF8);

            xml.WriteStartElement("chart");

            // Series labels
            xml.WriteStartElement("series");

            foreach (Post p in files.Threads)
            {
                xml.WriteStartElement("value");
                xml.WriteAttributeString("xid", p.ThreadID.ToString());
                xml.WriteValue(p.Subject);
                xml.WriteEndElement();
            }

            xml.WriteEndElement();


            xml.WriteStartElement("graphs");
            xml.WriteStartElement("graph");
            xml.WriteAttributeString("gid", "1");

            foreach (Post p in files.Threads)
            {
                xml.WriteStartElement("value");
                xml.WriteAttributeString("xid", p.ThreadID.ToString());
                xml.WriteAttributeString("url", "referrals.aspx?sectionid=" + sectionId.ToString() + "&postid=" + p.PostID.ToString());
                xml.WriteValue(p.Views);
                xml.WriteEndElement();
            }

            xml.WriteEndElement();

            xml.Close();

        }
 
		public bool IsReusable {
			get {
				return false;
			}
		}
	}
}