<%@ Page language="c#" EnableViewState="False" Codebehind="switch.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Blogs.BlogSwitchPage" MasterPageFile="~/ControlPanel/Masters/Blogs.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderID="PanelNavigation" runat="server">
    <div class="DashboardMenuAreaFull">
        <CP:NavigationDropDownList CssClass="DashboardMenu" OpenCssClass="DashboardMenuOpen" runat="server" FileName="~/ControlPanel/DashboardMenu.config" MenuGroupCssClass="DashboardContextMenuGroup" MenuItemCssClass="DashboardContextMenuItem" MenuItemSelectedCssClass="DashboardContextMenuItemHover" MenuItemIconWidth="20" MenuItemIconHeight="20" MenuDirection="Down" />
    </div>
</asp:Content>

<asp:Content ContentPlaceHolderId="TopLeft" runat="server"></asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <script type="text/javascript">
	// <![CDATA[
	function closeModal(redirectUrl)
	{
		window.parent.Telligent_Modal.Close(redirectUrl);
	}
	// ]]>
	</script>
	
	
	    <div class="CommonDescription">
		    <cp:resourcecontrol runat="server" resourcename="CP_Blog_Switch_Description" />
	    </div>
	    <cp:statusmessage id="Status" runat="server" visible="false"></cp:statusmessage>
		
	    <h4><CP:CSLiteral runat="server" ID="message" /></h4>

        <table border="0" cellpadding="3" cellspacing="0">
            <tr>
                <td width="75px"><CP:ResourceControl resourcename="CP_BlogAdmin_Blogs_Filter" runat = "Server" /></td>
                <td><cp:AlphaPicker runat = "Server" id = "picker" /></td>
            </tr>
            <tr>
                <td width="75px"><CP:ResourceControl resourcename="CP_BlogAdmin_Blogs_Search" runat = "Server" /></td>
                <td><input type="text" id = "q" name="q" value ="<%= Server.HtmlEncode(Request.QueryString["q"]) %>"></input> <input type="button" onclick="javascript:window.location = window.location.pathname + '?q=' + escape(q.value)" value ="Go" /></td>
            </tr>
        </table>			

			
        <div class="CommonListArea" style="clear:both">
        <asp:Repeater runat = "Server" id = "theBlogs">
        <HeaderTemplate>
        <table id="BlogLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
        <thead>
        <tr>
            <th class="CommonListHeaderLeftMost" ><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_BlogTitle" /></th>
            <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_BlogAddress" /></th>
            <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Enabled" /></th>    
        </tr>
        </thead>
        </HeaderTemplate>
        <ItemTemplate>
        <tr>
            <td class="CommonListCellLeftMost">
                <strong><a onclick="window.parent.location = '<%= BlogUrls.Instance().ControlPanel_Blogs %>?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>';" href="<%= BlogUrls.Instance().ControlPanel_Blogs %>?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a></strong>
            </td>
            <td class="CommonListCell">
                <a onclick="window.parent.location = '<%# BlogUrls.Instance().HomePage(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString()) %>'" href="<%# BlogUrls.Instance().HomePage(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString()) %>">/<%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50)%></a>
            </td>
            <td class="CommonListCell" align="center">
                <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsActive").ToString()) ? "published" : "unpublished" %>.png"/>
            </td>    
        </tr>
        </ItemTemplate>
        <AlternatingItemTemplate>
        <tr class="AltListRow">
            <td class="CommonListCellLeftMost">
                <strong><a onclick="window.parent.location = '<%= BlogUrls.Instance().ControlPanel_Blogs %>?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>';" href="<%= BlogUrls.Instance().ControlPanel_Blogs %>?sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a></strong>
            </td>
            <td class="CommonListCell">
                <a onclick="window.parent.location = '<%# BlogUrls.Instance().HomePage(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString()) %>'" href="<%# BlogUrls.Instance().HomePage(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString()) %>">/<%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50)%></a>
            </td>
            <td class="CommonListCell" align="center">
                <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/<%# Boolean.Parse(DataBinder.Eval(Container.DataItem,"IsActive").ToString()) ? "published" : "unpublished" %>.png"/>
            </td>
        </tr>
        </AlternatingItemTemplate>
        <FooterTemplate>
        </table>
        </FooterTemplate>
        </asp:Repeater>
        </div>				

</asp:Content>