<%@ Page language="c#" Codebehind="Tokens.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Blogs.TokensPage" MasterPageFile="~/ControlPanel/Masters/Blogs.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcelabel id="title" runat="server" resourcename="CP_Blog_TextParts_Title"></cp:resourcelabel>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation selectednavitem="TextParts" runat="server" id="SelectedNavigation1" />

    <script>
    function refreshPage(res)
    {
        refresh();
    }
    </script>

    <DIV class="CommonDescription">
	    <CP:ResourceControl runat="server" ResourceName="CP_Blog_TextParts_SubTitle" />
    </DIV>

    <div class="CommonFormArea" style="text-align: right;">
	    <cp:ModalButton id="NewTextPart" runat="Server" resourcename="CP_Blog_TextParts_NewTextPart" height="430"
		    width="480" url="TokenForm.aspx" CallBack="refreshCallback" />
    </div>			
    			
    <div class="CommonListArea">
    <asp:Repeater runat = "Server" id = "theTokens">
    <HeaderTemplate>
	    <table id="CommentListing" cellSpacing="0" cellPadding="0" border="0" width="100%">
        <thead>
            <tr>
            <th class="CommonListHeaderLeftMost" ><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Name" ID="Resourcecontrol3" NAME="Resourcecontrol3"/></th>
            <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Link" ID="Resourcecontrol4" NAME="Resourcecontrol4"/></th>
            <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Text" ID="Resourcecontrol5" NAME="Resourcecontrol4"/></th>
            <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Actions" ID="Resourcecontrol7" NAME="Resourcecontrol4"/></th>
            </tr>
        </thead>
    </HeaderTemplate>
    <ItemTemplate>
	    <tr>
	    <td class="CommonListCellLeftMost"><%# DataBinder.Eval(Container.DataItem,"Token")%></td>
	    <td class="CommonListCell"><a href="<%# DataBinder.Eval(Container.DataItem,"Link")%>"><%# DataBinder.Eval(Container.DataItem,"Link")%></a></td>
	    <td class="CommonListCell"><%# DataBinder.Eval(Container.DataItem,"Text") %></td>
	    <td  class="CommonListCell" nowrap="nowrap">
	    
	    <cp:ModalButton runat="Server" Height="430" Width="480" callback="refreshCallback" resourcename="CP_Blog_GridCol_Edit" Url = '<%# "TokenForm.aspx?TokenID=" + DataBinder.Eval(Container.DataItem,"TokenID") %>' />
	    <CP:ResourceButton CommandArgument='<%# DataBinder.Eval(Container.DataItem, "TokenID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_Blog_GridCol_Delete"  /></td>
	    </tr>
    </ItemTemplate>
    <AlternatingItemTemplate>
	    <tr class="AltListRow">
	    <td class="CommonListCellLeftMost"><%# DataBinder.Eval(Container.DataItem,"Token")%></td>
	    <td class="CommonListCell"><a href="<%# DataBinder.Eval(Container.DataItem,"Link")%>"><%# DataBinder.Eval(Container.DataItem,"Link")%></a></td>
	    <td class="CommonListCell"><%# DataBinder.Eval(Container.DataItem,"Text") %></td>
	    <td  class="CommonListCell" nowrap="nowrap">
   	    <cp:ModalButton runat="Server" Height="430" Width="480" callback="refreshCallback" resourcename="CP_Blog_GridCol_Edit" Url = '<%# "TokenForm.aspx?TokenID=" + DataBinder.Eval(Container.DataItem,"TokenID") %>' />
	    <CP:ResourceButton CommandArgument='<%# DataBinder.Eval(Container.DataItem, "TokenID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_Blog_GridCol_Delete"  /></td>
	    </tr>
    </AlternatingItemTemplate>

    <FooterTemplate>
	    </table>
    </FooterTemplate>
    </asp:Repeater>

    </div>
</asp:Content>