<%@ Page language="c#" Codebehind="PostEditor.aspx.cs" AutoEventWireup="true" Inherits="CommunityServer.ControlPanel.Blogs.PostEditorPage" MasterPageFile="~/ControlPanel/Masters/Blogs.master" %>
<%@Import Namespace="CommunityServer.Blogs.Components" %>

<script runat="server">
    
    protected override void  OnLoad(EventArgs e)
    {
 	    base.OnLoad(e);

        CreatePost.BlogPostType = FetchBlogPostType;

        WeblogConfiguration config = WeblogConfiguration.Instance();
        Literal defaultTags = WeblogControlUtility.Instance().FindControl(this, "DefaultTags") as Literal;
        Control defaultTagsContainer = WeblogControlUtility.Instance().FindControl(this, "DefaultTagsContainer");
        if (config.DefaultAggregateTags != null && config.DefaultAggregateTags.Length > 0)
        {
            defaultTagsContainer.Visible = true;
            foreach (string tag in config.DefaultAggregateTags)
            {
                if (defaultTags.Text.Length > 0)
                    defaultTags.Text += "; ";

                defaultTags.Text += tag;
            }
        }
        else
        {
            defaultTagsContainer.Visible = false;
        }
    }

    public void PostSaved(Control sender, object parameter)
    {
        WeblogPost post = parameter as WeblogPost;
        CheckBox continueWriting = WeblogControlUtility.Instance().FindControl(this, "ContinueWriting") as CheckBox;
        if (continueWriting.Checked)
        {
            Response.Redirect(string.Format("posteditor.aspx?SelectedNavItem=Posts&sectionid={0}&postid={1}", CurrentWeblog.SectionID.ToString(), post.PostID.ToString()));
        }
        else
        {
            if (post.BlogPostType == BlogPostType.Post)
                Response.Redirect("postlist.aspx?tab=postlist&sectionid=" + CurrentWeblog.SectionID.ToString());
            else
                Response.Redirect("articlelist.aspx?tab=articlelist&sectionid=" + CurrentWeblog.SectionID.ToString());
        }
    }
    
</script>


<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl id="PageTitle" runat="server" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation id="SelectedNavigation1" runat="server" SelectedNavItem="Posts" />
    <div class="CommonDescription" style="display: none;">
		<CP:ResourceControl id="Description" runat="server" />
    </div>
	
	<CSBlog:CreateEditWeblogPostForm runat="server" ID="CreatePost" 
	    CommentModerationDropDownListId="ModerationDDL" 
	    CustomValidatorId="PostValidator" 
	    EnableAllOwnerNotificationCheckBoxId="ynNotifyAllOwners" 
	    EnableCrossPostingCheckBoxId="ynEnableCrossPosting" 
	    EnableRatingsCheckBoxId="ynEnableRatings" 
	    EnableTrackBacksCheckBoxId="ynEnableTrackbacks" 
	    FeedbackNotificationDropDownListId="NotificationType" 
	    IsAggregatedCheckBoxId="ynAggregatePost" 
	    IsCommunityAggregatedCheckBoxId="ynCommunity" 
	    EnableCommentsCheckBoxId="ynEnableReplies" 
	    IsPublishedCheckBoxId="Publish" 
	    PostBodyEditorId="PostBody" 
	    PostDateDateTimeSelectorId="DatePicker" 
	    PostExcerptEditorId="postExcerpt" 
	    PostNameTextBoxId="postName" 
	    PostSubjectTextBoxId="PostSubject" 
	    PreviewWeblogPostListId="PreviewList" 
	    SubFormIds="PostTags,PostAttachment,PostVideo" 
	    SubmitButtonId="PostButton" 
	    SyndicateExcerptCheckBoxId="ynSyndicateExcerpt">
	    <SuccessActions>
	        <CSControl:CustomAction runat="server" OnCustomEvent="PostSaved" />
	    </SuccessActions>
	    <FormTemplate>
	        <div style="display: none;">
	            <asp:CheckBox runat="server" ID="Publish" />
	            <asp:CheckBox runat="server" ID="ContinueWriting" />
	        </div>
	
            <asp:ValidationSummary Runat = "server" ID="valSummary" HeaderText="Your post/article has the following errors" />

            <TWC:TabbedPanes id="EditorTabs" runat="server"
                PanesCssClass="CommonPane"
                TabSetCssClass="CommonPaneTabSet"
                TabCssClasses="CommonPaneTab"
                TabSelectedCssClasses="CommonPaneTabSelected"
                TabHoverCssClasses="CommonPaneTabHover"
                >
                <TWC:TabbedPane runat="server">
	                <Tab><CP:ResourceControl resourcename="CP_BlogContentEditor_Write" runat = "Server" /></Tab>
	                <Content>
		                <div class="CommonFormField">
			                <strong><cp:formlabel id="tt" runat="Server" controltolabel="PostSubject" resourcename="Weblog_CreateEditBlogPost_Title" /></strong> &nbsp;
			                <asp:textbox id="PostSubject" cssclass="ControlPanelTextInputBig" maxlength="256" runat="server" />
			                <asp:requiredfieldvalidator id="postSubjectValidator" runat="server" controltovalidate="PostSubject" Display ="Dynamic" ErrorMessage ="A post title is required" >*</asp:requiredfieldvalidator>
		                </div>
		                <div class="CommonFormFieldName">
			                <asp:requiredfieldvalidator id="postBodyValidator" display="Dynamic" runat="server"
				                controltovalidate="PostBody" ErrorMessage="Please add some content">*<br /></asp:requiredfieldvalidator>
		                </div>
		                <div class="CommonFormField">
			                <CSControl:editor runat="Server" id="PostBody" width="100%" />
		                </div>
		                
		                <CSBlog:WeblogPostTagsSubForm ID="PostTags" runat="server" 
		                    SelectTagsModalButtonId="SelectTags" 
		                    TagsTextBoxId="Tags">
		                    <FormTemplate>
                                <p />
                                <div class="CommonFormFieldName">
                                    <cp:formlabel id="Formlabel3" runat="Server" resourcename="Weblog_CreateEditBlogPost_Categories" />
                                </div>
                                <div class="CommonFormField">
                                    <table cellpadding="0" cellspacing="0" border="0">
                                    <tr valign="top">
                                    <td>
                                        <asp:TextBox Columns="50" ID="Tags" runat="server" />
                                        &nbsp;&nbsp;<CP:Modal modaltype="Button" width="400" height="300" runat="Server" id="SelectTags" ResourceName="TagEditor_SelectTags" />
                                    </td>
                                    </tr>
                                    </table>
                                </div>
                                <p id="DefaultTagsContainer" runat="server">
                                    <cp:resourcecontrol runat="server" resourcename="CP_Blogs_CreateEditBlogPost_DefaultTagsNotice" /><br />
                                    <asp:literal id="DefaultTags" runat="server" />
                                </p>
		                    </FormTemplate>
		                </CSBlog:WeblogPostTagsSubForm>
		                
		               
                        <CSBlog:WeblogPostAttachmentSubForm ID="PostAttachment" runat="server"
                            AddUpdateAttachmentModalId="AttachmentModal"
                            FilenameLabelId="serverfilename"
                            RemoveAttachmentButtonId="RemoveAttachment">
                            <FormTemplate>
                                <p>
                                <div class="CommonFormFieldName">
                                    <strong>File Attachment</strong>
                                    <br />
                                    Attach a file that will be included and published (RSS) with your post. This is commonly used for Podcasting.
                                </div>
                                
                                <div class="CommonFormField">
                                    <asp:Label Columns="50" ID="serverfilename" runat="server" />&nbsp;&nbsp;
                                    <CP:Modal modaltype="Button" url="Attachment.aspx" width="640" height="240" runat="Server" callback="getAttachmentData" resourcename="CP_Blogs_CreateEditBlogPost_File" id="AttachmentModal" />
                                    <CP:resourcebutton runat="server" id="RemoveAttachment" ResourceName="CP_Blogs_CreateEditBlogPost_RemoveAttachement"/>
                                </div>
                                </p>                                
                            </FormTemplate>
                        </CSBlog:WeblogPostAttachmentSubForm>
                        
		                <p />
	                </Content>
                </TWC:TabbedPane>


                <TWC:TabbedPane runat="server">
	                <Tab><CP:ResourceControl resourcename="CP_BlogContentEditor_Options" runat="Server" /></Tab>
	                <Content>
            		    
                        <table width="100%">
                            <tr>
                                <td colspan="2">
                                    <div class="CommonFormSubTitle"><cp:resourcecontrol ID="Resourcecontrol11" runat="server" resourcename="CP_Blogs_SubTitle_Reader_Feedback" /></div>
                                </td>
                            </tr>

                            <tr>
                                <td class="CommonFormFieldName">
			                            <cp:formlabel ID="Formlabel6" runat="Server" controltolabel="ynEnableReplies" resourcename="Weblog_CreateEditBlogPost_AllowReplies" />
                                </td>
                                
                                <td class="CommonFormField">
		                                <CSControl:YesNoCheckBox ID="ynEnableReplies" runat="server" />
	                            </td>
                            </tr>
                            
                            <tr>
                                <td class="CommonFormFieldName">
			                            <cp:formlabel ID="Formlabel5" runat="Server" controltolabel="ModerationDDL" resourcename="Weblog_CreateEditBlogPost_ModerateComments" />
                                </td>
                                
                                <td class="CommonFormField">
		                                <asp:DropDownList runat="server" id="ModerationDDL" />
                                </td>
                            </tr>

                            <tr>
                                <td class="CommonFormFieldName">
			                            <cp:formlabel ID="Formlabel7" runat="Server" controltolabel="ynEnableRatings" resourcename="Weblog_CreateEditBlogPost_EnableRatings" />
                                </td>
                                
                                <td class="CommonFormField">
		                                <CSControl:YesNoCheckBox ID="ynEnableRatings" runat="server" />
                                </td>
                            </tr>

                            <tr>
                                <td colspan="2">
                                    <div class="CommonFormSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Blogs_SubTitle_Email_Notifications" /></div>
                                </td>
                            </tr>
                            <tr>
                                <td class="CommonFormFieldName">
			                            <cp:formlabel runat="Server" controltolabel="NotificationType" resourcename="CP_Blogs_CreateEditBlogPost_FeedbackNotify" />
                                </td>
                                
                                <td class="CommonFormField">
		                                <asp:DropDownList runat="server" id="NotificationType" runat="server" />
                                </td>
                            </tr>

                            <tr>
                                <td class="CommonFormFieldName">
			                            <cp:formlabel runat="Server" controltolabel="ynNotifyAllOwners" resourcename="CP_Blogs_CreateEditBlogPost_NotifyAllOwners" />
                                </td>

                                <td class="CommonFormField">
		                                <CSControl:YesNoCheckBox ID="ynNotifyAllOwners" runat="server" />
                                </td>
                            </tr>
                            
                            <tr>
                                <td colspan="2">
                                    <div class="CommonFormSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Blogs_SubTitle_Reader_Trackbacks" /></div>
                                </td>
                            </tr>
                            <tr>
                                <td class="CommonFormFieldName">
			                            <cp:formlabel runat="Server" controltolabel="ynEnableTrackbacks" resourcename="Weblog_CreateEditBlogPost_EnableTrackBacks" />
                                </td>
                                
                                <td class="CommonFormField">
		                                <CSControl:YesNoCheckBox ID="ynEnableTrackbacks" runat="server" />
                                </td>
                            </tr>

                        </table>
            				
	                </Content>
                </TWC:TabbedPane>

                <TWC:TabbedPane ID="TabbedPane1" runat="server">
	                <Tab><CP:ResourceControl ID="ResourceControl3" resourcename="CP_BlogContentEditor_Write_Options" runat = "Server" /></Tab>
	                <Content>
	                    <table width="100%">
                                <tr>
                                    <td colspan="2">
                                        <div class="CommonFormSubTitle"><cp:resourcecontrol ID="Resourcecontrol6" runat="server" resourcename="CP_Blogs_SubTitle_Post_Summary" /></div>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="CommonFormFieldName">
				                            <cp:formlabel ID="Formlabel1" runat="Server" controltolabel="ynSyndicateExcerpt" resourcename="Weblog_CreateEditBlogPost_SyndicateExcerpt" />
                                    </td>
                                    
                                    <td class="CommonFormField">
			                                <CSControl:YesNoCheckBox ID="ynSyndicateExcerpt" runat="server" />
                                    </td>
                                </tr>

                                <tr>
                                    <td colspan="2">
			                            <div class="CommonFormFieldName">
			                                <cp:formlabel ID="Formlabel2" runat="Server" controltolabel="postExcerpt" resourcename="Weblog_CreateEditBlogPost_Excerpt" />
		                                </div>
		                                <div class="CommonFormField">
                			                <CSControl:editor runat="Server" id="postExcerpt" Width="90%" Height="200" />
		                                </div>
                                    </td>
                                </tr>

                                <tr>
                                    <td colspan="2">
                                        <div class="CommonFormSubTitle"><cp:resourcecontrol ID="Resourcecontrol10" runat="server" resourcename="CP_Blogs_SubTitle_Post_Publication" /></div>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="CommonFormFieldName">
			                                <cp:formlabel ID="Formlabel4" runat="Server" controltolabel="postDate" resourcename="Weblog_CreateEditBlogPost_PostDate" />
		                            </td>
		                            <td class="CommonFormField">
			                                <TWC:DateTimeSelector runat="server" id="DatePicker" AllowBlankValues="false" DateTimeFormat="MMMM d yyyy hh:mm tt" ShowCalendarPopup="true" />
                                    </td>
                                </tr>
                            </table>
	                </Content>
                </TWC:TabbedPane>
            	
                <TWC:TabbedPane runat="server" ID="VideoTab">
	                <Tab><CP:ResourceControl resourcename="CP_BlogContentEditor_Video" runat = "Server" /></Tab>
	                <Content>
	                    <CSBlog:WeblogPostVideoSubForm ID="PostVideo" runat="server" ControlIdsToHideWhenNotVisible="VideoTab"
	                        VideoDurationTextBoxId="VideoDuration" 
	                        VideoHeightTextBoxId="VideoHeight" 
	                        VideoImageUrlTextBoxId="VideoImageUrl" 
	                        VideoUrlTextBoxId="VideoUrl" 
	                        VideoWidthTextBoxId="VideoWidth">
	                        <FormTemplate>

                                <div class="CommonFormSubTitle"><cp:resourcecontrol ID="Resourcecontrol2" runat="server" resourcename="CreateEditPost_VideoTitle" /></div>
                            
                                <div class="CommonFormFieldName">
                                    <strong><CSControl:FormLabel LabelForId="VideoUrl" ResourceName="CreateEditPost_VideoUrl" ResourceFile="ControlPanelResources.xml" runat="server" /></strong>
                                    <br />
                                    <cp:ResourceControl runat="server" ResourceName="CreateEditPost_VideoUrlDesc" />
                                </div>

                                <div class="CommonFormField">
                                    <asp:textbox id="VideoUrl" cssclass="ControlPanelTextInput" runat="server" autocomplete="off" />
                                </div>
                            
                                <div class="CommonFormFieldName">
                                    <strong><CSControl:FormLabel LabelForId="VideoImageUrl" ResourceName="CreateEditPost_PreviewImageUrl" ResourceFile="ControlPanelResources.xml" runat="server" /></strong>
			                        <br />
                                    <cp:ResourceControl runat="server" ResourceName="CreateEditPost_PreviewImageUrlDesc"/>
                                </div>
                                <div class="CommonFormField">
			                        <asp:textbox id="VideoImageUrl" cssclass="ControlPanelTextInput" runat="server" autocomplete="off"/>
                                </div>
                            
                                <div class="CommonFormFieldName">
                                    <strong><CSControl:FormLabel LabelForId="VideoDuration" ResourceName="CreateEditPost_VideoDuration" ResourceFile="ControlPanelResources.xml" runat="server" /></strong>
	                                <br />
	                                <cp:ResourceControl runat="server" ResourceName="CreateEditPost_VideoDurationDesc"/>
                                </div>
                                <div class="CommonFormField">
	                                <asp:textbox id="VideoDuration" cssclass="ControlPanelTextInput" runat="server" autocomplete="off"/>
                                </div>
                            
                                <div class="CommonFormFieldName">
                                    <strong><CSControl:FormLabel LabelForId="VideoWidth" ResourceName="CreateEditPost_VideoWidth" ResourceFile="ControlPanelResources.xml" runat="server" /></strong>
			                        <br />
			                        <cp:ResourceControl runat="server" ResourceName="CreateEditPost_VideoWidthDesc"/>
                                </div>
                                <div class="CommonFormField">
	                                <asp:textbox id="VideoWidth" cssclass="ControlPanelTextInput" runat="server" autocomplete="off"/>
	                                <asp:RegularExpressionValidator id="VideoWidthValidator" ControlToValidate="VideoWidth" ValidationExpression="^[0-9]*$" runat="server">*</asp:RegularExpressionValidator>
                                </div>
                            
                                <div class="CommonFormFieldName">
                                    <strong><CSControl:FormLabel LabelForId="VideoHeight" ResourceName="CreateEditPost_VideoHeight" ResourceFile="ControlPanelResources.xml" runat="server" /></strong>
			                        <br />
			                        <cp:ResourceControl runat="server" ResourceName="CreateEditPost_VideoHeightDesc"/>
                                </div>
                                <div class="CommonFormField">
	                                <asp:textbox id="VideoHeight" cssclass="ControlPanelTextInput" runat="server" autocomplete="off" />
	                                <asp:RegularExpressionValidator id="VideoHeightValidator" ControlToValidate="VideoHeight" ValidationExpression="^[0-9]*$" runat="server">*</asp:RegularExpressionValidator>
                                </div>
                                       
	                        </FormTemplate>
	                    </CSBlog:WeblogPostVideoSubForm>
	                </Content>
                </TWC:TabbedPane>

                <TWC:TabbedPane runat="server">
	                <Tab><CP:ResourceControl resourcename="CP_BlogContentEditor_Advanced_Options" runat = "Server" /></Tab>
	                <Content>
		                <div id="AdvancedProperties">
                            <table width="100%">
                                <tr>
                                    <td colspan="2">
                                        <div class="CommonFormSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Blogs_SubTitle_Post_Display" /></div>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <td class="CommonFormFieldName">
				                            <cp:formlabel runat="Server" controltolabel="ynCommunity" resourcename="Weblog_CreateEditBlogPost_CommunityParticipation" />
                                    </td>
                                    
                                    <td class="CommonFormField">
			                                <CSControl:YesNoCheckBox ID="ynCommunity" runat="server" />
                                    </td>
                                </tr>

                                <tr>
                                    <td class="CommonFormFieldName">
				                            <cp:formlabel runat="Server" controltolabel="ynAggregatePost" resourcename="Weblog_CreateEditBlogPost_AggregatePost" />
                                    </td>
                                    
                                    <td class="CommonFormField">
			                                <CSControl:YesNoCheckBox ID="ynAggregatePost" runat="server" />
                                    </td>
                                </tr>


                                <tr>
                                    <td colspan="2">
                                        <div class="CommonFormSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Blogs_SubTitle_Post_SEO" /></div>
                                    </td>
                                </tr>


                                <tr>
                                    <td colspan="2">
			                            <div class="CommonFormFieldName">
			                                <cp:formlabel runat="Server" controltolabel="postName" resourcename="Weblog_CreateEditBlogPost_Name" />
			                                <asp:regularexpressionvalidator id="vRegexPostName" controltovalidate="postName" runat="server" display="Dynamic" ValidationExpression='<%# WeblogPosts.PostNamePattern %>'>*</asp:RegularExpressionValidator>
		                                </div>
		                                <div class="CommonFormField">
			                                <asp:textbox id="postName" cssclass="ControlPanelTextInput" maxlength="256" runat="server" />
		                                </div>
                                    </td>
                                </tr>

                                <asp:PlaceHolder runat="server" ID="CrossPostingPanel">
                                <tr>
                                    <td colspan="2">
                                        <div class="CommonFormSubTitle"><cp:resourcecontrol runat="server" resourcename="CP_Blogs_SubTitle_Post_Advanced_Options" /></div>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="CommonFormFieldName">
				                            <cp:formlabel runat="Server" controltolabel="ynEnableCrossPosting" resourcename="CP_Blogs_CreateEditBlogPost_EnableCrossPosting" />
                                    </td>
                                    
                                    <td class="CommonFormField">
			                                <CSControl:YesNoCheckBox ID="ynEnableCrossPosting" runat="server" />
                                    </td>
                                </tr>
	                            </asp:PlaceHolder>
                            </table>
		                </div>
	                </Content>
                </TWC:TabbedPane>
            	
                <TWC:TabbedPane runat="server">
	                <Tab OnClickClientFunction="Preview" ><CP:ResourceControl resourcename="CP_BlogContentEditor_Preview" runat = "Server" /></Tab>
	                <Content>
		                <script type="text/javascript">
	                    // <![CDATA[
	                        function Preview()
	                        {
	                            document.getElementById('previewloading').style.display = 'block';
	                            <%# ((CreateEditWeblogPostForm) WeblogControlUtility.Instance().FindControl(this, "CreatePost")).GetPreviewScript("PreviewCallback();") %>
	                        }
		                    
	                        function PreviewCallback()
	                        {
	                            document.getElementById('previewloading').style.display = 'none';
	                        }
	                    // ]]>
	                    </script>
                    
                        <div id="previewloading" style="display:none">Loading <img src = "<%=CommunityServer.Components.SiteUrls.Instance().LoadingImageUrl%>"/></div>
                        <CSBlog:WeblogPostList runat="server" ID="PreviewList">
                            <ItemTemplate>
                                <h3><CSBlog:WeblogPostData runat="server" Property="Subject" /></h3>
                                <CSBlog:WeblogPostData Property="FormattedBody" runat="server" />
                            </ItemTemplate>
                        </CSBlog:WeblogPostList>
		                
		                
	                </Content>
                </TWC:TabbedPane>
            </TWC:TabbedPanes>

            <div id="ErrorPanel" class="CommonMessageError" runat="server" visible="False">
                <asp:CustomValidator runat="server" id="PostValidator" />
            </div>
            <div id="Post" runat="server" visible="true">
            </div>

            <p class="PanelSaveButton">
                <script type="text/javascript">
                // <![CDATA[
                    function SaveAndContinue(publishFlag, continueFlag, element)
                    {
                        if (bypassCheck)
                            bypassCheck();
                            
                        var publishCB = document.getElementById('<%# WeblogControlUtility.Instance().FindControl(this, "Publish").ClientID %>');
                        var continueCB = document.getElementById('<%# WeblogControlUtility.Instance().FindControl(this, "ContinueWriting").ClientID %>');
                        var saveB = document.getElementById('<%# WeblogControlUtility.Instance().FindControl(this, "PostButton").ClientID %>');
                        
                        if (element != saveB || !saveB.ignoreFlags)
                        {
                            if (publishFlag != null)
                                publishCB.checked = publishFlag;
                                
                            if (continueFlag != null)
                                continueCB.checked = continueFlag;
                        }
                        
                        if (element != saveB)
                        {
                            saveB.ignoreFlags = true;
                            eval(decodeURIComponent(saveB.href));
                            saveB.ignoreFlags = false;
                        }
                    }
                // ]]>
                </script>
            
                <CP:resourcelinkbutton id="SaveEditButton" runat="server" resourcename="CP_Blogs_CreateEditBlogPost_SaveContinue" CssClass="CommonTextButtonBig" OnClientClick="SaveAndContinue(null, true, this); return false;" />
                <CP:resourcelinkbutton id="SaveButton" runat="server" resourcename="CP_Blogs_CreateEditBlogPost_Save" CssClass="CommonTextButtonBig" OnClientClick="SaveAndContinue(false, false, this); return false;" />
                <strong><CP:resourcelinkbutton id="PostButton" runat="server" resourcename="CP_Blogs_CreateEditBlogPost_Post" CssClass="CommonTextButtonBig" OnClientClick="SaveAndContinue(true, false, this); return true;" /></strong>
            </p>
	    </FormTemplate>
	</CSBlog:CreateEditWeblogPostForm>
	
</asp:Content>