<%@ Page language="c#" Codebehind="PostCategories.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Blogs.PostCategoriesListPage" MasterPageFile="~/ControlPanel/Masters/Blogs.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server"><CP:ResourceControl id="Resourcecontrol1" runat="server" ResourceName="CP_Blog_PostCategories_Title" /></asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation SelectedNavItem="PostCategories" runat="server" id="SelectedNavigation1" />
    <script language = "javascript" type="text/javascript">
      function reloadCategories(res)
      {
        if(res)
        {
	        refresh();
	    }
      }
      
      function cancelUpdate(sectionId, categoryId)
      {
        var categoryContainer = document.getElementById("" + sectionId + "-" + categoryId);
        var inputContainer = document.getElementById("container-" + sectionId + "-" + categoryId);
        
        if (categoryContainer)
        {
            categoryContainer.style.visibility = "visible";
            categoryContainer.style.position = "static";
        }
        
        if (inputContainer)
        {
            categoryContainer.parentNode.removeChild(inputContainer);
        }
      }
      
      function saveCategory(sectionId, categoryId)
      {
        var categoryInput = document.getElementById("text-" + sectionId + "-" + categoryId);
        var categoryAnchor = document.getElementById("anchor-" + sectionId + "-" + categoryId);
        var categoryEditButton = document.getElementById("editButton-" + sectionId + "-" + categoryId);
        
        if (categoryInput)
        {
            var categoryName = categoryInput.value;
            PostCategories.CreateUpdateCategory(sectionId, categoryId, categoryName);
            
            if (categoryAnchor)
            { 
                categoryAnchor.firstChild.data = categoryName;
                categoryAnchor.href = "javascript:editCategory(" + sectionId + ", " + categoryId + ", '" + categoryName + "')";
            }
            
            if (categoryEditButton)
                categoryEditButton.onclick = new Function("editCategory(" + sectionId + ", " + categoryId + ", '" + categoryName + "')");
        }
        
        cancelUpdate(sectionId, categoryId);
      }
      
      function editCategory(sectionId, categoryId, categoryName)
      {
        var categoryContainer = document.getElementById("" + sectionId + "-" + categoryId);
        
        if (categoryContainer == null)
            return;
        
        var inputText = document.createElement("input");
        inputText.defaultValue = categoryName;
        inputText.value = categoryName;
        inputText.type = "text";
        inputText.id = "text-" + sectionId + "-" + categoryId;
        
        var inputSaveButton = document.createElement("input");
        inputSaveButton.type = "button";
        inputSaveButton.onclick = new Function("saveCategory(" + sectionId + "," + categoryId + ");");
        inputSaveButton.defaultValue = "Save";
        inputSaveButton.value = "Save";
        
        var inputCancelButton = document.createElement("input");
        inputCancelButton.type = "button";
        inputCancelButton.onclick = new Function("cancelUpdate(" + sectionId + "," + categoryId + ");");
        inputCancelButton.defaultValue = "Cancel";
        inputCancelButton.value = "Cancel";
        
        var inputContainer = document.createElement("div");
        inputContainer.id = "container-" + sectionId + "-" + categoryId;
        
        inputContainer.appendChild(inputText);
        inputContainer.appendChild(inputSaveButton);
        inputContainer.appendChild(inputCancelButton);
        
        categoryContainer.style.visibility = "hidden";
        categoryContainer.style.position = "absolute";
        categoryContainer.parentNode.insertBefore(inputContainer, null);
      }
    </script>	
    	
    <DIV class="CommonDescription">
	    <CP:ResourceControl runat="server" ResourceName="CP_Blog_PostCategories_SubTitle" />
    </DIV>

    <div class="CommonListArea">

	    <table id="CommentListing" cellSpacing="0" cellPadding="0" border="0" width="100%">
	    <thead>
	    <tr>
		    <th class="CommonListHeaderLeftMost" >
		    <cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_TagName" /></th>
		    <th class="CommonListHeader PostHeader">
		    <cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Posts" /></th>																																	
		    <th class="CommonListHeader PostHeader">
		    <cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Published" /></th>
		    <th class="CommonListHeader">&nbsp;</th>											
	    </tr>
	    </thead>
        
	    <asp:Repeater runat = "Server" id="theTags">
	    <ItemTemplate>
		    <tr>
			    <td class="CommonListCellLeftMost">
			        <span id='<%# Eval("SectionID")%>-<%# Eval("CategoryID")%>'>
			            <a id="anchor-<%# Eval("SectionID")%>-<%# Eval("CategoryID")%>" href='<%# CommunityServer.Blogs.Components.BlogUrls.Instance().TagsBrowser(new string[] { CurrentWeblog.ApplicationKey, Eval("Name").ToString() })%>'><%# DataBinder.Eval(Container.DataItem,"Name")%></a>
			        </span>
			    </td>
			    <td class="CommonListCell PostViewsCell">
			        <cp:LiteralOrLink runat = "Server" NavigateUrl='<%# "postlist.aspx?tab=postlist&cid=" + DataBinder.Eval(Container.DataItem,"CategoryID").ToString() %>' Text = '<%# DataBinder.Eval(Container.DataItem,"TotalThreads") %>' ID="PostsLink" />
			    </td>			    			    			    
			    <td class="CommonListCell PostViewsCell">
				    <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsEnabled").ToString() %>.png" />
			    </td>
			    <td class="CommonListCell">
			        <input type="button" id="editButton-<%# Eval("SectionID")%>-<%# Eval("CategoryID")%>" onclick='javascript:editCategory(<%# Eval("SectionID")%>, <%# Eval("CategoryID")%>, "<%# Eval("Name") %>")' value="<%# CommunityServer.Components.ResourceManager.GetString("CP_Blog_GridCol_Edit", "ControlPanelResources.xml") %>" />
				    <cp:ResourceButton CommandArgument='<%# DataBinder.Eval(Container.DataItem, "CategoryID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_Blog_GridCol_Delete" />
			    </td>
		      </tr>
	    </ItemTemplate>
        <AlternatingItemTemplate>
		    <tr class="AltListRow">
			    <td class="CommonListCellLeftMost">
			        <span id='<%# Eval("SectionID")%>-<%# Eval("CategoryID")%>'>
			            <a id="anchor-<%# Eval("SectionID")%>-<%# Eval("CategoryID")%>" href='<%# CommunityServer.Blogs.Components.BlogUrls.Instance().TagsBrowser(new string[] { CurrentWeblog.ApplicationKey, Eval("Name").ToString() })%>'><%# DataBinder.Eval(Container.DataItem,"Name")%></a>
			        </span>
			    </td>
			    <td class="CommonListCell PostViewsCell">
			        <cp:LiteralOrLink runat = "Server" NavigateUrl='<%# "postlist.aspx?tab=postlist&cid=" + DataBinder.Eval(Container.DataItem,"CategoryID").ToString() %>' Text = '<%# DataBinder.Eval(Container.DataItem,"TotalThreads") %>' ID="PostsLink" />
			    </td>			    			    			    
			    <td class="CommonListCell PostViewsCell">
				    <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsEnabled").ToString() %>.png" />
			    </td>
			    <td class="CommonListCell">
			        <input type="button" id="editButton-<%# Eval("SectionID")%>-<%# Eval("CategoryID")%>" onclick='javascript:editCategory(<%# Eval("SectionID")%>, <%# Eval("CategoryID")%>, "<%# Eval("Name") %>")' value="<%# CommunityServer.Components.ResourceManager.GetString("CP_Blog_GridCol_Edit", "ControlPanelResources.xml") %>" />
				    <cp:ResourceButton CommandArgument='<%# DataBinder.Eval(Container.DataItem, "CategoryID")%>' CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_Blog_GridCol_Delete" />
			    </td>
		      </tr>
	    </AlternatingItemTemplate>			
	    <FooterTemplate>
	        </table>
	    </FooterTemplate>
	    </asp:Repeater>

    <p>
	    <asp:Textbox id="TagName" runat="server" /> <asp:RequiredFieldValidator Runat="server" ControlToValidate="TagName"  Text="*" />
	    &nbsp;
	    <cp:resourcebutton id="CreateTag" runat="server" resourcename="CP_Blog_PostCategories_Add" />
    </p>
    	
    </div>			
</asp:Content>