<%@ Page language="c#" Codebehind="Links.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Blogs.LinksPage" MasterPageFile="~/ControlPanel/Masters/Blogs.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol id="Resourcecontrol1" runat="server" resourcename="CP_Blog_Links_Title"></cp:resourcecontrol>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation SelectedNavItem="Links" runat="server" id="SelectedNavigation1" />
	<script type="text/javascript">
// <![CDATA[

function reloadCategories(res)
{
	if (res)
	{
		var element = $('<%=  CategoryList.ClientID %>');
		res[1] = res[1].split('@@@').join('"');
		window.location = window.location.pathname + '?categoryid=' + res[2];
		return;
	}
}

function selectCategory()
{
	var element = $('<%=  CategoryList.ClientID %>');
	var index = element.selectedIndex;
	window.location = window.location.pathname + '?categoryid=' + element.options[index].value;

}

function removeCategory(res)
{
    if(res)
    {
        window.location = window.location.pathname;
    }
    return;
}
// ]]>
	</script>
	<DIV class="CommonDescription">
		<cp:resourcecontrol id="Resourcecontrol2" runat="server" resourcename="CP_Blog_Links_SubTitle" />
	</DIV>
	
	<DIV class="CommonFormArea">
		<TABLE cellSpacing="0" cellPadding="0" border="0">
			<TR>
				<TD nowrap="nowrap">
					<cp:formlabel runat="server" resourcename="CP_Blog_Links_SelectCategory" controltolabel="CategoryList" />&nbsp;
				</TD>
				<TD>
					<asp:DropDownList id="CategoryList" runat="Server" />
				</TD>
				<td width="100%">
				    &nbsp;
				    <cp:ModalButton runat="server" Height="300" Width="580" Callback="reloadCategories" ResourceName="CP_Blog_Links_EditCategory" id="EditCategory" />
				    &nbsp;
				    <cp:ModalButton runat="server" Height="150" Width="300" Callback="removeCategory" ResourceName="CP_Blog_Links_DeleteCategory" id="DeleteCategory" />
				</td>
				<TD>
					<cp:ModalButton runat="server" Url="~/ControlPanel/Blogs/LinkCategoryForm.aspx" resourcename="CP_Blog_Categories_NewSideBarList" callback="reloadCategories" Width="400" Height="300" />
				</TD>
			</TR>
		</TABLE>
	</DIV>
	<asp:Repeater Runat="server" id="LinkList">
		<HeaderTemplate>
			<div class="CommonListArea">
				<table id="Listing" cellSpacing="0" cellPadding="0" border="0" width="100%">
				<thead>
					<tr>
						<th class="CommonListHeaderLeftMost"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_ListItem" /></th>
						<th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Relations" /></th>
						<th class="CommonListHeader PostHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Enabled" /></th>
						<th class="CommonListHeader">&nbsp;</th>
					</tr>
				</thead>
		</HeaderTemplate>
		<ItemTemplate>
			<tr>
				<td class="CommonListCellLeftMost">
					<a target="_blank" href='<%# DataBinder.Eval(Container.DataItem, "Url") %>'>
						<%# DataBinder.Eval(Container.DataItem, "Title") %>
					</a>
					<br />
					<%# DataBinder.Eval(Container.DataItem, "Description") %>
				</td>
				<td class="CommonListCell">
					<%# DataBinder.Eval(Container.DataItem,"Rel") %>
					&nbsp;
				</td>
				<td class="CommonListCell PostViewsCell">
   				    <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsEnabled").ToString() %>.png" />
				</td>
				<td class="CommonListCell">
					<center>
					<cp:ModalButton runat="Server" Height="420" Width="550" callback="refreshCallback" resourcename="Edit" Url = '<%# "LinkForm.aspx?LinkID=" + DataBinder.Eval(Container.DataItem, "LinkID") + "&CategoryID=" +  DataBinder.Eval(Container.DataItem, "LinkCategoryID") %>' />
					&nbsp;
					<cp:ModalButton runat="Server" Height="150" Width="400" callback="refreshCallback" resourcename="Delete" Url = '<%# "BlogCommand.aspx?Command=CommunityServer.ControlPanel.Blogs.DeleteLinkCommand,CommunityServer.Web&LinkID=" + DataBinder.Eval(Container.DataItem, "LinkID") + "&CategoryID=" +  DataBinder.Eval(Container.DataItem, "LinkCategoryID") %>' />
					</center>
				</td>
			</tr>
		</ItemTemplate>
		<AlternatingItemTemplate>
			<tr>
				<td class="CommonListCellLeftMost">
					<a target="_blank" href='<%# DataBinder.Eval(Container.DataItem, "Url") %>'>
						<%# DataBinder.Eval(Container.DataItem, "Title") %>
					</a>
					<br />
					<%# DataBinder.Eval(Container.DataItem, "Description") %>
				</td>
				<td class="CommonListCell">
					<%# DataBinder.Eval(Container.DataItem,"Rel") %>
					&nbsp;
				</td>
				<td class="CommonListCell PostViewsCell">
				    <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsEnabled").ToString() %>.png" />
				</td>
				<td class="CommonListCell">
					<center>
					<cp:ModalButton runat="Server" Height="420" Width="550" callback="refreshCallback" resourcename="Edit" Url = '<%# "LinkForm.aspx?LinkID=" + DataBinder.Eval(Container.DataItem, "LinkID") + "&CategoryID=" +  DataBinder.Eval(Container.DataItem, "LinkCategoryID") %>' />
					&nbsp;
					<cp:ModalButton runat="Server" Height="150" Width="400" callback="refreshCallback" resourcename="Delete" Url = '<%# "BlogCommand.aspx?Command=CommunityServer.ControlPanel.Blogs.DeleteLinkCommand,CommunityServer.Web&LinkID=" + DataBinder.Eval(Container.DataItem, "LinkID") + "&CategoryID=" +  DataBinder.Eval(Container.DataItem, "LinkCategoryID") %>' />
					</center>
				</td>

			</tr>
		</AlternatingItemTemplate>
		<FooterTemplate>
			</table>
			</div>
		</FooterTemplate>
	</asp:Repeater>
	<div style="float:right;"><cp:ModalButton runat="server" Height="420" Width="550" Callback="refreshCallback" ResourceName="CP_Blog_Links_NewLink" id="NewLink" /></div>

</asp:Content>