<%@ Page language="c#" Codebehind="Files.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.Blogs.FilesPage" MasterPageFile="~/ControlPanel/Masters/Blogs.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcelabel id="title" runat="server" resourcename="CP_Blog_Files_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation runat="server" id="SelectedNavigation1" SelectedNavItem="BlogFiles" />
    <script>
    function refreshPage(res)
    {
        refresh();
    }

    function ToggleAddFolder()
    {
        var addFolderArea = document.getElementById("AddFolderArea");
        
        if (addFolderArea)
        {
            if (addFolderArea.style.display == "none") 
            {
                addFolderArea.style.display = "block";
            }
            else
            {
                addFolderArea.style.display = "none";
            }
                
        }
    }
    </script>

    <div class="CommonDescription">
	    <CP:ResourceControl runat="server" ResourceName="CP_Blog_Files_SubTitle" />
    </div>
    
	<CP:StatusMessage id="StatusMessage" runat="server" />

    <asp:placeholder id="ManageFilesPlaceholder" runat="server">
        <div class="PanelSaveButton">
            <input type="button" value='<%= CommunityServer.Components.ResourceManager.GetString("CP_Blog_Files_NewFolder", "ControlPanelResources.xml") %>' onclick="ToggleAddFolder()" />
        </div>
        <div id="AddFolderArea" style="display: none;" class="CommonSearchArea">
		    <CP:FormLabel runat="Server" ResourceName="CP_Blog_Files_FolderName" ControlToLabel="FolderName" />
	        &nbsp;
	        <asp:TextBox runat="server" id="FolderName" maxlength="250" />
	        &nbsp;
	        <CP:ResourceButton id="btnSave" ResourceName="Save" Runat="server" />
	        <asp:RegularExpressionValidator ValidationExpression="^[^\.\$\~\|\\\/].*" 
                         ControlToValidate="FolderName" Display="Dynamic"
                         ErrorMessage="<br/>Folder name starts with an invalid character." runat="server" />
        </div>
        <div class="CommonListArea">
            <asp:literal id="FolderLinks" runat="server" visible="False" />
            <CSControl:WrappedRepeater ShowHeaderFooterOnNone="false" runat="Server" id="FileGrid">
                <HeaderTemplate>
                <table id="CommentListing" cellSpacing="0" cellPadding="0" border="0" width="100%">
                    <thead>
                        <tr>
                        <th class="CommonListHeaderLeftMost"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_FolderName" /></th>
                        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Size" /></th>
                        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Actions" /></th>
                        </tr>
                    </thead>
                </HeaderTemplate>
                <ItemTemplate>
	                <tr>
	                <td class="CommonListCellLeftMost">
		                <asp:literal id="Icon" Runat="server" />
		                <cp:href id="Name" Runat="server" />
	                </td>
	                <td class="CommonListCell"><asp:literal id="Size" Runat="server" /></td>
	                <td  class="CommonListCell" nowrap="nowrap"><CP:ResourceButton CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_Blog_GridCol_Delete" /></td>
	                </tr>
                </ItemTemplate>
                <AlternatingItemTemplate>
	                <tr class="AltListRow">
	                <td class="CommonListCellLeftMost">
		                <asp:literal id="Icon" Runat="server" />
		                <cp:href id="Name" Runat="server" />
	                </td>
	                <td class="CommonListCell"><asp:literal id="Size" Runat="server" /></td>
	                <td  class="CommonListCell" nowrap="nowrap"><CP:ResourceButton CommandName="Delete" Runat="server" ID = "DeleteButton" ResourceName="CP_Blog_GridCol_Delete" /></td>
	                </tr>
                </AlternatingItemTemplate>
                <NoneTemplate>
                    <div class="CommonMessageWarning">
                        <table>
                            <tr>
                                <td style="width:35px">
		                            <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" />
                                </td>
                                
                                <td>
                                    <CP:ResourceControl runat="server" ResourceName="CP_Blog_Files_NoFiles" />
                                </td>
                            </tr>
                        </table>
                    </div>
                </NoneTemplate>
                <FooterTemplate></table></FooterTemplate>
            </CSControl:WrappedRepeater>
        </div>

        <div class="CommonSearchArea">
            <CP:FormLabel id="tt" runat="Server" ResourceName="CP_Blog_Files_UploadFile" ControlToLabel="BlogFileUpload" />&nbsp;<asp:FileUpload runat="server" id="BlogFileUpload" />
        </div>
    </asp:placeholder>

</asp:Content>