<%@ Page Language="C#" AutoEventWireup="false" CodeBehind="SortOrder.aspx.cs" Inherits="CommunityServer.ControlPanel.BlogAdmin.BlogsSortOrder" MasterPageFile="~/ControlPanel/Masters/BlogAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol id="SectionDescription" runat="server" resourcename="CP_BlogAdmin_Reorder_Title"></cp:resourcecontrol>
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <cp:controlpanelselectednavigation runat="server" SelectedNavItem="SortOrder" />
    
    <cp:StatusMessage id="Status" runat="server" visible="false" />
    <asp:PlaceHolder runat="server" ID="TreeWrapper">
    
    <div class="CommonDescription">
		<cp:resourcecontrol runat="server" resourcename="CP_BlogAdmin_Reorder_Description" />
	</div>
    
    <script type="text/javascript">
    // <![CDATA[

    function nodeMoved(tree, node, previousParent)
    {
        var ids = node.Value.split(':');
        
        if (ids[0] == "s")
        {
            if (!node.GetParentNode())
            {
                // cannot move a section to the root
                
                previousParent.AddNode(node);
                <%= theTree.ClientID %>.Refresh();
                
                alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_BlogAdmin_Tree_BlogMustBeInGroup") %>');
                return;
            }
        
            // its a section/blog
            var level = 0;
            var toSectionId = -1;
            var toGroupId = -1;
            
            var pNode = node.GetParentNode();
            var ids2 = pNode.Value.split(':');
            if (ids2[0] == 'g' && toGroupId == -1)
                toGroupId = ids2[1];
            
            var index = -1;
            for (var i = 0; i < pNode.GetNodeCount(); i++)
            {
                if (pNode.GetNodeAtIndex(i).Value == node.Value)
                {
                    index = i;
                    break;
                }
            }   
            
            BlogsSortOrder.MoveOrderBlog(ids[1], toGroupId, index, moveBlogCallback);
        }
        else
        {
            // its a group
        
            if (node.GetParentNode())
            {
                // cannot move a group away from root
                
                <%= theTree.ClientID %>.AddNode(node);        
                <%= theTree.ClientID %>.Refresh();
                
                alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_BlogAdmin_Tree_GroupInvalidMove") %>');
            }
            
            var index = -1;
            for (var i = 0; i < <%= theTree.ClientID %>.GetNodeCount(); i++)
            {
                if (<%= theTree.ClientID %>.GetNodeAtIndex(i).Value == node.Value)
                {
                    index = i;
                    break;
                }
            }            
            
            BlogsSortOrder.OrderGroups(ids[1], index, moveGroupCallback);
        }
    }

    function moveBlogCallback(res)
    {
	    if (res == null)
		    return;

	    if (res.value != "success")
		    alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_BlogAdmin_Tree_BlogSaveError") %>');
    }

    function moveGroupCallback(res)
    {
	    if (res == null)
		    return;

	    if (res.value != "success")
		    alert('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_BlogAdmin_Tree_GroupSaveError") %>');
    }

    // ]]>
    </script>

    <TWC:Tree runat="server" Width="600px" Height="400px" ID="theTree" OnNodeMovedClientFunction="nodeMoved" />
    </asp:PlaceHolder>
    
</asp:Content>