<%@ Control language="c#" Codebehind="SectionEditDetailsControl.ascx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.BlogAdmin.SectionEditDetailsControl" %>
<%@ Import Namespace="CommunityServer.Components" %>

<script type="text/javascript">
    function IsNewGroup(groupId)
    {
        var groupRow = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "newGroupRow").ClientID %>');
        if (groupRow && groupId != 0)
        {
            groupRow.style.visibility = "hidden";
            groupRow.style.position = "absolute";
            return;
        }  
        
        if (groupRow)
        {
            groupRow.style.visibility = "visible";
            groupRow.style.position = "relative";
        }
    }
    
    function IsNewGroupNameValid(sender, args)
    {
        var adminGroupList = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "AdminGroupList").ClientID %>');
        
        if (!adminGroupList || adminGroupList.value != 0)
        {
            args.IsValid = true;
            return;
        }
        
        var groupNameField = document.getElementById('<%= CommunityServer.Controls.CSControlUtility.Instance().FindControl(this, "NewGroupName").ClientID %>');
        
        if (!groupNameField || groupNameField.value.length < 1)
        {
            args.IsValid = false;
            return;
        }
        
        args.IsValid = true;    
        return;
    }
</script>

<CP:StatusMessage id="Status" runat="server"></CP:StatusMessage>
<table id="AdvancedProperties" width="100%" runat="server">
	<tr vAlign="top">
		<td class="CommonFormFieldName">
			<strong><CP:FORMLABEL id="Formlabel4" runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_Name" controltolabel="SectionName" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_Name_Detail" />
		</td>
		<td class="CommonFormField">
			<asp:textbox id="SectionName" columns="50" runat="server" maxlength="256" />
			<asp:requiredfieldvalidator id="SectionNameValidator" runat="server" controltovalidate="SectionName">*</asp:requiredfieldvalidator>
			<asp:RegularExpressionValidator ValidationExpression="^.*[^\s]+.*$" 
                     ControlToValidate="SectionName" Display="dynamic"
                     ErrorMessage="<br/>Name does not contain an alphanumeric character." runat="server" />
		</td>
	</tr>
	<tr>
		<td class="CommonFormFieldName" style="width:350px">
			<strong><CP:FORMLABEL id="Formlabel17" runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_AppKey" controltolabel="AppKey" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_AppKey_Detail" />
		</td>
		<td class="CommonFormField">
			<ASP:Literal Runat="server" ID="AppKeyUrlPrefix" />
			<asp:textbox id="AppKey" runat="server"  columns="50" maxlength="256" style="width: 100px;" /><ASP:Literal Runat="server" ID="AppKeyUrlSuffix" />
			<asp:CustomValidator id="AppKeyValidator" runat="server">*</asp:CustomValidator>
		</td>
	</tr>
	<tr>
		<td class="CommonFormFieldName">
			<strong><CP:FORMLABEL id="Formlabel18" runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_Owner" controltolabel="Owners" /> </strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_Owner_Detail" />
		</td>
		<td class="CommonFormField">
		    <CSControl:UserLookUpTextBox runat="server" ID="Owners" Width="275px" />
		</td>
	</tr>
	<tr runat="server" id="groupSelectRow">
		<td class="CommonFormFieldName" vAlign="top">
			<strong><CP:FORMLABEL id="Formlabel2" runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_Group" controltolabel="AdminGroupList" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_Group_Detail" />
		</td>
		<td class="CommonFormField">
			<asp:dropdownlist id="AdminGroupList" Runat="server" onchange="IsNewGroup(this.value)" />
			<asp:requiredfieldvalidator id="AdminGroupValidator" runat="server" ControlToValidate="AdminGroupList" ErrorMessage="*"></asp:requiredfieldvalidator>
		</td>
	</tr>
	<tr runat="server" id="newGroupRow" style="visibility: hidden; position:absolute;">
	    <td class="CommonFormFieldName" vAlign="top">
			<strong><CP:FORMLABEL runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_NewGroup" controltolabel="AdminGroupList" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_NewGroup_Detail" />
		</td>
		<td class="CommonFormField">
			<asp:TextBox runat="server" ID="NewGroupName" Text="Default" />
			<asp:CustomValidator runat="server" ClientValidationFunction="IsNewGroupNameValid" ErrorMessage="*" />
		</td>
	</tr>
	<tr runat="server" id="IsActive">
		<td class="CommonFormFieldName">
			<strong><CP:FORMLABEL id="Formlabel6" runat="Server" ResourceName="CP_BlogAdmin_SectionEdit_Settings_IsActive" controltolabel="ynIsActive" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_IsActive_Detail" />
		</td>
		<td class="CommonFormField">
			<CP:yesnoradiobuttonlist id="ynIsActive" runat="server"  repeatcolumns="2" />
		</td>
	</tr>
	<tr>
	    <td class="CommonFormFieldName"></td>
	    <td class="CommonFormField">
		    <CP:SectionIsPublicToggleButton runat="server" />	        
	    </td>
	</tr>
	<tr runat="server" id="EnableAggBugs">
		<td class="CommonFormFieldName">
			<strong><CP:FORMLABEL id="Formlabel1" runat="Server" resourcename="BlogSettings_EnableAggBugs" controltolabel="ynEnableAggBugs" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="BlogSettings_EnableAggBugs_Detail" />
		</td>
		<td class="CommonFormField">
			<cp:yesnoradiobuttonlist id="ynEnableAggBugs" runat="server"  repeatcolumns="2" />
		</td>
	</tr>
	<tr runat="server" id="IsSearchable">
		<td class="CommonFormFieldName">
			<strong><CP:FORMLABEL id="Formlabel16" runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_IsSearchable" controltolabel="ynIsSearchable" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_IsSearchable_Detail" />
		</td>
		<td class="CommonFormField">
			<cp:yesnoradiobuttonlist id="ynIsSearchable" runat="server"  repeatcolumns="2" />
		</td>
	</tr>
	<tr runat="server" id="IsCommunityAggregated">
		<td class="CommonFormFieldName">
			<strong><CP:formlabel id="Formlabel3" runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_IsCommunityAggregated" controltolabel="ynIsCommunityAggregated" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_IsCommunityAggregated_Detail" />
		</td>
		<td class="CommonFormField">
			<CP:yesnoradiobuttonlist id="ynIsCommunityAggregated" runat="server"  repeatcolumns="2" />
		</td>
	</tr>
	<tr runat="server" id="SectionLocalizationArea">
		<td class="CommonFormFieldName">
			<strong><CP:formlabel id="Formlabel5" runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_DefaultLanguage" controltolabel="DefaultLanguage" /></strong>
			<br />
			<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_Settings_DefaultLanguage_Detail" />
		</td>
		<td class="CommonFormField">
			<CP:FilterLanguageDropDownList runat="server" id="DefaultLanguage" />
		</td>
	</tr>
</table>