<%@ Register TagPrefix="CP" TagName = "SectionDetails" Src = "~/ControlPanel/BlogAdmin/SectionEditDetailsControl.ascx" %>
<%@ Control Language="c#" AutoEventWireup="false" Codebehind="SectionEditControl.ascx.cs" Inherits="CommunityServer.ControlPanel.BlogAdmin.SectionEditControl" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>

<cp:directorywriter location = "weblogs" unauthorizedresourcename="BlogSettings_UnAuthorizedException" 
	securityresourcename="BlogSettings_SecurityException" forecolor="Red" runat="Server" id="WeblogDirectoryWriter" />

<TWC:TabbedPanes id="SettingTabs" runat="server"
	PanesCssClass="CommonPane"
	TabSetCssClass="CommonPaneTabSet"
	TabCssClasses="CommonPaneTab"
	TabSelectedCssClasses="CommonPaneTabSelected"
	TabHoverCssClasses="CommonPaneTabHover"
	>
	<TWC:TabbedPane runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_SectionEdit_Tab_Settings" /></Tab>
		<Content>
			<CP:SectionDetails id="SectionDetails1" runat="Server"></CP:SectionDetails>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane runat="server" ID="MirrorFeedsTab">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_SectionEdit_Tab_Mirrors" /></Tab>
		<Content>
		    <script language = "javascript" type="text/javascript">
            function checkReload(res)
            {
	            if(res)
	            {
		            refresh();
	            }
            }
            </script>

			<div class="CommonFormDescription">
	            <ASP:Literal id="ExistingMessage" runat="Server" />
            </div>
			
			<div class="PanelSaveButton">
	            <CP:ModalLink CssClass="CommonTextButtonBig" ModalType="Link" Height="300" Width="600" runat="Server" ResourceName="CP_BlogAdmin_Feeds_CreateNewFeed" Callback="checkReload" id="NewFeed" />
            </div>

            <div class="CommonListArea">
            <table id="BlogLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
            <thead>
            <tr>
                <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_Feeds_List_Name" /></th>
                <th class="CommonListHeader"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_Feeds_List_Url" /></th>
                <th class="CommonListHeader"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_Feeds_List_PullInterval" /></th>
                <th class="CommonListHeader"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_Feeds_List_LastPull" /></th>    
                <th class="CommonListHeader"><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_Feeds_List_Actions" /></th>    
            </tr>
            </thead>
            <asp:Repeater runat="Server" id="mirrorFeeds">
            <ItemTemplate>
            <tr>
                <td class="CommonListCellLeftMost"><%# DataBinder.Eval(Container.DataItem,"Title")%></td>
                <td class="CommonListCell"><a href="<%# DataBinder.Eval(Container.DataItem,"Url")%>" target="_blank"><%# DataBinder.Eval(Container.DataItem,"Url")%></a></td>
                <td  class="CommonListCell"><%# DataBinder.Eval(Container.DataItem,"IntervalMinutes") %></td>
                <td  class="CommonListCell"><%# DataBinder.Eval(Container.DataItem,"LastUpdateDate") %></td>
	            <td class="CommonListCell" nowrap="true">
		            <input type="button" onclick="Telligent_Modal.Open('FeedForm.aspx?SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>&UrlID=<%# DataBinder.Eval(Container.DataItem,"UrlId") %>', 600, 300, checkReload);" value="Edit" />
		            <input type="button" onclick="if(confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_BlogAdmin_Feeds_DeleteWarning") %>')) window.location = 'BlogFeedsManage.aspx?action=delete&amp;SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>&amp;UrlID=<%# DataBinder.Eval(Container.DataItem,"UrlId")%>';" value="Delete" />
	            </td>    
            </tr>
            </ItemTemplate>
            <AlternatingItemTemplate>
            <tr class="AltListRow">
                <td class="CommonListCellLeftMost"><%# DataBinder.Eval(Container.DataItem,"Title")%></td>
                <td class="CommonListCell"><a href="<%# DataBinder.Eval(Container.DataItem,"Url")%>" target="_blank"><%# DataBinder.Eval(Container.DataItem,"Url")%></a></td>
                <td  class="CommonListCell"><%# DataBinder.Eval(Container.DataItem,"IntervalMinutes") %></td>
                <td  class="CommonListCell"><%# DataBinder.Eval(Container.DataItem,"LastUpdateDate") %></td>
	            <td class="CommonListCell" nowrap ="true">
    	            <input type="button" onclick="Telligent_Modal.Open('FeedForm.aspx?SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>&UrlID=<%# DataBinder.Eval(Container.DataItem,"UrlId") %>', 600, 300, checkReload);" value="Edit" />
		            <input type="button" onclick="if(confirm('<%= CommunityServer.ControlPanel.Components.ResourceManager.GetString("CP_BlogAdmin_Feeds_DeleteWarning") %>')) window.location = 'BlogFeedsManage.aspx?action=delete&amp;SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID")%>&amp;UrlID=<%# DataBinder.Eval(Container.DataItem,"UrlId")%>';" value="Delete" />
	            </td> 
            </tr>
            </AlternatingItemTemplate>
            </asp:Repeater>
            </table>
            </div>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane ID="SectionPermissions" runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_SectionEdit_Tab_Permissions" /></Tab>
		<Content>
		    <div>
                <asp:DropDownList runat="server" ID="UnchangedPermissionsList" DataTextField="Name" DataValueField="Name" />
                <asp:Button runat="server" ID="AddUserPermissionButton" Text="Add Role" />
            </div>
            <br />
            <CP:RepeaterPlusNone runat="server" ID="PermissionList" ShowHeaderFooterOnNone="false">
                <HeaderTemplate>
                    <table cellSpacing=0 cellPadding=0 width="100%">
                    <tbody>
                        <tr>
                            <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Forums_GridCol_Name" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_View" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_Post" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_Reply" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Video" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_LocalAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_RemoteAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                        </tr>    
                </HeaderTemplate>
                <ItemTemplate>
                        <tr class="Row">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </ItemTemplate>
                <AlternatingItemTemplate>
                        <tr class="AlternatingRow">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </AlternatingItemTemplate>
                <FooterTemplate>
                    </tbody>
                    </table>
                </FooterTemplate>
                <NoneTemplate>
                    <div class="CommonMessageWarning">
                        <CP:ResourceControl runat="server" ResourceName="CP_Blog_NoPermissionsMessage" />
                    </div>
                </NoneTemplate>
            </CP:RepeaterPlusNone>
		</Content>
	</TWC:TabbedPane>
	<TWC:TabbedPane id="MailingListTab" runat="server">
		<Tab><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_SectionEdit_Tab_BlogByEmail" /></Tab>
		<Content>
		    <table cellspacing="0" cellpadding="2" border="0">
		    <tr>
			    <td class="CommonFormFieldName">
				    <strong><cp:resourcelabel id="Resourcelabel9" runat="server" resourcename="CP_BlogAdmin_SectionEdit_LE_EnableMailingList" /></strong><br />
				    <cp:ResourceControl runat="Server" resourcename="CP_BlogAdmin_SectionEdit_LE_EnableMailingList_Detail" /></td>
			    <td class="CommonFormField">
				    <cp:yesnoradiobuttonlist id="LEEnableMailingList" runat="server"  repeatcolumns="2"></cp:yesnoradiobuttonlist>
			    </td>
		    </tr>
		    </table>
		</Content>
	</TWC:TabbedPane>
</TWC:TabbedPanes>
