<%@ Page language="c#" Codebehind="GeneralOptions.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.BlogAdmin.GeneralOptionsPage" MasterPageFile="~/ControlPanel/Masters/BlogAdmin.master" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="BlogSettingsGeneral" />
	<div class="CommonDescription">
		<CP:ResourceControl runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_Instructions" />
	</div>
	
	<CP:FileOnlyStatusMessage id="FOStatus" runat="server" visible="false" />
	<asp:PlaceHolder id="OptionHolder" runat="Server">
	<CP:ConfigOKStatusMessage id="Status" runat="server" visible="false" />
		<table cellpadding="0" cellspacing="0" border="0">
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_CreateDirectories" controltolabel="createDirectories" /></strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_CreateDirectories_Help" />
		</td>
		<td class="CommonFormField">
			<CP:YesNoRadioButtonList id="createDirectories" runat="Server" repeatcolumns="2" />
		</td>
		</tr>
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_AutoCreate" controltolabel="checkAutoCreate" /></strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_AutoCreate_Help" />
		</td>
		<td class="CommonFormField">
			<CP:YesNoRadioButtonList id="checkAutoCreate" runat="Server" repeatcolumns="2" />
		</td>
		</tr>
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_EnableCrossPosting" controltolabel="EnableCrossPosting" /></strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_EnableCrossPosting_Help" />
		</td>
		<td class="CommonFormField">
			<CP:YesNoRadioButtonList id="EnableCrossPosting" runat="Server" repeatcolumns="2" />
		</td>
		</tr>
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_EnableRawHeadEditing" controltolabel="EnableRawHeadEditing" /></strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_EnableRawHeadEditing_Help" />
		</td>
		<td class="CommonFormField">
			<CP:YesNoRadioButtonList id="EnableRawHeadEditing" runat="Server" repeatcolumns="2" />
		</td>
		</tr>
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_EnableEmailSubscriptions" controltolabel="EnableEmailSubscriptions" /></strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_EnableEmailSubscriptions_Help" />
		</td>
		<td class="CommonFormField">
			<CP:YesNoRadioButtonList id="EnableEmailSubscriptions" runat="Server" repeatcolumns="2" />
		</td>
		</tr>

		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_AutoCreateDefaultGroup" controltolabel="GroupList" />&nbsp;</strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_AutoCreateDefaultGroup_Help" />
		</td>
		<td class="CommonFormField">
			<asp:dropdownlist id="GroupList" runat="Server" cssclass="ControlPanelTextInput" width = "300px" />
		</td>
		</tr>
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_PingServices" controltolabel="PingServices" />&nbsp;</strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_PingServices_Help" />
		</td>
		<td class="CommonFormField">
			<asp:textbox id="PingServices" runat="Server" cssclass="ControlPanelTextInput" width="300" TextMode="Multiline" Rows="5"></asp:textbox>
		</td>
		</tr>

		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_AggregateTags" controltolabel="PingServices" />&nbsp;</strong>
			<br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_AggregateTags_Help" />
		</td>
		<td class="CommonFormField">
			<asp:textbox id="AggregateTags" runat="Server" cssclass="ControlPanelTextInput" width="300" TextMode="Multiline"></asp:textbox>
		</td>
		</tr>
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_ServicePostCountLimit" controltolabel="ServicePostCountLimit" />&nbsp;</strong>
		    <asp:CompareValidator runat = "Server" ControlToValidate="ServicePostCountLimit" Operator = "DataTypeCheck" Type="Integer" Display="Dynamic">Limit must be an integer</asp:CompareValidator>
		    <br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_ServicePostCountLimit_Help" />
		</td>
		<td class="CommonFormField">
			<asp:textbox id="ServicePostCountLimit" runat="Server" cssclass="ControlPanelTextInput" width="300"></asp:textbox>
		</td>
		</tr>
		
		<tr>
		<td class="CommonFormFieldName">
			<strong><cp:formlabel runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_ContactThreshold" controltolabel="ServicePostCountLimit" />&nbsp;</strong>
		    <asp:CompareValidator runat = "Server" ControlToValidate="ServicePostCountLimit" Operator = "DataTypeCheck" Type="Integer" Display="Dynamic">Threshold must be an integer</asp:CompareValidator>
		    <br />
			<cp:resourcecontrol runat="Server" resourcename="CP_BlogAdmin_Options_GeneralSettings_ContactThreshold_Help" />
		</td>
		<td class="CommonFormField">
			<asp:textbox id="ContactRequestModerationThreshold" runat="Server" cssclass="ControlPanelTextInput" width="300"></asp:textbox>
		</td>
		</tr>		
        <tr>
		    <td colspan="2">
		        <div class="CommonFormFieldName">
		        <strong>Roles that can create blogs</strong>
		        <br />
		        Select the roles that you want to be able to create a blog.
		        </div>
		        <div class="RolesFormFieldArea">
		             <asp:Repeater runat="server" ID="CreateBlogRoleList">
		                <ItemTemplate>
		                    <div class="RoleCheckArea">
		                        <%# Eval("Name") %>
		                        <asp:CheckBox runat="server" ID="RoleCheckbox" Checked='<%# CanRoleCreateBlog(Container.DataItem) %>' />
		                        <asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleID") %>' Visible="false" />
		                    </div>
		                </ItemTemplate>
		             </asp:Repeater>
		        </div>
		    </td>
		</tr>
		
        
		</table>
	<p class="PanelSaveButton">
		<cp:ResourceButton id="SaveButton" runat="Server" resourcename="Save" />
	</p>
	</asp:PlaceHolder>
</asp:Content>