<%@ Page language="c#" Codebehind="Groups.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.BlogAdmin.GroupsPage" MasterPageFile="~/ControlPanel/Masters/BlogAdmin.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol runat="server" resourcename="CP_BlogAdmin_Blogs_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="BlogGroups" />
	
    <script type="text/javascript">
      function reloadPage()
      {
        window.location = window.location;
      }
    </script>

    <div class="CommonDescription">
        <CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_GroupList_Description" />
    </div>
    
    <p style="text-align: right;">
        <input type=button onclick="window.location = 'GroupForm.aspx?GroupID=-1';" runat="Server" value='Add New Group' />
    </p>
    <div class="CommonListArea" style="clear:both">
        <CSControl:WrappedRepeater runat = "Server" id = "theGroups">
            <HeaderTemplate>
                <table id="GroupLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
                <thead>
                <tr>
                    <th class="CommonListHeaderLeftMost">Group Name</th>
                    <th class="CommonListHeader" ><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Description" /></th>
                    <th class="CommonListHeader">&nbsp;</th>
                </tr>
                </thead>
            </HeaderTemplate>
            <ItemTemplate>
                <tr>
                    <td class="CommonListCellLeftMost">
                        <a href="<%# CommunityServer.Blogs.Components.BlogUrls.Instance().GroupHome(int.Parse(Eval("GroupID").ToString())) %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a>
                    </td>
                    <td class="CommonListCell">
                        <%# DataBinder.Eval(Container.DataItem,"Description") %>&nbsp;
                    </td>
                    <td class="CommonListCell">
                        <input type="button" onclick="window.location = 'GroupForm.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Edit" />
                        <input type="button" onclick="window.location = 'Blogs.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Manage" /> 
                        <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("GroupID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this blog group?');" ResourceName="CP_PermissionList_Delete" />
                    </td>
                </tr>
            </ItemTemplate>
            <AlternatingItemTemplate>
                <tr class="AltListRow">
                    <td class="CommonListCellLeftMost">
                        <a href="<%# CommunityServer.Blogs.Components.BlogUrls.Instance().GroupHome(int.Parse(Eval("GroupID").ToString())) %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a>
                    </td>
                    <td class="CommonListCell">
                        <%# DataBinder.Eval(Container.DataItem,"Description") %>&nbsp;
                    </td>
                    <td class="CommonListCell">
                        <input type="button" onclick="window.location = 'GroupForm.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Edit" />
                        <input type="button" onclick="window.location = 'Blogs.aspx?GroupID=<%# DataBinder.Eval(Container.DataItem,"GroupID") %>';" value="Manage" /> 
                        <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("GroupID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this blog group?');" ResourceName="CP_PermissionList_Delete" />
                    </td>
                </tr>
            </AlternatingItemTemplate>
            <FooterTemplate>
                </table>
            </FooterTemplate>
            <NoneTemplate>
                <tr>
                    <td colspan="6">
                        <div class="CommonMessageWarning">
                            <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" width="16" height="16" />
                            <CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_GroupList_NoGroups" />
                        </div>
                    </td>
                </tr>
            </NoneTemplate>	
        </CSControl:WrappedRepeater>
    </div>
    
</asp:Content>