<%@ Page language="c#" Codebehind="GroupForm.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.BlogAdmin.GroupForm" MasterPageFile="~/ControlPanel/Masters/BlogAdmin.master" %>
<%@ Register TagPrefix="CP" TagName = "GroupEditControl" Src = "~/ControlPanel/Controls/GroupEditControl.ascx" %>
<%@ Import Namespace="CommunityServer.Components" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server" />

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation ID="ControlPanelSelectedNavigation1" runat="server" SelectedNavItem="BlogGroups" />
    <asp:Panel runat="server" DefaultButton="SaveButton">
    <TWC:TabbedPanes runat="server"
        PanesCssClass="CommonPane"
        TabSetCssClass="CommonPaneTabSet"
        TabCssClasses="CommonPaneTab"
        TabSelectedCssClasses="CommonPaneTabSelected"
        TabHoverCssClasses="CommonPaneTabHover"
    >
    <TWC:TabbedPane runat="server">
        <Tab><CP:ResourceControl runat="server" ResourceName="CP_Forums_SectionEdit_Tab_Basic" /></Tab>
        <Content>
            <CP:GroupEditControl id="GroupEditControl1" runat="server" />
        </Content>
    </TWC:TabbedPane>
    <TWC:TabbedPane runat="server" ID="PermissionsTab">
        <Tab><CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_SectionEdit_Tab_Permissions" /></Tab>
        <Content>
            <div>
                <asp:DropDownList runat="server" ID="UnchangedPermissionsList" DataTextField="Name" DataValueField="Name" />
                <asp:Button runat="server" ID="AddUserPermissionButton" Text="Add Role" />
            </div>
            <br />
	        <div id="GrayGrid">
            <CP:RepeaterPlusNone runat="server" ID="PermissionList" ShowHeaderFooterOnNone="false">
                <HeaderTemplate>
                    <table class="Grid" cellSpacing=0 cellPadding=0 width="100%">
                    <tbody>
                        <tr>
                            <th class="CommonListHeaderLeftMost"><CP:ResourceControl runat="server" ResourceName="CP_Forums_GridCol_Name" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_View" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_Post" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_Reply" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_PermissionList_Video" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_LocalAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter"><CP:ResourceControl runat="server" ResourceName="CP_Blog_GridCol_RemoteAttachment" /></th>
                            <th class="CommonListHeader PermissionHeaderCenter">&nbsp;</th>
                        </tr>    
                </HeaderTemplate>
                <ItemTemplate>
                        <tr class="Row">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </ItemTemplate>
                <AlternatingItemTemplate>
                        <tr class="AlternatingRow">
                            <td class="CommonListCellLeftMost"><%# Eval("Name") %><asp:HiddenField ID="RoleId" runat="server" Value='<%# Eval("RoleIDString") %>' Visible="false" /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ViewCheckbox" Checked='<%# Eval("View") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="PostCheckbox" Checked='<%# Eval("Post") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="ReplyCheckbox" Checked='<%# Eval("Reply") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="VideoCheckbox" Checked='<%# Eval("Video") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="LocalAttachmentCheckbox" Checked='<%# Eval("LocalAttachment") %>' /></td>
                            <td class="CommonListCell Status"><asp:CheckBox runat="server" ID="RemoteAttachmentCheckbox" Checked='<%# Eval("RemoteAttachment") %>' /></td>
                            <td class="CommonListCell Status"><CP:ResourceButton runat="server" CommandName="Revert" CommandArgument='<%# Eval("Name") %>' OnClientClick="return confirm('Are you sure you want to restore the default permissions for this role?');" ResourceName="CP_Forum_RevertPermission" /></td>
                        </tr>
                </AlternatingItemTemplate>
                <FooterTemplate>
                    </tbody>
                    </table>
                </FooterTemplate>
                <NoneTemplate>
                    <div class="CommonMessageWarning">
                        <CP:ResourceControl runat="server" ResourceName="CP_Blog_NoPermissionsMessage" />
                    </div>
                </NoneTemplate>
            </CP:RepeaterPlusNone>
            </div>
        </Content>
    </TWC:TabbedPane>
    </TWC:TabbedPanes>
    </asp:Panel>
    <p class="PanelSaveButton DetailsFixedWidth">
		<cp:resourcebutton id="SaveButton" runat="server" resourcename="Save" />
    </p>
</asp:Content>