<%@ Page language="c#" Codebehind="Blogs.aspx.cs" AutoEventWireup="false" Inherits="CommunityServer.ControlPanel.BlogAdmin.BlogsPage" MasterPageFile="~/ControlPanel/Masters/BlogAdmin.master" %>
<%@ Import Namespace = "CommunityServer.Components" %>
<%@ Import Namespace = "CommunityServer.Blogs.Components" %>
<%@ Import Namespace = "CommunityServer.ControlPanel" %>

<asp:Content ContentPlaceHolderId="DescriptionRegion" runat="server">
	<cp:resourcecontrol runat="server" resourcename="CP_BlogAdmin_Blogs_Title" />
</asp:Content>

<asp:Content ContentPlaceHolderId="TaskRegion" runat="Server">
    <CP:ControlPanelSelectedNavigation runat="server" SelectedNavItem="BlogBlogs" />
	
    <script type="text/javascript">
      function reloadPage()
      {
        window.location = window.location;
      }
    </script>
    
    <div class="CommonDescription">
        <CSControl:ConditionalContent runat="server">
            <ContentConditions>
                <CSControl:QueryStringPropertyValueComparison runat="server" QueryStringProperty="SectionID" Operator="GreaterThan" ComparisonValue="-1" />
            </ContentConditions>
            <TrueContentTemplate>
                <CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_NewBlog_Message">
                    <Parameter1Template><CSBlog:WeblogData runat="server" Property="Name" LinkTo="HomePage" /></Parameter1Template>
                </CP:ResourceControl>
            </TrueContentTemplate>
            <FalseContentTemplate>
                <cp:resourcecontrol runat="server" resourcename="CP_BlogAdmin_Blogs_Description" />
            </FalseContentTemplate>
        </CSControl:ConditionalContent>
    </div>
    
    <table border="0" cellpadding="3" cellspacing="0" width="100%">
        <tr>
            <td><cp:AlphaPicker runat = "Server" id = "picker" /></td>
            <td align="right"><input type="text" id = "q" name="q" value ="<%= Server.HtmlEncode(Request.QueryString["q"]) %>"></input> <input type="button" onclick="javascript:window.location = window.location.pathname + '?q=' + escape(q.value)" value ="Search" /></td>
        </tr>
    </table>
    			
    <div class="CommonListArea" style="clear:both">
    <CSControl:WrappedRepeater runat = "Server" id = "theBlogs">
    <HeaderTemplate>
    <table id="BlogLists" cellSpacing="0" cellPadding="0" border="0" width="100%">
    <thead>
    <tr>
        <th class="CommonListHeaderLeftMost"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Title" ID="Resourcecontrol6" NAME="Resourcecontrol4"/></th>
        <th class="CommonListHeader" ><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Url" ID="Resourcecontrol5" NAME="Resourcecontrol3"/></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Group" ID="Resourcecontrol8" NAME="Resourcecontrol4"/></th>
        <th class="CommonListHeader"><cp:resourcecontrol runat="server" resourcename="CP_Blog_GridCol_Enabled" ID="Resourcecontrol9" NAME="Resourcecontrol4"/></th>    
        <th class="CommonListHeader">&nbsp;</th>
    </tr>
    </thead>
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td class="CommonListCellLeftMost"><a href="<%# CommunityServer.Blogs.Components.BlogUrls.Instance().HomePage(Eval("ApplicationKey").ToString()) %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a></td>
        <td class="CommonListCell"><a href="SectionEdit.aspx?tab=blog&amp;SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>">/<%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50) %>/</a></td>
        <td class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
        <td class="CommonListCell Status"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.png" /></td>    
        <td class ="CommonListCell" nowrap="nowrap">
            <input type="button" onclick="javascript:window.location='SectionEdit.aspx?tab=blog&SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>'" value="Edit" />
            <input type="Button" onclick="javascript:window.location='../blogs/default.aspx?tab=manage&sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>'" value="Manage" />
            <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this blog?');" ResourceName="CP_PermissionList_Delete" />
        </td>
    </tr>
    </ItemTemplate>
    <AlternatingItemTemplate>
    <tr class="AltListRow">
        <td class="CommonListCellLeftMost"><a href="<%# CommunityServer.Blogs.Components.BlogUrls.Instance().HomePage(Eval("ApplicationKey").ToString()) %>"><%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"Name").ToString(), 50)%></a></td>
        <td class="CommonListCell"><a href="SectionEdit.aspx?tab=blog&amp;SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>">/<%# Formatter.RemoveHtml(DataBinder.Eval(Container.DataItem,"ApplicationKey").ToString(), 50) %>/</a></td>
        <td class="CommonListCell" nowrap="nowrap"><%# DataBinder.Eval(Container.DataItem,"GroupName") %></td>
        <td class="CommonListCell Status"><img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/<%# DataBinder.Eval(Container.DataItem,"IsActive").ToString() %>.png" /></td>    
        <td class ="CommonListCell" nowrap="nowrap">
            <input type="button" onclick="javascript:window.location='SectionEdit.aspx?tab=blog&SectionID=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>'" value="Edit" />
            <input type="Button" onclick="javascript:window.location='../blogs/default.aspx?tab=manage&sectionid=<%# DataBinder.Eval(Container.DataItem,"SectionID") %>'" value="Manage" />
            <CP:ResourceButton runat="server" ID="DeleteButton" CommandArgument='<%# Eval("SectionID") %>' CommandName="Delete" OnClientClick="return confirm('Are you sure you want to delete this blog?');" ResourceName="CP_PermissionList_Delete" />
        </td>
    </tr>
    </AlternatingItemTemplate>
    <FooterTemplate>
    </table>
    </FooterTemplate>
    <NoneTemplate>
        <tr>
            <td colspan="6">
                <div class="CommonMessageWarning">
                    <img src="<%=SiteUrls.Instance().Locations["ControlPanel"]%>images/comment/spam.png" width="16" height="16" />
                    <CP:ResourceControl runat="server" ResourceName="CP_BlogAdmin_Blogs_FilterResults" />
                </div>
            </td>
        </tr>
    </NoneTemplate>		
    </CSControl:WrappedRepeater>
    </div>
	   
</asp:Content>