SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_vw_Users_FullUser]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[cs_vw_Users_FullUser]
GO

Create View [dbo].cs_vw_Users_FullUser
as

SELECT
	U.AppUserToken,
	U.Email,
	U.ForceLogin,
	U.IsAnonymous,
	U.LastAction,
	U.LastActivity,
	U.MembershipID,
	U.UserAccountStatus,
	U.UserID,
	U.UserName,
	U.CreateDate,
	UP.AllowSitePartnersToContact,
	UP.AllowSiteToContact,
	UP.EnableAvatar,
	UP.EnableDisplayInMemberList,
	UP.EnableDisplayUnreadThreadsOnly,
	UP.EnableEmail,
	UP.EnableHtmlEmail,
	UP.EnableOnlineStatus,
	UP.EnablePrivateMessages,
	UP.EnableThreadTracking,
	UP.EnableFavoriteSharing,
	UP.IsAvatarApproved,
	UP.IsIgnored,
	UP.ModerationLevel,
	UP.Points as UserPoints,
	UP.PostRank,
	UP.PostSortOrder,
	UP.PropertyNames as UserPropertyNames,
	UP.PropertyValues as UserPropertyValues,
	UP.PublicToken,
	UP.SettingsID,
	UP.TimeZone,
	UP.TotalPosts
FROM
	cs_Users U (nolock)
	INNER JOIN cs_UserProfile UP (nolock) ON U.UserID = UP.UserID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant select on [dbo].[cs_vw_Users_FullUser] to public
