SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_weblog_UpdateWeblogRecentContent_Job]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [dbo].[cs_weblog_UpdateWeblogRecentContent_Job]
GO

Create Proc [dbo].[cs_weblog_UpdateWeblogRecentContent_Job]
(
	@SettingsID int
)
as

SET Transaction Isolation Level Read UNCOMMITTED

set nocount on

Update w
Set
	w.MostRecentPostID = P.PostID,
	w.MostRecentPostDate = P.UserTime,
	w.MostRecentPostName = P.PostName,
	w.MostRecentPostAuthorID = P.UserID,
	w.MostRecentPostAuthor = P.PostAuthor,
	w.MostRecentPostSubject = P.Subject
FROM
	cs_weblog_Weblogs w
inner join (
		Select Max(px.PostID) as PostID, px.SectionID
		FROM cs_Posts px
		where px.ApplicationPostType = 1 and px.IsApproved = 1 and px.UserTime <= getdate() and px.SettingsID = @SettingsID
		Group by px.SectionID
	) sub
	ON w.SectionID = sub.SectionID
inner join
	cs_Posts P on P.PostID = sub.PostID
where
	w.SettingsID = @SettingsID



--We may be able to can the articles part
Update w
Set
	w.MostRecentArticleID = P.PostID ,
	w.MostRecentArticleDate = P.UserTime,
	w.MostRecentArticleName = P.PostName,
	w.MostRecentArticleAuthorID = P.UserID,
	w.MostRecentArticleAuthor = P.PostAuthor,
	w.MostRecentArticleSubject = P.Subject
FROM
	cs_weblog_Weblogs w
inner join (
		Select Max(p.PostID) as PostID, p.SectionID
		FROM cs_Posts p
		where p.ApplicationPostType = 2 and p.IsApproved = 1 and p.UserTime <= getdate() and p.SettingsID = @SettingsID
		Group by p.SectionID
	) sub
	ON w.SectionID = sub.SectionID
inner join
	cs_Posts P on P.PostID = sub.PostID
where
	w.SettingsID = @SettingsID


--Update Count Items
update w
set
	w.PostCount = p.[PostCount]
	, w.ArticleCount = p.[ArticleCount]
	, w.CommentCount = p.[CommentCount]
	, w.TrackbackCount = p.[TrackbackCount]
from
	cs_weblog_Weblogs w
inner join (
	Select
		px.SectionID
		, sum(case when px.ApplicationPostType = 1 then 1 else 0 end) [PostCount]
		, sum(case when px.ApplicationPostType = 2 then 1 else 0 end) [ArticleCount]
		, sum(case when px.ApplicationPostType = 4 then 1 else 0 end) [CommentCount]
		, sum(case when px.ApplicationPostType = 8 then 1 else 0 end) [TrackbackCount]
	FROM
		cs_Posts px
	where
		px.SettingsID = @SettingsID
		AND px.IsApproved = 1
	group by
		px.SectionID
) as p
ON
	w.SectionID = p.SectionID
where
	w.SettingsID = @SettingsID


-- Update Weblog Section records.
-- NOTE: Other applications update the Section table stats via cs_system_UpdateForum, called from cs_Post_CreateUpdate
UPDATE s
SET
	s.TotalPosts = isnull((Select Count(*) FROM cs_Posts p where p.SettingsID = s.SettingsID and p.SectionID = s.SectionID and p.IsApproved = 1), 0),
	s.TotalThreads = isnull((Select Count(*) FROM cs_Posts p where p.SettingsID = s.SettingsID and p.SectionID = s.SectionID and p.IsApproved = 1 and p.PostLevel = 1), 0),
	-- For weblogs, only count feedback that is not approved (ignore posts/articles)
	s.PostsToModerate = isnull((SELECT Count(*) FROM cs_Posts p WHERE p.SettingsID = s.SettingsID and p.SectionID = s.SectionID AND p.IsApproved = 0 and p.PostLevel > 1 and (p.PostStatus & 2) <> 2), 0)
FROM
	cs_Sections s
WHERE
	s.SettingsID = @SettingsID
	and s.ApplicationType = 1


-- Update any hubs that have weblogs
UPDATE
	H
SET
	H.MostRecentPostID = W.MostRecentPostID,
	H.MostRecentPostAuthorID = W.MostRecentPostAuthorID,
	H.MostRecentPostSubject = W.MostRecentPostSubject,
	H.MostRecentPostAuthor = W.MostRecentPostAuthor,
	H.MostRecentPostDate = W.MostRecentPostDate
FROM
	cs_Sections H
inner join (
		Select S.HubSectionID, S.SectionID FROM cs_Sections S
		where S.ApplicationType = 1 and S.HubSectionID > 0 and S.SettingsID = @SettingsID
		Group by S.SectionID, S.HubSectionID
	) sub ON H.SectionID = sub.HubSectionID
inner join
	cs_weblog_Weblogs W
	ON W.SectionID = sub.SectionID
where
	H.SettingsID = @SettingsID

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

grant execute on [dbo].[cs_weblog_UpdateWeblogRecentContent_Job] to public
go
