SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_weblog_PostsByMonthList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_weblog_PostsByMonthList]
GO


CREATE proc [dbo].cs_weblog_PostsByMonthList
(
	@SectionID int
)
as
begin

	SET Transaction Isolation Level Read UNCOMMITTED

	select
		CAST(t.[Month] as int) as [Month], cast(t.[Year] as int) as [Year], 1 as [Day], t.[PostCount] as [Count]
	from
		dbo.cs_vw_weblog_PostByYearMonth t
	where
		t.[SectionID] = @SectionID
		and t.[Year] > 0
		and t.[Month] > 0
		and t.[Day] = 255
	order by [Year] desc, [Month] desc

end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_weblog_PostsByMonthList] to public
go