SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_weblog_PostsByMonth]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_weblog_PostsByMonth]
GO


CREATE proc [dbo].cs_weblog_PostsByMonth
(
	@SectionID int,
	@Year int,
	@Month int
)
as
begin

	SET Transaction Isolation Level Read UNCOMMITTED
	declare @tYear smallint, @tMonth tinyint

	-- let's convert to make sure these are in the right range
	select @tYear = convert(smallint, @Year), @tMonth = convert(tinyint, @Month)

	select
		@Month as [Month], @Year as [Year], cast(t.[Day] as int) as [Day], t.[PostCount] as [Count]
	from
		dbo.cs_vw_weblog_PostByYearMonth t
	where
		t.[SectionID] = @SectionID
		and t.[Year] = @tYear
		and t.[Month] = @tMonth
		and t.[Day] < 255 -- we store the month level data where Day == 255
	order by [Day] asc

end

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_weblog_PostsByMonth] to public
go