SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_weblog_DeleteStaleSpamComments]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_weblog_DeleteStaleSpamComments]
GO
CREATE PROCEDURE [dbo].[cs_weblog_DeleteStaleSpamComments]
(
	@SettingsID int,
	@ExpirationDays int = 2,
	@Increment int = 250 /* new parameter that is default */
)
AS
BEGIN

	/* temporarily store posts to delete */
	set nocount on

	declare @curdate datetime
		, @purgeDate datetime
		, @bottom int
		, @top int
		, @possibleSpamPurgeDate datetime
		, @PossibleSpamExpirationDays int
		, @rc int

	create table #Posts (
		id int identity(1, 1) not null primary key clustered
		, PostID int not null
	)

	select
		@curdate = GETDATE()
		/* ensuring @ExpirationDays has a value */
		, @ExpirationDays = COALESCE( @ExpirationDays, 2 )
		/* set a purgedate based on the days in the past to truncate from */
		, @purgeDate = dateadd(day, -1 * @ExpirationDays, @curdate )
		/* ensuring @Increment has a value */
		, @Increment = COALESCE( @Increment, 250 )
		/*	seed the top at zero.  This is so logic for determining the next 'top' is cleaner */
		, @top = 0
		/* initial rowcount */
		, @rc = 0
		/* range checking.  If ExpirationDays exceeds half of the max value of INT, then make it the max value of INT */
		, @PossibleSpamExpirationDays = case when @ExpirationDays >= cast(0x7fffffff as int) / 2
			then cast(0x7fffffff as int) else @ExpirationDays * 2 end
		/* set a purgedate based on the days in the past to truncate from */
		, @possibleSpamPurgeDate = dateadd(day, -1 * @PossibleSpamExpirationDays, @curdate )

	print 'Calculating spam posts to be deleted: ' + convert(char(19), getdate(), 120)

	/* inserting for definite spam */
	INSERT INTO #Posts (PostID)
	SELECT P.PostID FROM cs_Posts P (nolock)
	INNER JOIN
		cs_Sections S (nolock) on P.SettingsID = S.SettingsID and P.SectionID = S.SectionID
	WHERE
		S.SettingsID = @SettingsID
		AND (
			( S.ApplicationType = 1	/* only weblogs */
            AND P.ApplicationPostType IN (4, 8)	) /* only comments/trackbacks */
			OR
			( S.ApplicationType = 13 /* only media gallery */
            AND P.ApplicationPostType = 1 ) /* only comments */
		)
		AND	(P.PostStatus & 2) = 2			/* only posts marked as DEFINITE spam */
		AND P.IsApproved = 0				/* make sure they are not approved */
		AND P.PostLevel > 1					/* ensure they are replies only */
		AND	P.PostDate < @purgeDate			/* only posts that have been around for a while */

	set @rc = @rc + @@ROWCOUNT

	/* inserting possible spam from weblog posts */
	INSERT INTO #Posts (PostID)
	SELECT P.PostID FROM cs_Posts P (nolock)
	INNER JOIN
		cs_Sections S (nolock) on P.SettingsID = S.SettingsID and P.SectionID = S.SectionID
	WHERE
		S.SettingsID = @SettingsID
		AND (
			( S.ApplicationType = 1	/* only weblogs */
            AND P.ApplicationPostType IN (4, 8)	) /* only comments/trackbacks */
			OR
			( S.ApplicationType = 13 /* only media gallery */
            AND P.ApplicationPostType = 1 ) /* only comments */
		)
		AND	(P.PostStatus & 4) = 4			/* only posts marked as POSSIBLE spam */
		AND P.IsApproved = 0				/* make sure they are not approved */
		AND P.PostLevel > 1					/* ensure they are replies only */
		AND	P.PostDate < @possibleSpamPurgeDate	/* only posts that have been around for a while */

	set @rc = @rc + @@ROWCOUNT

	print 'Total number of spam posts that will be deleted: ' + cast(@rc as varchar) + ': ' + convert(char(19), getdate(), 120)

	while ( 1 = 1 )
	begin

		select
			@top = @top + @Increment
			, @bottom = @top + 1 - @Increment
		
		print 'Deleting from index ' + cast(@bottom as varchar) + ' to ' + cast(@top as varchar) + ': ' + convert(char(19), getdate(), 120)

		delete p
		from cs_Posts P
		inner join
			#Posts px on P.PostID = px.PostID
		where
			px.id between @bottom and @top

		if @@ROWCOUNT < @Increment begin break end

	end

	drop table #Posts

END
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


grant execute on [dbo].[cs_weblog_DeleteStaleSpamComments] to public
go
